/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.RebornCore;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.NBTSerializable;
import reborncore.common.util.RebornInventory;

public class SlotConfiguration
implements NBTSerializable {
    List<SlotConfigHolder> slotDetails = new ArrayList<SlotConfigHolder>();
    @Nullable
    class_1263 inventory;

    public SlotConfiguration(RebornInventory<?> inventory) {
        this.inventory = inventory;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            this.updateSlotDetails(new SlotConfigHolder(i));
        }
    }

    public void update(MachineBaseBlockEntity machineBase) {
        if (this.inventory == null && machineBase.getOptionalInventory().isPresent()) {
            this.inventory = machineBase.getOptionalInventory().get();
        }
        if (this.inventory != null && this.slotDetails.size() != this.inventory.method_5439()) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                SlotConfigHolder holder = this.getSlotDetails(i);
                if (holder != null) continue;
                RebornCore.LOGGER.debug("Fixed slot " + i + " in " + String.valueOf(machineBase));
                this.updateSlotDetails(new SlotConfigHolder(i));
            }
        }
        if (!machineBase.method_10997().field_9236 && machineBase.method_10997().method_8510() % (long)machineBase.slotTransferSpeed() == 0L) {
            this.getSlotDetails().forEach(slotConfigHolder -> slotConfigHolder.handleItemIO(machineBase));
        }
    }

    public SlotConfiguration(class_2487 tagCompound) {
        this.read(tagCompound);
    }

    public List<SlotConfigHolder> getSlotDetails() {
        return this.slotDetails;
    }

    public SlotConfigHolder updateSlotDetails(SlotConfigHolder slotConfigHolder) {
        SlotConfigHolder lookup = this.getSlotDetails(slotConfigHolder.slotID);
        if (lookup != null) {
            this.slotDetails.remove(lookup);
        }
        this.slotDetails.add(slotConfigHolder);
        return slotConfigHolder;
    }

    @Nullable
    public SlotConfigHolder getSlotDetails(int id) {
        for (SlotConfigHolder detail : this.slotDetails) {
            if (detail.slotID != id) continue;
            return detail;
        }
        return null;
    }

    public List<SlotConfig> getSlotsForSide(class_2350 facing) {
        return this.slotDetails.stream().map(slotConfigHolder -> slotConfigHolder.getSideDetail(facing)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public class_2487 write() {
        class_2487 tagCompound = new class_2487();
        tagCompound.method_10569("size", this.slotDetails.size());
        for (int i = 0; i < this.slotDetails.size(); ++i) {
            tagCompound.method_10566("slot_" + i, (class_2520)this.slotDetails.get(i).write());
        }
        return tagCompound;
    }

    @Override
    public void read(@NotNull class_2487 nbt) {
        int size = nbt.method_10550("size");
        for (int i = 0; i < size; ++i) {
            class_2487 tagCompound = nbt.method_10562("slot_" + i);
            SlotConfigHolder slotConfigHolder = new SlotConfigHolder(tagCompound);
            this.updateSlotDetails(slotConfigHolder);
        }
    }

    public String toJson(String machineIdent) {
        class_2487 tagCompound = new class_2487();
        tagCompound.method_10566("data", (class_2520)this.write());
        tagCompound.method_10582("machine", machineIdent);
        return tagCompound.toString();
    }

    public void readJson(String json, String machineIdent) throws UnsupportedOperationException {
        class_2487 compound;
        try {
            compound = class_2522.method_10718((String)json);
        }
        catch (CommandSyntaxException e) {
            throw new UnsupportedOperationException("Clipboard contents isn't a valid slot configuration");
        }
        if (!compound.method_10545("machine") || !compound.method_10558("machine").equals(machineIdent)) {
            throw new UnsupportedOperationException("Machine config is not for this machine.");
        }
        this.read(compound.method_10562("data"));
    }

    public static boolean canInsertItem(int index, class_1799 itemStackIn, class_2350 direction, MachineBaseBlockEntity blockEntity) {
        if (itemStackIn.method_7960()) {
            return false;
        }
        SlotConfigHolder slotConfigHolder = blockEntity.getSlotConfiguration().getSlotDetails(index);
        SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        if (slotConfig.getSlotIO().getIoConfig().isInsert()) {
            if (slotConfigHolder.filter() && blockEntity instanceof SlotFilter) {
                return ((SlotFilter)((Object)blockEntity)).isStackValid(index, itemStackIn);
            }
            return blockEntity.method_5437(index, itemStackIn);
        }
        return false;
    }

    public static boolean canExtractItem(int index, class_1799 stack, class_2350 direction, MachineBaseBlockEntity blockEntity) {
        SlotConfigHolder slotConfigHolder = blockEntity.getSlotConfiguration().getSlotDetails(index);
        SlotConfig slotConfig = slotConfigHolder.getSideDetail(direction);
        return slotConfig.getSlotIO().getIoConfig().isExtract();
    }

    public static class SlotConfigHolder
    implements NBTSerializable {
        int slotID;
        HashMap<class_2350, SlotConfig> sideMap;
        boolean input;
        boolean output;
        boolean filter;

        public SlotConfigHolder(int slotID) {
            this.slotID = slotID;
            this.sideMap = new HashMap();
            Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.put((class_2350)facing, new SlotConfig((class_2350)facing, slotID)));
        }

        public SlotConfigHolder(class_2487 tagCompound) {
            this.sideMap = new HashMap();
            this.read(tagCompound);
            Validate.isTrue((boolean)Arrays.stream(class_2350.values()).map(enumFacing -> this.sideMap.get(enumFacing)).noneMatch(Objects::isNull), (String)"sideMap failed to load from nbt", (Object[])new Object[0]);
        }

        public SlotConfig getSideDetail(class_2350 side) {
            Validate.notNull((Object)side, (String)"A none null side must be used", (Object[])new Object[0]);
            SlotConfig slotConfig = this.sideMap.get(side);
            Validate.notNull((Object)slotConfig, (String)("slotConfig was null for side " + String.valueOf(side)), (Object[])new Object[0]);
            return slotConfig;
        }

        public List<SlotConfig> getAllSides() {
            return new ArrayList<SlotConfig>(this.sideMap.values());
        }

        public void updateSlotConfig(SlotConfig config) {
            SlotConfig toEdit = this.sideMap.get(config.side);
            toEdit.slotIO = config.slotIO;
        }

        private void handleItemIO(MachineBaseBlockEntity machineBase) {
            if (!this.input && !this.output) {
                return;
            }
            this.getAllSides().stream().filter(config -> config.getSlotIO().getIoConfig() != ExtractConfig.NONE).forEach(config -> {
                if (this.input && config.getSlotIO().getIoConfig() == ExtractConfig.INPUT) {
                    config.handleItemInput(machineBase);
                }
                if (this.output && config.getSlotIO().getIoConfig() == ExtractConfig.OUTPUT) {
                    config.handleItemOutput(machineBase);
                }
            });
        }

        public boolean autoInput() {
            return this.input;
        }

        public boolean autoOutput() {
            return this.output;
        }

        public boolean filter() {
            return this.filter;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }

        @Override
        @NotNull
        public class_2487 write() {
            class_2487 compound = new class_2487();
            compound.method_10569("slotID", this.slotID);
            Arrays.stream(class_2350.values()).forEach(facing -> compound.method_10566("side_" + facing.ordinal(), (class_2520)this.sideMap.get(facing).write()));
            compound.method_10556("input", this.input);
            compound.method_10556("output", this.output);
            compound.method_10556("filter", this.filter);
            return compound;
        }

        @Override
        public void read(@NotNull class_2487 nbt) {
            this.sideMap.clear();
            this.slotID = nbt.method_10550("slotID");
            Arrays.stream(class_2350.values()).forEach(facing -> {
                class_2487 compound = nbt.method_10562("side_" + facing.ordinal());
                SlotConfig config = new SlotConfig(compound);
                this.sideMap.put((class_2350)facing, config);
            });
            this.input = nbt.method_10577("input");
            this.output = nbt.method_10577("output");
            if (nbt.method_10545("filter")) {
                this.filter = nbt.method_10577("filter");
            }
        }
    }

    public static class SlotConfig
    implements NBTSerializable {
        @NotNull
        private class_2350 side;
        @NotNull
        private SlotIO slotIO;
        private int slotID;

        public SlotConfig(@NotNull class_2350 side, int slotID) {
            this.side = side;
            this.slotID = slotID;
            this.slotIO = new SlotIO(ExtractConfig.NONE);
        }

        public SlotConfig(@NotNull class_2350 side, @NotNull SlotIO slotIO, int slotID) {
            this.side = side;
            this.slotIO = slotIO;
            this.slotID = slotID;
        }

        public SlotConfig(class_2487 tagCompound) {
            this.read(tagCompound);
            Validate.notNull((Object)this.side, (String)"error when loading slot config", (Object[])new Object[0]);
            Validate.notNull((Object)this.slotIO, (String)"error when loading slot config", (Object[])new Object[0]);
        }

        @NotNull
        public class_2350 getSide() {
            Validate.notNull((Object)this.side);
            return this.side;
        }

        @NotNull
        public SlotIO getSlotIO() {
            Validate.notNull((Object)this.slotIO);
            return this.slotIO;
        }

        public int getSlotID() {
            return this.slotID;
        }

        private void handleItemInput(MachineBaseBlockEntity machineBase) {
            RebornInventory<?> inventory = machineBase.getOptionalInventory().get();
            class_1799 targetStack = inventory.method_5438(this.slotID);
            if (targetStack.method_7914() == targetStack.method_7947()) {
                return;
            }
            StorageUtil.move((Storage)((Storage)ItemStorage.SIDED.find(machineBase.method_10997(), machineBase.method_11016().method_10093(this.side), (Object)this.side.method_10153())), (Storage)InventoryStorage.of((class_1263)machineBase, null).getSlot(this.slotID), iv -> true, (long)4L, null);
        }

        private void handleItemOutput(MachineBaseBlockEntity machineBase) {
            RebornInventory<?> inventory = machineBase.getOptionalInventory().get();
            class_1799 sourceStack = inventory.method_5438(this.slotID);
            if (sourceStack.method_7960()) {
                return;
            }
            StorageUtil.move((Storage)InventoryStorage.of((class_1263)machineBase, null).getSlot(this.slotID), (Storage)((Storage)ItemStorage.SIDED.find(machineBase.method_10997(), machineBase.method_11016().method_10093(this.side), (Object)this.side.method_10153())), iv -> true, (long)Long.MAX_VALUE, null);
        }

        @Override
        @NotNull
        public class_2487 write() {
            class_2487 tagCompound = new class_2487();
            tagCompound.method_10569("side", this.side.ordinal());
            tagCompound.method_10566("config", (class_2520)this.slotIO.write());
            tagCompound.method_10569("slot", this.slotID);
            return tagCompound;
        }

        @Override
        public void read(@NotNull class_2487 nbt) {
            this.side = class_2350.values()[nbt.method_10550("side")];
            this.slotIO = new SlotIO(nbt.method_10562("config"));
            this.slotID = nbt.method_10550("slot");
        }
    }

    public static class SlotIO
    implements NBTSerializable {
        ExtractConfig ioConfig;

        public SlotIO(class_2487 tagCompound) {
            this.read(tagCompound);
        }

        public SlotIO(ExtractConfig ioConfig) {
            this.ioConfig = ioConfig;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        @Override
        @NotNull
        public class_2487 write() {
            class_2487 compound = new class_2487();
            compound.method_10569("config", this.ioConfig.ordinal());
            return compound;
        }

        @Override
        public void read(@NotNull class_2487 nbt) {
            this.ioConfig = ExtractConfig.values()[nbt.method_10550("config")];
        }
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false);

        boolean extract;
        boolean insert;

        private ExtractConfig(boolean extract, boolean insert) {
            this.extract = extract;
            this.insert = insert;
        }

        public boolean isExtract() {
            return this.extract;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }
    }

    public static interface SlotFilter {
        public boolean isStackValid(int var1, class_1799 var2);

        public int[] getInputSlots();
    }
}

