/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.crafting.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import reborncore.common.crafting.ingredient.RebornIngredient;

public class TagIngredient
extends RebornIngredient {
    private final class_6862<class_1792> tag;
    private final Optional<Integer> count;

    public TagIngredient(class_6862<class_1792> tag, Optional<Integer> count) {
        this.tag = tag;
        this.count = count;
    }

    @Override
    public boolean test(class_1799 itemStack) {
        if (this.count.isPresent() && this.count.get() > itemStack.method_7947()) {
            return false;
        }
        return itemStack.method_31573(this.tag);
    }

    @Override
    public class_1856 getPreview() {
        return class_1856.method_26964(this.getPreviewStacks().stream());
    }

    @Override
    public List<class_1799> getPreviewStacks() {
        return this.streamItems().map(class_1799::new).peek(itemStack -> itemStack.method_7939(this.count.orElse(1).intValue())).collect(Collectors.toList());
    }

    public static RebornIngredient deserialize(JsonObject json) {
        Optional<Integer> count = Optional.empty();
        if (json.has("count")) {
            count = Optional.of(class_3518.method_15260((JsonObject)json, (String)"count"));
        }
        if (json.has("tag_server_sync")) {
            class_2960 tagIdent = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag_identifier"));
            ArrayList<class_1792> items = new ArrayList<class_1792>();
            JsonArray itemsArray = class_3518.method_15261((JsonObject)json, (String)"items");
            for (JsonElement jsonElement : itemsArray) {
                Validate.isTrue((boolean)jsonElement.isJsonPrimitive());
                class_1792 item = (class_1792)class_7923.field_41178.method_10200(jsonElement.getAsInt());
                items.add(item);
            }
            return new Synced((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagIdent), count, items);
        }
        class_2960 identifier = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)identifier);
        return new TagIngredient((class_6862<class_1792>)tagKey, count);
    }

    @Override
    public JsonObject toJson(boolean networkSync) {
        if (networkSync) {
            return this.toItemJsonObject();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tag", this.tag.comp_327().toString());
        return jsonObject;
    }

    private JsonObject toItemJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tag_server_sync", Boolean.valueOf(true));
        class_1792[] items = (class_1792[])this.streamItems().toArray(class_1792[]::new);
        JsonArray itemArray = new JsonArray();
        for (class_1792 item : items) {
            int rawId = class_7923.field_41178.method_10206((Object)item);
            itemArray.add((Number)rawId);
        }
        jsonObject.add("items", (JsonElement)itemArray);
        this.count.ifPresent(integer -> jsonObject.addProperty("count", (Number)integer));
        jsonObject.addProperty("tag_identifier", this.tag.comp_327().toString());
        return jsonObject;
    }

    protected Stream<class_1792> streamItems() {
        return StreamSupport.stream(class_7923.field_41178.method_40286(this.tag).spliterator(), false).map(class_6880::comp_349);
    }

    @Override
    public int getCount() {
        return this.count.orElse(1);
    }

    public class_6862<class_1792> getTag() {
        return this.tag;
    }

    private static class Synced
    extends TagIngredient {
        private final List<class_1792> items;

        public Synced(class_6862<class_1792> tag, Optional<Integer> count, List<class_1792> items) {
            super(tag, count);
            this.items = items;
        }

        @Override
        public boolean test(class_1799 itemStack) {
            return this.items.contains(itemStack.method_7909());
        }

        @Override
        protected Stream<class_1792> streamItems() {
            return this.items.stream();
        }
    }
}

