/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.model;

import io.github.foundationgames.automobility.block.model.GeometryBuilder;
import io.github.foundationgames.automobility.block.model.SlopeUnbakedModel;
import io.github.foundationgames.automobility.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3665;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SlopeBakedModel
implements class_1087 {
    public static Factory impl = SlopeBakedModel::new;
    private final Map<class_2680, class_1058> frameTexOverrides;
    @Nullable
    protected final class_1058 plateInner;
    @Nullable
    protected final class_1058 plateOuter;
    protected final class_3665 settings;
    protected final SlopeUnbakedModel.Type type;
    private final class_1058 frame;

    public SlopeBakedModel(class_1058 frame, Map<class_2680, class_1058> frameTexOverrides, @Nullable class_1058 plateInner, @Nullable class_1058 plateOuter, class_3665 settings, SlopeUnbakedModel.Type type) {
        this.frame = frame;
        this.frameTexOverrides = frameTexOverrides;
        this.plateInner = plateInner;
        this.plateOuter = plateOuter;
        this.settings = settings;
        this.type = type;
    }

    public class_1058 getFrameSprite(@Nullable class_1920 level, @Nullable class_2338 pos) {
        if (level != null && pos != null) {
            class_2680 blockBelow = level.method_8320(pos.method_10074());
            if (this.frameTexOverrides.containsKey(blockBelow)) {
                return this.frameTexOverrides.get(blockBelow);
            }
            if (!blockBelow.method_26215() && blockBelow.method_26234((class_1922)level, pos)) {
                return class_310.method_1551().method_1541().method_3349(blockBelow).method_4711();
            }
        }
        return this.frame;
    }

    public int getFrameColor(@Nullable class_1920 level, @Nullable class_2338 pos) {
        if (level != null && pos != null) {
            class_2680 blockBelow = level.method_8320(pos.method_10074());
            class_322 belowColor = Platform.get().blockColor(blockBelow);
            if (belowColor != null) {
                return belowColor.getColor(blockBelow, level, pos.method_10074(), 0) | 0xFF000000;
            }
        }
        return -1;
    }

    public void buildSlopeGeometry(class_1058 sprite, GeometryBuilder geo, int frameColor, boolean borderedLeft, boolean borderedRight) {
        float height;
        boolean steep = this.type == SlopeUnbakedModel.Type.STEEP;
        float f = height = steep ? 1.0f : 0.5f;
        float rise = steep ? 0.0f : (this.type == SlopeUnbakedModel.Type.TOP ? 0.5f : 0.0f);
        boolean top = true;
        if (this.plateOuter != null && this.plateInner != null) {
            top = false;
            this.plate(height, rise, !borderedLeft, !borderedRight, this.plateInner, this.plateOuter, geo);
        }
        this.rightTriPrism(height, rise, frameColor, top, sprite, geo);
        float invRH = 1.0f - (rise + height);
        geo.vertex(0.0f, rise + height, 1.0f, class_2350.field_11035, 0.0f, 0.0f, 1.0f, sprite, 0.0f, invRH, frameColor).vertex(0.0f, 0.0f, 1.0f, class_2350.field_11035, 0.0f, 0.0f, 1.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 1.0f, class_2350.field_11035, 0.0f, 0.0f, 1.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, rise + height, 1.0f, class_2350.field_11035, 0.0f, 0.0f, 1.0f, sprite, 1.0f, invRH, frameColor).vertex(0.0f, 0.0f, 1.0f, class_2350.field_11033, 0.0f, -1.0f, 0.0f, sprite, 0.0f, 0.0f, frameColor).vertex(0.0f, 0.0f, 0.0f, class_2350.field_11033, 0.0f, -1.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 0.0f, class_2350.field_11033, 0.0f, -1.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 1.0f, class_2350.field_11033, 0.0f, -1.0f, 0.0f, sprite, 1.0f, 0.0f, frameColor);
        if (rise > 0.0f) {
            float invR = 1.0f - rise;
            geo.vertex(0.0f, rise, 0.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, frameColor).vertex(0.0f, 0.0f, 0.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(0.0f, 0.0f, 1.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(0.0f, rise, 1.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, rise, 1.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, 0.0f, 1.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 1.0f, 1.0f, frameColor).vertex(1.0f, 0.0f, 0.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 0.0f, 1.0f, frameColor).vertex(1.0f, rise, 0.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, frameColor).vertex(1.0f, rise, 0.0f, class_2350.field_11043, 0.0f, 0.0f, 1.0f, sprite, 1.0f, invR, frameColor).vertex(1.0f, 0.0f, 0.0f, class_2350.field_11043, 0.0f, 0.0f, 1.0f, sprite, 1.0f, 1.0f, frameColor).vertex(0.0f, 0.0f, 0.0f, class_2350.field_11043, 0.0f, 0.0f, 1.0f, sprite, 0.0f, 1.0f, frameColor).vertex(0.0f, rise, 0.0f, class_2350.field_11043, 0.0f, 0.0f, 1.0f, sprite, 0.0f, invR, frameColor);
        }
    }

    private void rightTriPrism(float height, float rise, int color, boolean top, class_1058 sprite, GeometryBuilder geo) {
        float invR = 1.0f - rise;
        float invRH = 1.0f - (rise + height);
        Vector3f topNormal = new Vector3f(0.0f, 1.0f, -height);
        topNormal.normalize();
        geo.vertex(0.0f, rise + height, 1.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invRH, color).vertex(0.0f, rise, 0.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, color).vertex(0.0f, rise, 1.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, color).vertex(0.0f, rise + height, 1.0f, class_2350.field_11039, -1.0f, 0.0f, 0.0f, sprite, 1.0f, invRH, color).vertex(1.0f, rise + height, 1.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invRH, color).vertex(1.0f, rise + height, 1.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invRH, color).vertex(1.0f, rise, 1.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 0.0f, invR, color).vertex(1.0f, rise, 0.0f, class_2350.field_11034, 1.0f, 0.0f, 0.0f, sprite, 1.0f, invR, color);
        if (top) {
            geo.vertex(0.0f, rise, 0.0f, null, topNormal.x(), topNormal.y(), topNormal.z(), sprite, 1.0f, 1.0f, color).vertex(0.0f, rise + height, 1.0f, null, topNormal.x(), topNormal.y(), topNormal.z(), sprite, 1.0f, 0.0f, color).vertex(1.0f, rise + height, 1.0f, null, topNormal.x(), topNormal.y(), topNormal.z(), sprite, 0.0f, 0.0f, color).vertex(1.0f, rise, 0.0f, null, topNormal.x(), topNormal.y(), topNormal.z(), sprite, 0.0f, 1.0f, color);
        }
    }

    private void plate(float height, float rise, boolean left, boolean right, class_1058 plateInner, class_1058 plateOuter, GeometryBuilder geo) {
        Vector3f topNormal = new Vector3f(0.0f, 1.0f, -height);
        topNormal.normalize();
        Vector3f northNormal = new Vector3f(0.0f, -height, 1.0f);
        northNormal.normalize();
        Vector3f southNormal = new Vector3f(0.0f, height, 1.0f);
        southNormal.normalize();
        Vector3f topFaceOffset = new Vector3f((Vector3fc)topNormal);
        topFaceOffset.mul(0.0625f);
        Vector3f onePxUp = new Vector3f((Vector3fc)southNormal);
        onePxUp.normalize();
        onePxUp.mul(0.0625f);
        geo.vertex(right ? 0.9375f : 1.0f, 0.001f + rise + topFaceOffset.y() + onePxUp.y(), topFaceOffset.z() + onePxUp.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateInner, right ? 0.0625f : 0.0f, 0.9375f).vertex(left ? 0.0625f : 0.0f, 0.001f + rise + topFaceOffset.y() + onePxUp.y(), topFaceOffset.z() + onePxUp.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateInner, left ? 0.9375f : 1.0f, 0.9375f).vertex(left ? 0.0625f : 0.0f, 0.001f + rise + height + topFaceOffset.y() - onePxUp.y(), 1.0f + topFaceOffset.z() - onePxUp.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateInner, left ? 0.9375f : 1.0f, 0.0625f).vertex(right ? 0.9375f : 1.0f, 0.001f + rise + height + topFaceOffset.y() - onePxUp.y(), 1.0f + topFaceOffset.z() - onePxUp.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateInner, right ? 0.0625f : 0.0f, 0.0625f).vertex(1.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateOuter, 0.0f, 1.0f).vertex(0.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateOuter, 1.0f, 1.0f).vertex(0.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateOuter, 1.0f, 0.0f).vertex(1.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, topNormal.x(), topNormal.y(), topNormal.z(), plateOuter, 0.0f, 0.0f).vertex(1.0f, rise, 0.0f, null, northNormal.x(), northNormal.y(), northNormal.z(), plateOuter, 0.0f, 1.0f).vertex(0.0f, rise, 0.0f, null, northNormal.x(), northNormal.y(), northNormal.z(), plateOuter, 1.0f, 1.0f).vertex(0.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, northNormal.x(), northNormal.y(), northNormal.z(), plateOuter, 1.0f, 0.9375f).vertex(1.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, northNormal.x(), northNormal.y(), northNormal.z(), plateOuter, 0.0f, 0.9375f).vertex(1.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, southNormal.x(), southNormal.y(), southNormal.z(), plateOuter, 0.0f, 0.0f).vertex(0.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, southNormal.x(), southNormal.y(), southNormal.z(), plateOuter, 1.0f, 0.0f).vertex(0.0f, rise + height, 1.0f, null, southNormal.x(), southNormal.y(), southNormal.z(), plateOuter, 1.0f, 0.0625f).vertex(1.0f, rise + height, 1.0f, null, southNormal.x(), southNormal.y(), southNormal.z(), plateOuter, 0.0f, 0.0625f).vertex(1.0f, rise + height, 1.0f, null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0f, 0.0f).vertex(1.0f, rise, 0.0f, null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0f, 1.0f).vertex(1.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0625f, 1.0f).vertex(1.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, 1.0f, 0.0f, 0.0f, plateOuter, 0.0625f, 0.0f).vertex(0.0f, rise + height + topFaceOffset.y(), 1.0f + topFaceOffset.z(), null, -1.0f, 0.0f, 0.0f, plateOuter, 1.0f, 0.0f).vertex(0.0f, rise + topFaceOffset.y(), topFaceOffset.z(), null, -1.0f, 0.0f, 0.0f, plateOuter, 1.0f, 1.0f).vertex(0.0f, rise, 0.0f, null, -1.0f, 0.0f, 0.0f, plateOuter, 0.9375f, 1.0f).vertex(0.0f, rise + height, 1.0f, null, -1.0f, 0.0f, 0.0f, plateOuter, 0.9375f, 0.0f);
    }

    public List<class_777> method_4707(@Nullable class_2680 blockState, @Nullable class_2350 direction, class_5819 randomSource) {
        return Collections.emptyList();
    }

    public boolean method_4708() {
        return true;
    }

    public boolean method_4712() {
        return true;
    }

    public boolean method_24304() {
        return true;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.getFrameSprite(null, null);
    }

    public class_809 method_4709() {
        return class_809.field_4301;
    }

    public class_806 method_4710() {
        return class_806.field_4292;
    }

    public static interface Factory {
        public SlopeBakedModel create(class_1058 var1, Map<class_2680, class_1058> var2, @Nullable class_1058 var3, @Nullable class_1058 var4, class_3665 var5, SlopeUnbakedModel.Type var6);
    }
}

