/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.fabric.block.render;

import io.github.foundationgames.automobility.block.model.GeometryBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class FabricGeometryBuilder
implements GeometryBuilder {
    private final QuadEmitter quads;
    private final Matrix4f transform;
    private int index = 0;

    public FabricGeometryBuilder(QuadEmitter quads, Matrix4f transform) {
        this.quads = quads;
        this.transform = transform;
    }

    @Override
    public GeometryBuilder vertex(float x, float y, float z, @Nullable class_2350 face, float nx, float ny, float nz, class_1058 sprite, float u, float v) {
        return this.vertex(x, y, z, face, nx, ny, nz, sprite, u, v, -1);
    }

    @Override
    public GeometryBuilder vertex(float x, float y, float z, @Nullable class_2350 face, float nx, float ny, float nz, class_1058 sprite, float u, float v, int color) {
        Vector4f pos = new Vector4f(x - 0.5f, y, z - 0.5f, 1.0f);
        Vector4f tNormal = new Vector4f(nx, ny, nz, 1.0f);
        pos.mul((Matrix4fc)this.transform);
        tNormal.mul((Matrix4fc)this.transform);
        Vector3f normal = new Vector3f(tNormal.x(), tNormal.y(), tNormal.z());
        normal.normalize();
        this.quads.pos(this.index, pos.x() + 0.5f, pos.y(), pos.z() + 0.5f);
        if (face != null) {
            face = class_2350.method_23225((Matrix4f)this.transform, (class_2350)face);
            this.quads.cullFace(face);
        }
        this.quads.normal(this.index, normal.x(), normal.y(), normal.z());
        float u0 = sprite.method_4594();
        float u1 = sprite.method_4577();
        float v0 = sprite.method_4593();
        float v1 = sprite.method_4575();
        this.quads.spriteColor(this.index, 0, color);
        this.quads.sprite(this.index, 0, u0 + (u1 - u0) * u, v0 + (v1 - v0) * v);
        if (++this.index >= 4) {
            this.quads.emit();
            this.index = 0;
        }
        return this;
    }
}

