/*
 * Decompiled with CFR 0.152.
 */
package net.combatroll.mixin;

import net.combatroll.CombatRoll;
import net.combatroll.api.EntityAttributes_CombatRoll;
import net.combatroll.client.Keybindings;
import net.combatroll.client.MinecraftClientExtension;
import net.combatroll.client.RollEffect;
import net.combatroll.client.RollManager;
import net.combatroll.compatibility.BetterCombatHelper;
import net.combatroll.network.Packets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class}, priority=449)
public abstract class MinecraftClientMixin
implements MinecraftClientExtension {
    @Shadow
    private int field_1752;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Nullable
    public class_437 field_1755;
    private RollManager rollManager = new RollManager();

    @Override
    public RollManager getRollManager() {
        return this.rollManager;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(class_437 screen, CallbackInfo ci) {
        this.rollManager.isEnabled = false;
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void doAttack_HEAD(CallbackInfoReturnable<Boolean> info) {
        if (this.rollManager.isRolling()) {
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleBlockBreaking_HEAD(boolean bl, CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void doItemUse_HEAD(CallbackInfo ci) {
        if (this.rollManager.isRolling()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleInputEvents"}, at={@At(value="TAIL")})
    private void handleInputEvents_TAIL(CallbackInfo ci) {
        this.tryRolling();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick_TAIL(CallbackInfo ci) {
        if (this.field_1724 != null) {
            this.rollManager.tick(this.field_1724);
        }
    }

    private void tryRolling() {
        class_310 client = (class_310)this;
        if (this.field_1724 == null || client.method_1493() || client.field_1755 != null) {
            return;
        }
        if (Keybindings.roll.method_1434()) {
            float defaultSlipperiness;
            class_2248 block;
            float slipperiness;
            double liquidHeight;
            if (!this.rollManager.isRollAvailable((class_1657)this.field_1724)) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_airborn && !this.field_1724.method_24828()) {
                return;
            }
            if ((float)this.field_1724.method_7344().method_7586() <= CombatRoll.config.food_level_required) {
                return;
            }
            if (this.field_1724.method_5681() || this.field_1724.method_20448()) {
                return;
            }
            if (this.field_1724.method_5854() != null) {
                return;
            }
            if (this.field_1724.method_6115() || this.field_1724.method_6039()) {
                return;
            }
            if (!CombatRoll.config.allow_rolling_while_weapon_cooldown && (double)this.field_1724.method_7261(0.0f) < 0.95) {
                return;
            }
            if (BetterCombatHelper.isDoingUpswing()) {
                BetterCombatHelper.cancelUpswing();
            } else if (client.field_1690.field_1886.method_1434()) {
                return;
            }
            if (this.field_1752 > 0) {
                return;
            }
            float forward = this.field_1724.field_3913.field_3905;
            float sideways = this.field_1724.field_3913.field_3907;
            class_243 direction = forward == 0.0f && sideways == 0.0f ? new class_243(0.0, 0.0, 1.0) : new class_243((double)sideways, 0.0, (double)forward).method_1029();
            direction = direction.method_1024((float)Math.toRadians(-1.0 * (double)this.field_1724.method_36454()));
            double distance = 0.475 * (EntityAttributes_CombatRoll.getAttributeValue((class_1657)this.field_1724, EntityAttributes_CombatRoll.Type.DISTANCE) + (double)CombatRoll.config.additional_roll_distance);
            direction = direction.method_1021(distance);
            if (this.field_1724.method_5799()) {
                liquidHeight = this.field_1724.method_5861(class_3486.field_15517);
                liquidHeight = Math.min(liquidHeight, 1.0);
                direction = direction.method_1021(liquidHeight * 0.5);
            }
            if (this.field_1724.method_5771()) {
                liquidHeight = this.field_1724.method_5861(class_3486.field_15518);
                liquidHeight = Math.min(liquidHeight, 1.0);
                direction = direction.method_1021(0.3);
            }
            if ((slipperiness = (block = this.field_1724.method_37908().method_8320(this.field_1724.method_24515().method_10074()).method_26204()).method_9499()) > (defaultSlipperiness = class_2246.field_10479.method_9499())) {
                float multiplier = defaultSlipperiness / slipperiness;
                direction = direction.method_1021((double)(multiplier * multiplier));
            }
            this.field_1724.method_5762(direction.field_1352, direction.field_1351, direction.field_1350);
            this.rollManager.onRoll(this.field_1724);
            RollEffect.Visuals rollVisuals = new RollEffect.Visuals("combatroll:roll", RollEffect.Particles.PUFF);
            ClientPlayNetworking.send((class_2960)Packets.RollPublish.ID, (class_2540)new Packets.RollPublish(this.field_1724.method_5628(), rollVisuals, direction).write());
            RollEffect.playVisuals(rollVisuals, (class_1657)this.field_1724, direction);
        }
    }
}

