/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.client.sound.SpeakerInstance;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1140;
import net.minecraft.class_4224;
import net.minecraft.class_4234;

@Environment(value=EnvType.CLIENT)
public class SpeakerManager {
    private static final Map<UUID, SpeakerInstance> sounds = new ConcurrentHashMap<UUID, SpeakerInstance>();

    public static void onPlayStreaming(class_1140 engine, class_4224 channel, class_4234 stream) {
        if (!(stream instanceof DfpwmStream)) {
            return;
        }
        DfpwmStream dfpwmStream = (DfpwmStream)stream;
        dfpwmStream.channel = channel;
        dfpwmStream.executor = engine.field_18948;
    }

    public static SpeakerInstance getSound(UUID source) {
        return sounds.computeIfAbsent(source, x -> new SpeakerInstance());
    }

    public static void stopSound(UUID source) {
        SpeakerInstance sound = sounds.remove(source);
        if (sound != null) {
            sound.stop();
        }
    }

    public static void moveSound(UUID source, SpeakerPosition position) {
        SpeakerInstance sound = sounds.get(source);
        if (sound != null) {
            sound.setPosition(position);
        }
    }

    public static void reset() {
        sounds.clear();
    }
}

