/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.FileAttributes;
import dan200.computercraft.api.filesystem.FileOperationException;
import dan200.computercraft.api.filesystem.MountConstants;
import dan200.computercraft.core.filesystem.ArchiveMount;
import dan200.computercraft.core.filesystem.FileSystem;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;

public final class JarMount
extends ArchiveMount<FileEntry>
implements Closeable {
    private final ZipFile zip;

    public JarMount(File jarFile, String subPath) throws IOException {
        if (!jarFile.exists() || jarFile.isDirectory()) {
            throw new FileNotFoundException("Cannot find " + jarFile);
        }
        try {
            this.zip = new ZipFile(jarFile);
        }
        catch (IOException e) {
            throw new IOException("Error loading zip file", e);
        }
        if (this.zip.getEntry(subPath) == null) {
            this.zip.close();
            throw new FileNotFoundException("Zip does not contain path");
        }
        this.root = new FileEntry();
        FileEntry root = this.root;
        Enumeration<? extends ZipEntry> zipEntries = this.zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(subPath)) continue;
            String localPath = FileSystem.toLocal(entryPath, subPath);
            this.getOrCreateChild(root, localPath, x -> new FileEntry()).setup(entry);
        }
    }

    @Override
    protected long getFileSize(String path, FileEntry file) throws FileOperationException {
        if (file.zipEntry == null) {
            throw new FileOperationException(path, "No such file");
        }
        return file.zipEntry.getSize();
    }

    @Override
    protected byte[] getFileContents(String path, FileEntry file) throws FileOperationException {
        byte[] byArray;
        block9: {
            if (file.zipEntry == null) {
                throw new FileOperationException(path, "No such file");
            }
            InputStream stream = this.zip.getInputStream(file.zipEntry);
            try {
                byArray = stream.readAllBytes();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileOperationException(path, "No such file");
                }
            }
            stream.close();
        }
        return byArray;
    }

    @Override
    protected BasicFileAttributes getAttributes(String path, FileEntry file) throws IOException {
        return file.zipEntry == null ? super.getAttributes(path, file) : new FileAttributes(file.isDirectory(), this.getSize(path, file), JarMount.orEpoch(file.zipEntry.getCreationTime()), JarMount.orEpoch(file.zipEntry.getLastModifiedTime()));
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    private static FileTime orEpoch(@Nullable FileTime time) {
        return time == null ? MountConstants.EPOCH : time;
    }

    protected static final class FileEntry
    extends ArchiveMount.FileEntry<FileEntry> {
        @Nullable
        ZipEntry zipEntry;

        protected FileEntry() {
        }

        void setup(ZipEntry entry) {
            this.zipEntry = entry;
            if (this.children == null && entry.isDirectory()) {
                this.children = new HashMap(0);
            }
        }
    }
}

