/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.filesystem.WritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.MediaProvider;
import dan200.computercraft.api.network.PacketNetwork;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.network.wired.WiredNode;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.redstone.BundledRedstoneProvider;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.core.filesystem.WritableFileMount;
import dan200.computercraft.impl.ApiFactories;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.impl.ComputerCraftAPIService;
import dan200.computercraft.impl.GenericSources;
import dan200.computercraft.impl.MediaProviders;
import dan200.computercraft.impl.TurtleRefuelHandlers;
import dan200.computercraft.impl.detail.DetailRegistryImpl;
import dan200.computercraft.impl.network.wired.WiredNodeImpl;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.details.BlockDetails;
import dan200.computercraft.shared.details.ItemDetails;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractComputerCraftAPI
implements ComputerCraftAPIService {
    private final DetailRegistry<class_1799> itemStackDetails = new DetailRegistryImpl<class_1799>(ItemDetails::fillBasic);
    private final DetailRegistry<BlockReference> blockDetails = new DetailRegistryImpl<BlockReference>(BlockDetails::fillBasic);
    protected static final class_5321<class_2378<TurtleUpgradeSerialiser<?>>> turtleUpgradeRegistryId = class_5321.method_29180((class_2960)new class_2960("computercraft", "turtle_upgrade_serialiser"));
    protected static final class_5321<class_2378<PocketUpgradeSerialiser<?>>> pocketUpgradeRegistryId = class_5321.method_29180((class_2960)new class_2960("computercraft", "pocket_upgrade_serialiser"));

    @Nullable
    public static InputStream getResourceFile(MinecraftServer server, String domain, String subPath) {
        class_3300 manager = server.method_34864();
        class_3298 resource = manager.method_14486(new class_2960(domain, subPath)).orElse(null);
        if (resource == null) {
            return null;
        }
        try {
            return resource.method_14482();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Override
    public final int createUniqueNumberedSaveDir(MinecraftServer server, String parentSubPath) {
        return ServerContext.get(server).getNextId(parentSubPath);
    }

    @Override
    public final WritableMount createSaveDirMount(MinecraftServer server, String subPath, long capacity) {
        File root = ServerContext.get(server).storageDir().toFile();
        return new WritableFileMount(new File(root, subPath), capacity);
    }

    @Override
    @Nullable
    public final Mount createResourceMount(MinecraftServer server, String domain, String subPath) {
        ResourceMount mount = ResourceMount.get(domain, subPath, server.method_34864());
        return mount.exists("") ? mount : null;
    }

    @Override
    public final void registerGenericSource(GenericSource source) {
        GenericSources.register(source);
    }

    @Override
    public final void registerBundledRedstoneProvider(BundledRedstoneProvider provider) {
        BundledRedstone.register(provider);
    }

    @Override
    public final int getBundledRedstoneOutput(class_1937 world, class_2338 pos, class_2350 side) {
        return BundledRedstone.getDefaultOutput(world, pos, side);
    }

    @Override
    public final void registerMediaProvider(MediaProvider provider) {
        MediaProviders.register(provider);
    }

    @Override
    public final PacketNetwork getWirelessNetwork(MinecraftServer server) {
        return ServerContext.get(server).wirelessNetwork();
    }

    @Override
    public final void registerAPIFactory(ILuaAPIFactory factory) {
        ApiFactories.register(factory);
    }

    @Override
    public final WiredNode createWiredNodeForElement(WiredElement element) {
        return new WiredNodeImpl(element);
    }

    @Override
    public final void registerRefuelHandler(TurtleRefuelHandler handler) {
        TurtleRefuelHandlers.register(handler);
    }

    @Override
    public final class_5321<class_2378<TurtleUpgradeSerialiser<?>>> turtleUpgradeRegistryId() {
        return turtleUpgradeRegistryId;
    }

    @Override
    public final class_5321<class_2378<PocketUpgradeSerialiser<?>>> pocketUpgradeRegistryId() {
        return pocketUpgradeRegistryId;
    }

    @Override
    public final DetailRegistry<class_1799> getItemStackDetailRegistry() {
        return this.itemStackDetails;
    }

    @Override
    public final DetailRegistry<BlockReference> getBlockInWorldDetailRegistry() {
        return this.blockDetails;
    }
}

