/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.command.CommandUtils;
import dan200.computercraft.shared.command.Exceptions;
import dan200.computercraft.shared.command.UserLevel;
import dan200.computercraft.shared.command.arguments.ComputerArgumentType;
import dan200.computercraft.shared.command.arguments.ComputersArgumentType;
import dan200.computercraft.shared.command.arguments.TrackingFieldArgumentType;
import dan200.computercraft.shared.command.builder.CommandBuilder;
import dan200.computercraft.shared.command.builder.HelpingArgumentBuilder;
import dan200.computercraft.shared.command.text.ChatHelpers;
import dan200.computercraft.shared.command.text.TableBuilder;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.inventory.ViewComputerMenu;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.computer.metrics.basic.AggregatedMetric;
import dan200.computercraft.shared.computer.metrics.basic.BasicComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.ComputerMetrics;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_5250;

public final class CommandComputerCraft {
    public static final UUID SYSTEM_UUID = new UUID(0L, 0L);
    public static final String CLIENT_OPEN_FOLDER = "computercraft-computer-folder";
    private static final List<AggregatedMetric> DEFAULT_FIELDS = List.of(new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.COUNT), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.NONE), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG));

    private CommandComputerCraft() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("computercraft").then((ArgumentBuilder<class_2168, ?>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"dump").requires(ModRegistry.Permissions.PERMISSION_DUMP)).executes(c -> CommandComputerCraft.dump((class_2168)c.getSource()))).then(CommandBuilder.args().arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)c -> CommandComputerCraft.dumpComputer((class_2168)c.getSource(), ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)c, "computer")))))).then(CommandBuilder.command("shutdown").requires(ModRegistry.Permissions.PERMISSION_SHUTDOWN).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ServerContext.get(s.method_9211()).registry().getComputers()).executes((c, a) -> CommandComputerCraft.shutdown((class_2168)c.getSource(), ComputersArgumentType.unwrap((class_2168)c.getSource(), a))))).then(CommandBuilder.command("turn-on").requires(ModRegistry.Permissions.PERMISSION_TURN_ON).argManyValue("computers", ComputersArgumentType.manyComputers(), s -> ServerContext.get(s.method_9211()).registry().getComputers()).executes((c, a) -> CommandComputerCraft.turnOn((class_2168)c.getSource(), ComputersArgumentType.unwrap((class_2168)c.getSource(), a))))).then(CommandBuilder.command("tp").requires(ModRegistry.Permissions.PERMISSION_TP).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)c -> CommandComputerCraft.teleport((class_2168)c.getSource(), ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)c, "computer")))))).then(CommandBuilder.command("queue").requires(ModRegistry.Permissions.PERMISSION_QUEUE).arg((ArgumentBuilder<class_2168, ?>)RequiredArgumentBuilder.argument((String)"computer", (ArgumentType)ComputersArgumentType.manyComputers()).suggests((context, builder) -> Suggestions.empty())).argManyValue("args", StringArgumentType.string(), List.of()).executes((c, a) -> CommandComputerCraft.queue(ComputersArgumentType.getComputersArgument((CommandContext<class_2168>)c, "computer"), a)))).then(CommandBuilder.command("view").requires(ModRegistry.Permissions.PERMISSION_VIEW).arg("computer", ComputerArgumentType.oneComputer()).executes((Command<class_2168>)((Command)c -> CommandComputerCraft.view((class_2168)c.getSource(), ComputerArgumentType.getComputerArgument((CommandContext<class_2168>)c, "computer")))))).then(((LiteralArgumentBuilder)HelpingArgumentBuilder.choice("track").requires(ModRegistry.Permissions.PERMISSION_TRACK).then(CommandBuilder.command("start").executes((Command<class_2168>)((Command)c -> CommandComputerCraft.trackStart((class_2168)c.getSource())))).then(CommandBuilder.command("stop").executes((Command<class_2168>)((Command)c -> CommandComputerCraft.trackStop((class_2168)c.getSource()))))).then(CommandBuilder.command("dump").argManyValue("fields", TrackingFieldArgumentType.metric(), DEFAULT_FIELDS).executes((c, f) -> CommandComputerCraft.trackDump((class_2168)c.getSource(), f)))));
    }

    private static int dump(class_2168 source) {
        TableBuilder table = new TableBuilder("DumpAll", "Computer", "On", "Position");
        ArrayList<ServerComputer> computers = new ArrayList<ServerComputer>(ServerContext.get(source.method_9211()).registry().getComputers());
        class_3218 world = source.method_9225();
        class_2338 pos = class_2338.method_49638((class_2374)source.method_9222());
        computers.sort((arg_0, arg_1) -> CommandComputerCraft.lambda$dump$13((class_1937)world, pos, arg_0, arg_1));
        for (ServerComputer computer : computers) {
            table.row(new class_2561[]{CommandComputerCraft.linkComputer(source, computer, computer.getID()), ChatHelpers.bool(computer.isOn()), CommandComputerCraft.linkPosition(source, computer)});
        }
        table.display(source);
        return computers.size();
    }

    private static int dumpComputer(class_2168 source, ServerComputer computer) {
        TableBuilder table = new TableBuilder("Dump");
        table.row(new class_2561[]{ChatHelpers.header("Instance"), ChatHelpers.text(Integer.toString(computer.getInstanceID()))});
        table.row(new class_2561[]{ChatHelpers.header("Id"), ChatHelpers.text(Integer.toString(computer.getID()))});
        table.row(new class_2561[]{ChatHelpers.header("Label"), ChatHelpers.text(computer.getLabel())});
        table.row(new class_2561[]{ChatHelpers.header("On"), ChatHelpers.bool(computer.isOn())});
        table.row(new class_2561[]{ChatHelpers.header("Position"), CommandComputerCraft.linkPosition(source, computer)});
        table.row(new class_2561[]{ChatHelpers.header("Family"), ChatHelpers.text(computer.getFamily().toString())});
        for (ComputerSide side : ComputerSide.values()) {
            IPeripheral peripheral = computer.getPeripheral(side);
            if (peripheral == null) continue;
            table.row(new class_2561[]{ChatHelpers.header("Peripheral " + side.getName()), ChatHelpers.text(peripheral.getType())});
        }
        table.display(source);
        return 1;
    }

    private static int shutdown(class_2168 source, Collection<ServerComputer> computers) {
        int shutdown = 0;
        for (ServerComputer computer : computers) {
            if (computer.isOn()) {
                ++shutdown;
            }
            computer.shutdown();
        }
        int didShutdown = shutdown;
        source.method_9226(() -> class_2561.method_43469((String)"commands.computercraft.shutdown.done", (Object[])new Object[]{didShutdown, computers.size()}), false);
        return shutdown;
    }

    private static int turnOn(class_2168 source, Collection<ServerComputer> computers) {
        int on = 0;
        for (ServerComputer computer : computers) {
            if (!computer.isOn()) {
                ++on;
            }
            computer.turnOn();
        }
        int didOn = on;
        source.method_9226(() -> class_2561.method_43469((String)"commands.computercraft.turn_on.done", (Object[])new Object[]{didOn, computers.size()}), false);
        return on;
    }

    private static int teleport(class_2168 source, ServerComputer computer) throws CommandSyntaxException {
        class_3218 world = computer.getLevel();
        class_243 pos = class_243.method_24955((class_2382)computer.getPosition());
        source.method_9229().method_48105(world, pos.method_10216(), pos.method_10214(), pos.method_10215(), EnumSet.noneOf(class_2709.class), 0.0f, 0.0f);
        return 1;
    }

    private static int queue(Collection<ServerComputer> computers, List<String> args) {
        Object[] rest = args.toArray();
        int queued = 0;
        for (ServerComputer computer : computers) {
            if (computer.getFamily() != ComputerFamily.COMMAND || !computer.isOn()) continue;
            computer.queueEvent("computer_command", rest);
            ++queued;
        }
        return queued;
    }

    private static int view(class_2168 source, final ServerComputer computer) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        new ComputerContainerData(computer, class_1799.field_8037).open((class_1657)player, new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"gui.computercraft.view_computer");
            }

            public class_1703 createMenu(int id, class_1661 player, class_1657 entity) {
                return new ViewComputerMenu(id, player, computer);
            }
        });
        return 1;
    }

    private static int trackStart(class_2168 source) {
        CommandComputerCraft.getMetricsInstance(source).start();
        String stopCommand = "/computercraft track stop";
        source.method_9226(() -> class_2561.method_43469((String)"commands.computercraft.track.start.stop", (Object[])new Object[]{ChatHelpers.link(ChatHelpers.text(stopCommand), stopCommand, (class_2561)class_2561.method_43471((String)"commands.computercraft.track.stop.action"))}), false);
        return 1;
    }

    private static int trackStop(class_2168 source) throws CommandSyntaxException {
        BasicComputerMetricsObserver metrics = CommandComputerCraft.getMetricsInstance(source);
        if (!metrics.stop()) {
            throw Exceptions.NOT_TRACKING_EXCEPTION.create();
        }
        CommandComputerCraft.displayTimings(source, metrics.getSnapshot(), new AggregatedMetric(Metrics.COMPUTER_TASKS, Aggregate.AVG), DEFAULT_FIELDS);
        return 1;
    }

    private static int trackDump(class_2168 source, List<AggregatedMetric> fields) throws CommandSyntaxException {
        AggregatedMetric sort;
        if (fields.size() == 1 && DEFAULT_FIELDS.contains(fields.get(0))) {
            sort = fields.get(0);
            fields = DEFAULT_FIELDS;
        } else {
            sort = fields.get(0);
        }
        return CommandComputerCraft.displayTimings(source, CommandComputerCraft.getMetricsInstance(source).getTimings(), sort, fields);
    }

    private static class_2561 linkComputer(class_2168 source, @Nullable ServerComputer serverComputer, int computerId) {
        class_2561 linkPath;
        class_5250 out = class_2561.method_43470((String)"");
        if (serverComputer == null) {
            out.method_10852((class_2561)ChatHelpers.text("?"));
        } else {
            out.method_10852(ChatHelpers.link(ChatHelpers.text(Integer.toString(serverComputer.getInstanceID())), "/computercraft dump " + serverComputer.getInstanceID(), (class_2561)class_2561.method_43471((String)"commands.computercraft.dump.action")));
        }
        out.method_27693(" (id " + computerId + ")");
        if (serverComputer != null && CommandUtils.isPlayer(source)) {
            if (ModRegistry.Permissions.PERMISSION_TP.test(source)) {
                out.method_27693(" ").method_10852(ChatHelpers.link(ChatHelpers.text("\u261b"), "/computercraft tp " + serverComputer.getInstanceID(), (class_2561)class_2561.method_43471((String)"commands.computercraft.tp.action")));
            }
            if (ModRegistry.Permissions.PERMISSION_VIEW.test(source)) {
                out.method_27693(" ").method_10852(ChatHelpers.link(ChatHelpers.text("\u20e2"), "/computercraft view " + serverComputer.getInstanceID(), (class_2561)class_2561.method_43471((String)"commands.computercraft.view.action")));
            }
        }
        if (CommandUtils.isPlayer(source) && UserLevel.isOwner(source) && (linkPath = CommandComputerCraft.linkStorage(source, computerId)) != null) {
            out.method_27693(" ").method_10852(linkPath);
        }
        return out;
    }

    private static class_2561 linkPosition(class_2168 context, ServerComputer computer) {
        if (ModRegistry.Permissions.PERMISSION_TP.test(context)) {
            return ChatHelpers.link(ChatHelpers.position(computer.getPosition()), "/computercraft tp " + computer.getInstanceID(), (class_2561)class_2561.method_43471((String)"commands.computercraft.tp.action"));
        }
        return ChatHelpers.position(computer.getPosition());
    }

    @Nullable
    private static class_2561 linkStorage(class_2168 source, int id) {
        File file = new File(ServerContext.get(source.method_9211()).storageDir().toFile(), "computer/" + id);
        if (!file.isDirectory()) {
            return null;
        }
        return ChatHelpers.link(ChatHelpers.text("\u270e"), "/computercraft-computer-folder " + id, (class_2561)class_2561.method_43471((String)"commands.computercraft.dump.open_path"));
    }

    private static BasicComputerMetricsObserver getMetricsInstance(class_2168 source) {
        class_1297 entity = source.method_9228();
        return ServerContext.get(source.method_9211()).metrics().getMetricsInstance(entity instanceof class_1657 ? entity.method_5667() : SYSTEM_UUID);
    }

    private static int displayTimings(class_2168 source, List<ComputerMetrics> timings, AggregatedMetric sortField, List<AggregatedMetric> fields) throws CommandSyntaxException {
        if (timings.isEmpty()) {
            throw Exceptions.NO_TIMINGS_EXCEPTION.create();
        }
        timings.sort(Comparator.comparing(x -> x.get(sortField.metric(), sortField.aggregate())).reversed());
        class_2561[] headers = new class_2561[1 + fields.size()];
        headers[0] = class_2561.method_43471((String)"commands.computercraft.track.dump.computer");
        for (int i = 0; i < fields.size(); ++i) {
            headers[i + 1] = fields.get(i).displayName();
        }
        TableBuilder table = new TableBuilder("Metrics", headers);
        for (ComputerMetrics entry : timings) {
            ServerComputer serverComputer = entry.computer();
            class_2561 computerComponent = CommandComputerCraft.linkComputer(source, serverComputer, entry.computerId());
            class_2561[] row = new class_2561[1 + fields.size()];
            row[0] = computerComponent;
            for (int i = 0; i < fields.size(); ++i) {
                AggregatedMetric metric = fields.get(i);
                row[i + 1] = ChatHelpers.text(entry.getFormatted(metric.metric(), metric.aggregate()));
            }
            table.row(row);
        }
        table.display(source);
        return timings.size();
    }

    private static /* synthetic */ int lambda$dump$13(class_1937 world, class_2338 pos, ServerComputer a, ServerComputer b) {
        if (a.getLevel() == b.getLevel() && a.getLevel() == world) {
            return Double.compare(a.getPosition().method_10262((class_2382)pos), b.getPosition().method_10262((class_2382)pos));
        }
        if (a.getLevel() == world) {
            return -1;
        }
        if (b.getLevel() == world) {
            return 1;
        }
        return Integer.compare(a.getInstanceID(), b.getInstanceID());
    }
}

