/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import com.google.common.base.Strings;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.IComputerBlockEntity;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1273;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractComputerBlockEntity
extends class_2586
implements IComputerBlockEntity,
class_1275,
class_3908 {
    private static final String NBT_ID = "ComputerId";
    private static final String NBT_LABEL = "Label";
    private static final String NBT_ON = "On";
    private int instanceID = -1;
    private int computerID = -1;
    @Nullable
    protected String label = null;
    private boolean on = false;
    boolean startOn = false;
    private boolean fresh = false;
    private int invalidSides = 0;
    private final ComponentAccess<IPeripheral> peripherals = PlatformHelper.get().createPeripheralAccess(this, d -> this.invalidSides |= 1 << d.ordinal());
    private class_1273 lockCode = class_1273.field_5817;
    private final ComputerFamily family;

    public AbstractComputerBlockEntity(class_2591<? extends AbstractComputerBlockEntity> type, class_2338 pos, class_2680 state, ComputerFamily family) {
        super(type, pos, state);
        this.family = family;
    }

    protected void unload() {
        if (this.method_10997().field_9236) {
            return;
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.close();
        }
        this.instanceID = -1;
    }

    public void method_11012() {
        super.method_11012();
        this.unload();
    }

    protected boolean canNameWithTag(class_1657 player) {
        return false;
    }

    protected double getInteractRange() {
        return 8.0;
    }

    public boolean isUsable(class_1657 player) {
        return class_2624.method_17487((class_1657)player, (class_1273)this.lockCode, (class_2561)this.method_5476()) && BlockEntityHelpers.isUsable(this, player, this.getInteractRange());
    }

    public class_1269 use(class_1657 player, class_1268 hand) {
        class_1799 currentItem = player.method_5998(hand);
        if (!currentItem.method_7960() && currentItem.method_7909() == class_1802.field_8448 && this.canNameWithTag(player) && currentItem.method_7938()) {
            if (!this.method_10997().field_9236) {
                this.setLabel(currentItem.method_7964().getString());
                currentItem.method_7934(1);
            }
            return class_1269.method_29236((boolean)this.method_10997().field_9236);
        }
        if (!player.method_18276()) {
            if (!this.method_10997().field_9236 && this.isUsable(player)) {
                ServerComputer computer = this.createServerComputer();
                computer.turnOn();
                class_1799 stack = this.method_11010().method_26204() instanceof AbstractComputerBlock ? ((AbstractComputerBlock)this.method_11010().method_26204()).getItem(this) : class_1799.field_8037;
                new ComputerContainerData(computer, stack).open(player, this);
            }
            return class_1269.method_29236((boolean)this.method_10997().field_9236);
        }
        return class_1269.field_5811;
    }

    public void neighborChanged(class_2338 neighbour) {
        this.updateInputAt(neighbour);
    }

    protected void serverTick() {
        if (this.method_10997().field_9236) {
            return;
        }
        if (this.computerID < 0 && !this.startOn) {
            return;
        }
        ServerComputer computer = this.createServerComputer();
        if (this.invalidSides != 0) {
            for (class_2350 direction : DirectionUtil.FACINGS) {
                if ((this.invalidSides & 1 << direction.ordinal()) == 0) continue;
                this.refreshPeripheral(computer, direction);
            }
        }
        if (this.startOn || this.fresh && this.on) {
            computer.turnOn();
            this.startOn = false;
        }
        computer.keepAlive();
        this.fresh = false;
        this.computerID = computer.getID();
        this.label = computer.getLabel();
        this.on = computer.isOn();
        this.updateBlockState(computer.getState());
        if (computer.hasOutputChanged()) {
            this.updateOutput();
        }
    }

    protected abstract void updateBlockState(ComputerState var1);

    public void method_11007(class_2487 nbt) {
        if (this.computerID >= 0) {
            nbt.method_10569(NBT_ID, this.computerID);
        }
        if (this.label != null) {
            nbt.method_10582(NBT_LABEL, this.label);
        }
        nbt.method_10556(NBT_ON, this.on);
        this.lockCode.method_5474(nbt);
        super.method_11007(nbt);
    }

    public final void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.loadClient(nbt);
        } else {
            this.loadServer(nbt);
        }
    }

    protected void loadServer(class_2487 nbt) {
        this.computerID = nbt.method_10545(NBT_ID) ? nbt.method_10550(NBT_ID) : -1;
        this.label = nbt.method_10545(NBT_LABEL) ? nbt.method_10558(NBT_LABEL) : null;
        this.on = this.startOn = nbt.method_10577(NBT_ON);
        this.lockCode = class_1273.method_5473((class_2487)nbt);
    }

    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return false;
    }

    protected abstract class_2350 getDirection();

    protected ComputerSide remapToLocalSide(class_2350 globalSide) {
        return this.remapLocalSide(DirectionUtil.toLocal(this.getDirection(), globalSide));
    }

    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        return localSide;
    }

    private void updateRedstoneInputs(ServerComputer computer) {
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.method_10093(dir));
        }
    }

    private void updateRedstoneInput(ServerComputer computer, class_2350 dir, class_2338 targetPos) {
        class_2350 offsetSide = dir.method_10153();
        ComputerSide localDir = this.remapToLocalSide(dir);
        computer.setRedstoneInput(localDir, RedstoneUtil.getRedstoneInput(this.field_11863, targetPos, dir));
        computer.setBundledRedstoneInput(localDir, BundledRedstone.getOutput(this.method_10997(), targetPos, offsetSide));
    }

    private void refreshPeripheral(ServerComputer computer, class_2350 dir) {
        this.invalidSides &= ~(1 << dir.ordinal());
        ComputerSide localDir = this.remapToLocalSide(dir);
        if (this.isPeripheralBlockedOnSide(localDir)) {
            return;
        }
        IPeripheral peripheral = this.peripherals.get(dir);
        computer.setPeripheral(localDir, peripheral);
    }

    public void updateInputsImmediately() {
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateInputsImmediately(computer);
        }
    }

    private void updateInputsImmediately(ServerComputer computer) {
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(computer, dir, pos.method_10093(dir));
            this.refreshPeripheral(computer, dir);
        }
    }

    private void updateInputAt(class_2338 neighbour) {
        ServerComputer computer = this.getServerComputer();
        if (computer == null) {
            return;
        }
        for (class_2350 dir : DirectionUtil.FACINGS) {
            class_2338 offset = this.method_11016().method_10093(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(computer, dir, offset);
            this.invalidSides |= 1 << dir.ordinal();
            return;
        }
        this.updateRedstoneInputs(computer);
        this.invalidSides = 63;
    }

    public void updateOutput() {
        BlockEntityHelpers.updateBlock(this);
        for (class_2350 dir : DirectionUtil.FACINGS) {
            RedstoneUtil.propagateRedstoneOutput(this.method_10997(), this.method_11016(), dir);
        }
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            this.updateRedstoneInputs(computer);
        }
    }

    protected abstract ServerComputer createComputer(int var1);

    @Override
    public final int getComputerID() {
        return this.computerID;
    }

    @Override
    @Nullable
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final void setComputerID(int id) {
        if (this.method_10997().field_9236 || this.computerID == id) {
            return;
        }
        this.computerID = id;
        this.method_5431();
    }

    @Override
    public final void setLabel(@Nullable String label) {
        if (this.method_10997().field_9236 || Objects.equals(this.label, label)) {
            return;
        }
        this.label = label;
        ServerComputer computer = this.getServerComputer();
        if (computer != null) {
            computer.setLabel(label);
        }
        this.method_5431();
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    public final ServerComputer createServerComputer() {
        MinecraftServer server = this.method_10997().method_8503();
        if (server == null) {
            throw new IllegalStateException("Cannot access server computer on the client.");
        }
        boolean changed = false;
        ServerComputer computer = ServerContext.get(server).registry().get(this.instanceID);
        if (computer == null) {
            if (this.computerID < 0) {
                this.computerID = ComputerCraftAPI.createUniqueNumberedSaveDir(server, "computer");
                BlockEntityHelpers.updateBlock(this);
            }
            computer = this.createComputer(this.computerID);
            this.instanceID = computer.register();
            this.fresh = true;
            changed = true;
        }
        if (changed) {
            this.updateInputsImmediately(computer);
        }
        return computer;
    }

    @Nullable
    public ServerComputer getServerComputer() {
        return this.method_10997().field_9236 || this.method_10997().method_8503() == null ? null : ServerContext.get(this.method_10997().method_8503()).registry().get(this.instanceID);
    }

    public final class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        if (this.label != null) {
            nbt.method_10582(NBT_LABEL, this.label);
        }
        if (this.computerID >= 0) {
            nbt.method_10569(NBT_ID, this.computerID);
        }
        return nbt;
    }

    protected void loadClient(class_2487 nbt) {
        this.label = nbt.method_10545(NBT_LABEL) ? nbt.method_10558(NBT_LABEL) : null;
        this.computerID = nbt.method_10545(NBT_ID) ? nbt.method_10550(NBT_ID) : -1;
    }

    protected void transferStateFrom(AbstractComputerBlockEntity copy) {
        if (copy.computerID != this.computerID || copy.instanceID != this.instanceID) {
            this.unload();
            this.instanceID = copy.instanceID;
            this.computerID = copy.computerID;
            this.label = copy.label;
            this.on = copy.on;
            this.startOn = copy.startOn;
            this.lockCode = copy.lockCode;
            BlockEntityHelpers.updateBlock(this);
        }
        copy.instanceID = -1;
    }

    public class_2561 method_5477() {
        return this.method_16914() ? class_2561.method_43470((String)this.label) : class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public boolean method_16914() {
        return !Strings.isNullOrEmpty((String)this.label);
    }

    @Nullable
    public class_2561 method_5797() {
        return this.method_16914() ? class_2561.method_43470((String)this.label) : null;
    }

    public class_2561 method_5476() {
        return super.method_5476();
    }
}

