/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.impl.UpgradeManager;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistryWrappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public final class UpgradesLoadedMessage
implements NetworkMessage<ClientNetworkContext> {
    private final Map<String, UpgradeManager.UpgradeWrapper<TurtleUpgradeSerialiser<?>, ITurtleUpgrade>> turtleUpgrades;
    private final Map<String, UpgradeManager.UpgradeWrapper<PocketUpgradeSerialiser<?>, IPocketUpgrade>> pocketUpgrades;

    public UpgradesLoadedMessage() {
        this.turtleUpgrades = TurtleUpgrades.instance().getUpgradeWrappers();
        this.pocketUpgrades = PocketUpgrades.instance().getUpgradeWrappers();
    }

    public UpgradesLoadedMessage(class_2540 buf) {
        this.turtleUpgrades = this.fromBytes(buf, TurtleUpgradeSerialiser.registryId());
        this.pocketUpgrades = this.fromBytes(buf, PocketUpgradeSerialiser.registryId());
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase> Map<String, UpgradeManager.UpgradeWrapper<R, T>> fromBytes(class_2540 buf, class_5321<class_2378<R>> registryKey) {
        RegistryWrappers.RegistryWrapper<R> registry = PlatformHelper.get().wrap(registryKey);
        int size = buf.method_10816();
        HashMap<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades = new HashMap<String, UpgradeManager.UpgradeWrapper<R, T>>(size);
        for (int i = 0; i < size; ++i) {
            String id = buf.method_19772();
            class_2960 serialiserId = buf.method_10810();
            UpgradeSerialiser serialiser = (UpgradeSerialiser)registry.tryGet(serialiserId);
            if (serialiser == null) {
                throw new IllegalStateException("Unknown serialiser " + serialiserId);
            }
            Object upgrade = serialiser.fromNetwork(new class_2960(id), buf);
            String modId = buf.method_19772();
            upgrades.put(id, new UpgradeManager.UpgradeWrapper(id, upgrade, serialiser, modId));
        }
        return upgrades;
    }

    @Override
    public void write(class_2540 buf) {
        this.toBytes(buf, TurtleUpgradeSerialiser.registryId(), this.turtleUpgrades);
        this.toBytes(buf, PocketUpgradeSerialiser.registryId(), this.pocketUpgrades);
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase> void toBytes(class_2540 buf, class_5321<class_2378<R>> registryKey, Map<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades) {
        RegistryWrappers.RegistryWrapper<R> registry = PlatformHelper.get().wrap(registryKey);
        buf.method_10804(upgrades.size());
        for (Map.Entry<String, UpgradeManager.UpgradeWrapper<R, T>> entry : upgrades.entrySet()) {
            R serialiser;
            buf.method_10814(entry.getKey());
            R unwrappedSerialiser = serialiser = entry.getValue().serialiser();
            buf.method_10812(Objects.requireNonNull(registry.getKey(serialiser), "Serialiser is not registered!"));
            unwrappedSerialiser.toNetwork(buf, entry.getValue().upgrade());
            buf.method_10814(entry.getValue().modId());
        }
    }

    @Override
    public void handle(ClientNetworkContext context) {
        TurtleUpgrades.instance().loadFromNetwork(this.turtleUpgrades);
        PocketUpgrades.instance().loadFromNetwork(this.pocketUpgrades);
    }

    @Override
    public MessageType<UpgradesLoadedMessage> type() {
        return NetworkMessages.UPGRADES_LOADED;
    }
}

