/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    @Nullable
    private IPocketUpgrade upgrade;
    @Nullable
    private class_1297 entity;
    private class_1799 stack = class_1799.field_8037;
    private int lightColour = -1;
    private boolean lightChanged = false;
    private final Set<class_3222> tracking = new HashSet<class_3222>();

    public PocketServerComputer(class_3218 world, class_2338 position, int computerID, @Nullable String label, ComputerFamily family) {
        super(world, position, computerID, label, family, Config.pocketTermWidth, Config.pocketTermHeight);
    }

    @Override
    @Nullable
    public class_1297 getEntity() {
        class_1297 entity = this.entity;
        if (entity == null || this.stack.method_7960() || !entity.method_5805()) {
            return null;
        }
        if (entity instanceof class_1657) {
            class_1661 inventory = ((class_1657)entity).method_31548();
            return inventory.field_7547.contains((Object)this.stack) || inventory.field_7544.contains((Object)this.stack) ? entity : null;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            return living.method_6047() == this.stack || living.method_6079() == this.stack ? entity : null;
        }
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return itemEntity.method_6983() == this.stack ? entity : null;
        }
        return null;
    }

    @Override
    public int getColour() {
        return IColouredItem.getColourBasic(this.stack);
    }

    @Override
    public void setColour(int colour) {
        IColouredItem.setColourBasic(this.stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        return this.lightColour;
    }

    @Override
    public void setLight(int colour) {
        if (colour < 0 || colour > 0xFFFFFF) {
            colour = -1;
        }
        if (this.lightColour == colour) {
            return;
        }
        this.lightColour = colour;
        this.lightChanged = true;
    }

    @Override
    public class_2487 getUpgradeNBTData() {
        return PocketComputerItem.getUpgradeInfo(this.stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            player.method_31548().method_5431();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.createPeripheral(this);
        this.setPeripheral(ComputerSide.BACK, peripheral);
    }

    @Override
    @Deprecated(forRemoval=true)
    public Map<class_2960, IPeripheral> getUpgrades() {
        return this.upgrade == null ? Map.of() : Collections.singletonMap(this.upgrade.getUpgradeID(), this.getPeripheral(ComputerSide.BACK));
    }

    @Nullable
    public UpgradeData<IPocketUpgrade> getUpgrade() {
        return this.upgrade == null ? null : UpgradeData.of(this.upgrade, this.getUpgradeNBTData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            PocketComputerItem.setUpgrade(this.stack, upgrade);
            this.updateUpgradeNBTData();
            this.upgrade = upgrade == null ? null : upgrade.upgrade();
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(@Nullable class_1297 entity, class_1799 stack, @Nullable IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setLevel((class_3218)entity.method_5770());
            this.setPosition(entity.method_24515());
        }
        if (entity != this.entity && entity instanceof class_3222) {
            this.markTerminalChanged();
        }
        this.entity = entity;
        this.stack = stack;
        if (this.upgrade != upgrade) {
            this.upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.tracking.removeIf(player -> !player.method_5805() || player.method_37908() != this.getLevel());
        boolean sendState = this.hasOutputChanged() || this.lightChanged;
        this.lightChanged = false;
        if (sendState) {
            this.tracking.addAll(this.getLevel().method_18456());
            ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, false), this.tracking);
        } else {
            ArrayList<class_3222> added = new ArrayList<class_3222>();
            for (class_3222 player2 : this.getLevel().method_18456()) {
                if (!this.tracking.add(player2)) continue;
                added.add(player2);
            }
            if (!added.isEmpty()) {
                ServerNetworking.sendToPlayers(new PocketComputerDataMessage(this, false), added);
            }
        }
    }

    @Override
    protected void onTerminalChanged() {
        super.onTerminalChanged();
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (this.entity.method_5805()) {
                ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this, true), player);
            }
        }
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        ServerNetworking.sendToAllPlayers(new PocketComputerDeletedClientMessage(this.getInstanceID()), this.getLevel().method_8503());
    }
}

