/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlock;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.platform.RegistryEntry;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.BlockEntityHelpers;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public class TurtleBlock
extends AbstractComputerBlock<TurtleBlockEntity>
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final float IMMUNE_EXPLOSION_RESISTANCE = 2000.0f;
    private static final class_265 DEFAULT_SHAPE = class_259.method_1081((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private final class_5558<TurtleBlockEntity> clientTicker = (level, pos, state, computer) -> computer.clientTick();

    public TurtleBlock(class_4970.class_2251 settings, RegistryEntry<class_2591<TurtleBlockEntity>> type) {
        super(settings, type);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WaterloggableHelpers.WATERLOGGED});
    }

    @Deprecated
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Deprecated
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_243 class_2432;
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof TurtleBlockEntity) {
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            class_2432 = turtle.getRenderOffset(1.0f);
        } else {
            class_2432 = class_243.field_1353;
        }
        class_243 offset = class_2432;
        return offset.equals((Object)class_243.field_1353) ? DEFAULT_SHAPE : DEFAULT_SHAPE.method_1096(offset.field_1352, offset.field_1351, offset.field_1350);
    }

    @Nullable
    public class_2680 method_9605(class_1750 placement) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)placement.method_8042())).method_11657((class_2769)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    @Deprecated
    public class_3610 method_9545(class_2680 state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Deprecated
    public class_2680 method_9559(class_2680 state, class_2350 side, class_2680 otherState, class_1936 world, class_2338 pos, class_2338 otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return state;
    }

    @Deprecated
    public final void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        TurtleBlockEntity turtle;
        class_2586 class_25862;
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        if (!level.field_9236 && (class_25862 = level.method_8321(pos)) instanceof TurtleBlockEntity && !(turtle = (TurtleBlockEntity)class_25862).hasMoved()) {
            class_1264.method_5451((class_1937)level, (class_2338)pos, (class_1263)turtle);
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        super.method_9567(world, pos, state, entity, stack);
        class_2586 tile = world.method_8321(pos);
        if (!world.field_9236 && tile instanceof TurtleBlockEntity) {
            TurtleSide[] turtleSideArray;
            TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                turtle.setOwningPlayer(player.method_7334());
            }
            if ((turtleSideArray = stack.method_7909()) instanceof TurtleItem) {
                class_2960 overlay;
                TurtleItem item = (TurtleItem)turtleSideArray;
                for (TurtleSide side : TurtleSide.values()) {
                    turtle.getAccess().setUpgradeWithData(side, item.getUpgradeWithData(stack, side));
                }
                turtle.getAccess().setFuelLevel(item.getFuelLevel(stack));
                int colour = item.getColour(stack);
                if (colour != -1) {
                    turtle.getAccess().setColour(colour);
                }
                if ((overlay = item.getOverlay(stack)) != null) {
                    ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
                }
            }
        }
    }

    public float getExplosionResistance(class_2680 state, class_1922 world, class_2338 pos, class_1927 explosion) {
        class_1297 exploder = explosion.method_46406();
        if (exploder instanceof class_1309 || exploder instanceof class_1668) {
            return 2000.0f;
        }
        return this.method_9520();
    }

    @Override
    protected class_1799 getItem(AbstractComputerBlockEntity tile) {
        if (!(tile instanceof TurtleBlockEntity)) {
            return class_1799.field_8037;
        }
        TurtleBlockEntity turtle = (TurtleBlockEntity)tile;
        class_1792 class_17922 = this.method_8389();
        if (!(class_17922 instanceof TurtleItem)) {
            return class_1799.field_8037;
        }
        TurtleItem item = (TurtleItem)class_17922;
        ITurtleAccess access = turtle.getAccess();
        return item.create(turtle.getComputerID(), turtle.getLabel(), access.getColour(), TurtleBlock.withPersistedData(access.getUpgradeWithData(TurtleSide.LEFT)), TurtleBlock.withPersistedData(access.getUpgradeWithData(TurtleSide.RIGHT)), access.getFuelLevel(), turtle.getOverlay());
    }

    @Nullable
    private static UpgradeData<ITurtleUpgrade> withPersistedData(@Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        return upgrade == null ? null : UpgradeData.of(upgrade.upgrade(), upgrade.upgrade().getPersistedData(upgrade.data()));
    }

    @Override
    @Nullable
    public <U extends class_2586> class_5558<U> method_31645(class_1937 level, class_2680 state, class_2591<U> type) {
        return level.field_9236 ? BlockEntityHelpers.createTickerHelper(type, (class_2591)this.type.get(), this.clientTicker) : super.method_31645(level, state, type);
    }
}

