/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.container.BasicContainer;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.TurtleMenu;
import java.util.Collections;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class TurtleBlockEntity
extends AbstractComputerBlockEntity
implements BasicContainer {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private final class_2371<class_1799> inventorySnapshot = class_2371.method_10213((int)16, (Object)class_1799.field_8037);
    private boolean inventoryChanged = false;
    private final IntSupplier fuelLimit;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    @Nullable
    private IPeripheral peripheral;
    @Nullable
    private Runnable onMoved;

    public TurtleBlockEntity(class_2591<? extends TurtleBlockEntity> type, class_2338 pos, class_2680 state, IntSupplier fuelLimit, ComputerFamily family) {
        super(type, pos, state, family);
        this.fuelLimit = fuelLimit;
    }

    boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int id) {
        ServerComputer computer = new ServerComputer((class_3218)this.method_10997(), this.method_11016(), id, this.label, this.getFamily(), 39, 13);
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.brain));
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    protected boolean canNameWithTag(class_1657 player) {
        return true;
    }

    @Override
    protected double getInteractRange() {
        return 12.0;
    }

    @Override
    protected void serverTick() {
        super.serverTick();
        this.brain.update();
        if (this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
        }
    }

    protected void clientTick() {
        this.brain.update();
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void neighborChanged(class_2338 neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.neighborChanged(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void loadServer(class_2487 nbt) {
        super.loadServer(nbt);
        class_2499 nbttaglist = nbt.method_10554("Items", 10);
        this.inventory.clear();
        this.inventorySnapshot.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            class_2487 tag = nbttaglist.method_10602(i);
            int slot = tag.method_10571("Slot") & 0xFF;
            if (slot >= this.method_5439()) continue;
            this.inventory.set(slot, (Object)class_1799.method_7915((class_2487)tag));
            this.inventorySnapshot.set(slot, (Object)((class_1799)this.inventory.get(slot)).method_7972());
        }
        this.brain.readFromNBT(nbt);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        class_2499 nbttaglist = new class_2499();
        for (int i = 0; i < 16; ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            class_2487 tag = new class_2487();
            tag.method_10567("Slot", (byte)i);
            ((class_1799)this.inventory.get(i)).method_7953(tag);
            nbttaglist.add((Object)tag);
        }
        nbt.method_10566("Items", (class_2520)nbttaglist);
        nbt = this.brain.writeToNBT(nbt);
        super.method_11007(nbt);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public class_2350 getDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)TurtleBlock.FACING);
    }

    public void setDirection(class_2350 dir) {
        if (dir.method_10166() == class_2350.class_2351.field_11052) {
            dir = class_2350.field_11043;
        }
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)TurtleBlock.FACING, (Comparable)dir));
        this.updateOutput();
        this.updateInputsImmediately();
        this.onTileEntityChange();
    }

    @Nullable
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    public int getColour() {
        return this.brain.getColour();
    }

    @Nullable
    public class_2960 getOverlay() {
        return this.brain.getOverlay();
    }

    public ITurtleAccess getAccess() {
        return this.brain;
    }

    public class_243 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.onTileEntityChange();
    }

    @Override
    public class_2371<class_1799> getContents() {
        return this.inventory;
    }

    public class_1799 getItemSnapshot(int slot) {
        return slot >= 0 && slot < this.inventorySnapshot.size() ? (class_1799)this.inventorySnapshot.get(slot) : class_1799.field_8037;
    }

    public void method_5431() {
        super.method_5431();
        for (int slot = 0; slot < this.method_5439(); ++slot) {
            class_1799 item = this.method_5438(slot);
            if (class_1799.method_7973((class_1799)item, (class_1799)((class_1799)this.inventorySnapshot.get(slot)))) continue;
            this.inventoryChanged = true;
            this.inventorySnapshot.set(slot, (Object)item.method_7972());
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.isUsable(player);
    }

    public void onTileEntityChange() {
        super.method_5431();
    }

    @Override
    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.brain.writeDescription(nbt);
        return nbt;
    }

    @Override
    public void loadClient(class_2487 nbt) {
        super.loadClient(nbt);
        this.brain.readDescription(nbt);
    }

    public int getFuelLimit() {
        return this.fuelLimit.getAsInt();
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TurtleBlockEntity copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.inventorySnapshot, copy.inventorySnapshot);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        if (this.onMoved != null) {
            this.onMoved.run();
        }
    }

    @Nullable
    public IPeripheral peripheral() {
        if (this.hasMoved()) {
            return null;
        }
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("turtle", this);
        return this.peripheral;
    }

    public void onMoved(Runnable onMoved) {
        this.onMoved = onMoved;
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return TurtleMenu.ofBrain(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

