/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public final class WorldUtil {
    private static final double DROP_SPEED = 0.103365;

    public static boolean isLiquidBlock(class_1937 world, class_2338 pos) {
        if (!world.method_24794(pos)) {
            return false;
        }
        return world.method_8320(pos).method_51176();
    }

    public static boolean isVecInside(class_265 shape, class_243 vec) {
        if (shape.method_1110()) {
            return false;
        }
        class_238 bb = shape.method_1107();
        return vec.field_1352 >= bb.field_1323 && vec.field_1352 <= bb.field_1320 && vec.field_1351 >= bb.field_1322 && vec.field_1351 <= bb.field_1325 && vec.field_1350 >= bb.field_1321 && vec.field_1350 <= bb.field_1324;
    }

    public static class_239 clip(class_1937 world, class_243 from, class_243 direction, double distance, @Nullable class_1297 source) {
        class_243 to = from.method_1031(direction.field_1352 * distance, direction.field_1351 * distance, direction.field_1350 * distance);
        return WorldUtil.clip(world, from, to, source);
    }

    public static class_239 clip(class_1937 world, class_243 from, class_243 to, @Nullable class_1297 source) {
        ContextlessClipContext context = source == null ? new ContextlessClipContext(world, from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348) : new class_3959(from, to, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, source);
        class_3965 blockHit = world.method_17742((class_3959)context);
        double distance = blockHit.method_17783() == class_239.class_240.field_1333 ? from.method_1025(to) : blockHit.method_17784().method_1025(from);
        class_3966 entityHit = WorldUtil.getEntityHitResult(world, from, to, new class_238(from, to).method_1014(1.0), distance, source);
        return entityHit == null ? blockHit : entityHit;
    }

    @Nullable
    private static class_3966 getEntityHitResult(class_1937 level, class_243 from, class_243 to, class_238 bounds, double distanceSq, @Nullable class_1297 source) {
        if (distanceSq <= 0.0) {
            return null;
        }
        double bestDistance = distanceSq;
        class_1297 bestEntity = null;
        class_243 bestHit = null;
        for (class_1297 entity : level.method_8333(source, bounds, WorldUtil::canCollide)) {
            class_243 hit;
            double newDistance;
            class_238 aabb = entity.method_5829().method_1014((double)entity.method_5871());
            if (aabb.method_1006(from)) {
                bestHit = from;
                bestEntity = entity;
                break;
            }
            Optional clip = aabb.method_992(from, to);
            if (clip.isEmpty() || !((newDistance = from.method_1025(hit = (class_243)clip.get())) < bestDistance)) continue;
            bestEntity = entity;
            bestHit = hit;
            bestDistance = newDistance;
        }
        return bestEntity == null ? null : new class_3966(bestEntity, bestHit);
    }

    private static boolean canCollide(class_1297 entity) {
        return entity != null && entity.method_5805() && entity.method_5863();
    }

    public static class_243 getRayStart(class_1657 entity) {
        return entity.method_33571();
    }

    public static class_243 getRayEnd(class_1657 player) {
        double reach = PlatformHelper.get().getReachDistance(player);
        class_243 look = player.method_5720();
        return WorldUtil.getRayStart(player).method_1031(look.field_1352 * reach, look.field_1351 * reach, look.field_1350 * reach);
    }

    public static void dropItemStack(class_1937 level, class_2338 pos, @Nullable class_2350 direction, class_1799 stack) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.method_10148();
            yDir = direction.method_10164();
            zDir = direction.method_10165();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.method_10263() + 0.5 + xDir * 0.7;
        double yPos = (double)pos.method_10264() + 0.5 + yDir * 0.7;
        double zPos = (double)pos.method_10260() + 0.5 + zDir * 0.7;
        class_1542 item = new class_1542(level, xPos, yPos, zPos, stack.method_7972());
        double baseSpeed = level.field_9229.method_43058() * 0.1 + 0.2;
        item.method_18800(level.field_9229.method_43385(xDir * baseSpeed, 0.103365), level.field_9229.method_43385(yDir * baseSpeed, 0.103365), level.field_9229.method_43385(zDir * baseSpeed, 0.103365));
        item.method_6988();
        level.method_8649((class_1297)item);
    }

    private static class ContextlessClipContext
    extends class_3959 {
        private final class_3959.class_3960 block;

        ContextlessClipContext(class_1937 level, class_243 from, class_243 to, class_3959.class_3960 block, class_3959.class_242 fluid) {
            super(from, to, block, fluid, (class_1297)new class_1542(class_1299.field_6052, level));
            this.block = block;
        }

        public class_265 method_17748(class_2680 state, class_1922 level, class_2338 pos) {
            return this.block.get(state, level, pos, class_3726.method_16194());
        }
    }
}

