/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.fullbody;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.animations.PoseOverwrite;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2399;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class LadderAnimation
extends BasicAnimation
implements PoseOverwrite {
    private final Set<Class<? extends class_2248>> ladderLikeBlocks = new HashSet<Class<? extends class_2248>>(){
        {
            this.add(class_2399.class);
            this.add(class_2533.class);
        }
    };
    private final BodyPart[] parts = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};
    private final BodyPart[] partsSneakingRight = new BodyPart[]{BodyPart.RIGHT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};
    private final BodyPart[] partsSneakingLeft = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.BODY, BodyPart.LEFT_LEG, BodyPart.RIGHT_LEG};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.enableLadderAnimation;
    }

    @Override
    public boolean isValid(class_742 entity, PlayerData data) {
        if (entity.method_6101() && !entity.method_24828() && entity.method_24832().isPresent()) {
            for (Class<? extends class_2248> blocktype : this.ladderLikeBlocks) {
                if (!blocktype.isAssignableFrom(entity.method_37908().method_8320((class_2338)entity.method_24832().get()).method_26204().getClass())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(class_742 entity, PlayerData data) {
        if (entity.method_18276() && entity.method_18798().field_1351 == -0.0784000015258789) {
            if (entity.method_6068() == class_1306.field_6183) {
                return this.partsSneakingLeft;
            }
            return this.partsSneakingRight;
        }
        return this.parts;
    }

    @Override
    public int getPriority(class_742 entity, PlayerData data) {
        return 1400;
    }

    @Override
    public void apply(class_742 entity, PlayerData data, class_591<class_742> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY && NEABaseMod.config.enableRotateToLadder) {
            class_2680 blockState = entity.method_36601();
            if (blockState.method_28498((class_2769)class_2383.field_11177)) {
                class_2350 dir = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
                data.disableBodyRotation(true);
                switch (dir) {
                    case field_11043: {
                        entity.method_5636(0.0f);
                        entity.field_6220 = 0.0f;
                        break;
                    }
                    case field_11034: {
                        entity.method_5636(90.0f);
                        entity.field_6220 = 90.0f;
                        break;
                    }
                    case field_11035: {
                        entity.method_5636(180.0f);
                        entity.field_6220 = 180.0f;
                        break;
                    }
                    case field_11039: {
                        entity.method_5636(270.0f);
                        entity.field_6220 = 270.0f;
                        break;
                    }
                }
                AnimationUtil.minMaxHeadRotation((class_1657)entity, model);
            }
            return;
        }
        if (part == BodyPart.LEFT_LEG || part == BodyPart.RIGHT_LEG) {
            float rotation = -class_3532.method_15362((float)((float)(entity.method_23318() * (double)NEABaseMod.config.ladderAnimationArmSpeed)));
            rotation *= NEABaseMod.config.ladderAnimationAmplifier;
            if (part == BodyPart.LEFT_LEG) {
                rotation *= -1.0f;
            }
            AnimationUtil.applyTransforms(model, part, -1.0f - rotation, -0.2f, 0.3f);
            return;
        }
        float rotation = -class_3532.method_15362((float)((float)(entity.method_23318() * (double)NEABaseMod.config.ladderAnimationArmSpeed)));
        rotation *= NEABaseMod.config.ladderAnimationAmplifier;
        if (part == BodyPart.LEFT_ARM) {
            rotation *= -1.0f;
        }
        AnimationUtil.applyTransforms(model, part, -NEABaseMod.config.ladderAnimationArmHeight - rotation, -0.2f, 0.3f);
    }

    @Override
    public void updateState(class_742 entity, PlayerData data, class_591<class_742> playerModel) {
        if (entity.method_18276() && this.isValid(entity, data)) {
            data.setPoseOverwrite(entity.method_18376());
            entity.method_18380(class_4050.field_18076);
            playerModel.field_3400 = false;
        }
    }
}

