/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootClient;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class ChestLootRecipe
implements EmiRecipe {
    private final ClientChestLootTable loot;
    private final ArrayListMultimap<Float, EmiStack> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final class_2561 title;
    private final float columns = 8.0f;

    public ChestLootRecipe(ClientChestLootTable loot) {
        class_5250 rawTitle;
        this.loot = loot;
        if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
            this.isGuaranteedNonChance = true;
        }
        ArrayListMultimap map2 = ArrayListMultimap.create();
        LinkedList<EmiStack> outputsList = new LinkedList<EmiStack>();
        loot.items.forEach((item, weight) -> {
            EmiStack stack = EmiStack.of((class_1799)item);
            map2.put(weight, (Object)stack);
            outputsList.add(stack);
        });
        this.lootStacksSorted = map2;
        this.lootStacksSortedSize = loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? this.lootStacksSorted.keySet().size() : loot.items.size();
        this.outputs = outputsList;
        String key = "emi_loot.chest." + loot.id.toString();
        class_5250 text = LText.translatable(key);
        if (Objects.equals(text.getString(), key)) {
            Optional modNameOpt = FabricLoader.getInstance().getModContainer(loot.id.method_12836());
            if (modNameOpt.isPresent()) {
                ModContainer modContainer = (ModContainer)modNameOpt.get();
                String modName = modContainer.getMetadata().getName();
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", modName);
            } else {
                class_5250 unknown = LText.translatable("emi_loot.chest.unknown");
                rawTitle = LText.translatable("emi_loot.chest.unknown_chest", unknown.getString());
            }
        } else {
            rawTitle = text;
        }
        class_5250 dots = LText.literal("...");
        int dotsWidth = class_310.method_1551().field_1772.method_27525((class_5348)dots);
        if (class_310.method_1551().field_1772.method_27525((class_5348)rawTitle) > 138 - dotsWidth) {
            String trimmed = class_310.method_1551().field_1772.method_27523(rawTitle.getString(), 138 - dotsWidth) + "...";
            this.title = LText.literal(trimmed);
        } else {
            this.title = rawTitle;
        }
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.LOOT_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960("emi", EMILootClient.MOD_ID + "/" + this.getCategory().id.method_12832() + "/" + this.loot.id.method_12836() + "/" + this.loot.id.method_12832());
    }

    public List<EmiIngredient> getInputs() {
        return new LinkedList<EmiIngredient>();
    }

    public List<EmiIngredient> getCatalysts() {
        return super.getCatalysts();
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.chestLootCompact ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.addText(this.title.method_30937(), 1, 0, 0x404040, false);
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : this.lootStacksSorted.asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight);
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.percentage", fTrim)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), 2);
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((class_2561)LText.translatable("emi_loot.rolls", fTrim).method_27695(new class_124[]{class_124.field_1056, class_124.field_1065})));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public boolean hideCraftable() {
        return super.hideCraftable();
    }
}

