/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.drain;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.drain.ItemDrainItemHandler;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class ItemDrainBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
SidedStorageBlockEntity {
    public static final int FILLING_TIME = 20;
    SmartFluidTankBehaviour internalTank;
    TransportedItemStack heldItem;
    protected int processingTicks;
    Map<class_2350, ItemDrainItemHandler> itemHandlers;
    SnapshotParticipant<TransportedItemStack> snapshotParticipant = new SnapshotParticipant<TransportedItemStack>(){

        protected TransportedItemStack createSnapshot() {
            return ItemDrainBlockEntity.this.heldItem == null ? TransportedItemStack.EMPTY : ItemDrainBlockEntity.this.heldItem.fullCopy();
        }

        protected void readSnapshot(TransportedItemStack snapshot) {
            ItemDrainBlockEntity.this.heldItem = snapshot == TransportedItemStack.EMPTY ? null : snapshot;
        }

        protected void onFinalCommit() {
            ItemDrainBlockEntity.this.notifyUpdate();
        }
    };

    public ItemDrainBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.itemHandlers = new IdentityHashMap<class_2350, ItemDrainItemHandler>();
        for (class_2350 d : Iterate.horizontalDirections) {
            ItemDrainItemHandler itemDrainItemHandler = new ItemDrainItemHandler(this, d);
            this.itemHandlers.put(d, itemDrainItemHandler);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).allowingBeltFunnels().setInsertionHandler(this::tryInsertingFromSide));
        this.internalTank = SmartFluidTankBehaviour.single(this, 121500L).allowExtraction().forbidInsertion();
        behaviours.add(this.internalTank);
        this.registerAwardables(behaviours, AllAdvancements.DRAIN, AllAdvancements.CHAINED_DRAIN);
    }

    private class_1799 tryInsertingFromSide(TransportedItemStack transportedStack, class_2350 side, boolean simulate) {
        class_1799 inserted = transportedStack.stack;
        class_1799 returned = class_1799.field_8037;
        if (!this.getHeldItemStack().method_7960()) {
            return inserted;
        }
        if (inserted.method_7947() > 1 && GenericItemEmptying.canItemBeEmptied(this.field_11863, inserted)) {
            returned = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)(inserted.method_7947() - 1));
            inserted = ItemHandlerHelper.copyStackWithSize((class_1799)inserted, (int)1);
        }
        if (simulate) {
            return returned;
        }
        transportedStack = transportedStack.copy();
        transportedStack.stack = inserted.method_7972();
        transportedStack.beltPosition = side.method_10166().method_10178() ? 0.5f : 0.0f;
        transportedStack.prevSideOffset = transportedStack.sideOffset;
        transportedStack.prevBeltPosition = transportedStack.beltPosition;
        this.setHeldItem(transportedStack, side);
        this.method_5431();
        this.sendData();
        return returned;
    }

    public class_1799 getHeldItemStack() {
        return this.heldItem == null ? class_1799.field_8037 : this.heldItem.stack;
    }

    @Override
    public void tick() {
        boolean onClient;
        super.tick();
        if (this.heldItem == null) {
            this.processingTicks = 0;
            return;
        }
        boolean bl = onClient = this.field_11863.field_9236 && !this.isVirtual();
        if (this.processingTicks > 0) {
            boolean wasAtBeginning;
            this.heldItem.prevBeltPosition = 0.5f;
            boolean bl2 = wasAtBeginning = this.processingTicks == 20;
            if (!onClient || this.processingTicks < 20) {
                --this.processingTicks;
            }
            if (!this.continueProcessing()) {
                this.processingTicks = 0;
                this.notifyUpdate();
                return;
            }
            if (wasAtBeginning != (this.processingTicks == 20)) {
                this.sendData();
            }
            return;
        }
        this.heldItem.prevBeltPosition = this.heldItem.beltPosition;
        this.heldItem.prevSideOffset = this.heldItem.sideOffset;
        this.heldItem.beltPosition += this.itemMovementPerTick();
        if (this.heldItem.beltPosition > 1.0f) {
            class_2338 nextPosition;
            DirectBeltInputBehaviour directBeltInputBehaviour;
            this.heldItem.beltPosition = 1.0f;
            if (onClient) {
                return;
            }
            class_2350 side = this.heldItem.insertedFrom;
            class_1799 tryExportingToBeltFunnel = this.getBehaviour(DirectBeltInputBehaviour.TYPE).tryExportingToBeltFunnel(this.heldItem.stack, side.method_10153(), false);
            if (tryExportingToBeltFunnel != null) {
                if (tryExportingToBeltFunnel.method_7947() != this.heldItem.stack.method_7947()) {
                    if (tryExportingToBeltFunnel.method_7960()) {
                        this.heldItem = null;
                    } else {
                        this.heldItem.stack = tryExportingToBeltFunnel;
                    }
                    this.notifyUpdate();
                    return;
                }
                if (!tryExportingToBeltFunnel.method_7960()) {
                    return;
                }
            }
            if ((directBeltInputBehaviour = BlockEntityBehaviour.get((class_1922)this.field_11863, nextPosition = this.field_11867.method_10093(side), DirectBeltInputBehaviour.TYPE)) == null) {
                if (!BlockHelper.hasBlockSolidSide(this.field_11863.method_8320(nextPosition), (class_1922)this.field_11863, nextPosition, side.method_10153())) {
                    class_1799 ejected = this.heldItem.stack;
                    class_243 outPos = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(class_243.method_24954((class_2382)side.method_10163()).method_1021(0.75));
                    float movementSpeed = this.itemMovementPerTick();
                    class_243 outMotion = class_243.method_24954((class_2382)side.method_10163()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
                    outPos.method_1019(outMotion.method_1029());
                    class_1542 entity = new class_1542(this.field_11863, outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
                    entity.method_18799(outMotion);
                    entity.method_6988();
                    entity.field_6037 = true;
                    this.field_11863.method_8649((class_1297)entity);
                    this.heldItem = null;
                    this.notifyUpdate();
                }
                return;
            }
            if (!directBeltInputBehaviour.canInsertFromSide(side)) {
                return;
            }
            class_1799 returned = directBeltInputBehaviour.handleInsertion(this.heldItem.copy(), side, false);
            if (returned.method_7960()) {
                if (this.field_11863.method_8321(nextPosition) instanceof ItemDrainBlockEntity) {
                    this.award(AllAdvancements.CHAINED_DRAIN);
                }
                this.heldItem = null;
                this.notifyUpdate();
                return;
            }
            if (returned.method_7947() != this.heldItem.stack.method_7947()) {
                this.heldItem.stack = returned;
                this.notifyUpdate();
                return;
            }
            return;
        }
        if (this.heldItem.prevBeltPosition < 0.5f && this.heldItem.beltPosition >= 0.5f) {
            if (!GenericItemEmptying.canItemBeEmptied(this.field_11863, this.heldItem.stack)) {
                return;
            }
            this.heldItem.beltPosition = 0.5f;
            if (onClient) {
                return;
            }
            this.processingTicks = 20;
            this.sendData();
        }
    }

    protected boolean continueProcessing() {
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return true;
        }
        if (this.processingTicks < 5) {
            return true;
        }
        if (!GenericItemEmptying.canItemBeEmptied(this.field_11863, this.heldItem.stack)) {
            return false;
        }
        Pair<FluidStack, class_1799> emptyItem = GenericItemEmptying.emptyItem(this.field_11863, this.heldItem.stack, true);
        FluidStack fluidFromItem = emptyItem.getFirst();
        try (Transaction t = TransferUtil.getTransaction();){
            if (this.processingTicks > 5) {
                this.internalTank.allowInsertion();
                try (Transaction nested2 = t.openNested();){
                    long inserted;
                    if (!fluidFromItem.isEmpty() && (inserted = this.internalTank.getPrimaryHandler().insert(fluidFromItem.getType(), fluidFromItem.getAmount(), (TransactionContext)nested2)) != fluidFromItem.getAmount()) {
                        this.internalTank.forbidInsertion();
                        this.processingTicks = 20;
                        boolean bl = true;
                        return bl;
                    }
                }
                this.internalTank.forbidInsertion();
                boolean nested2 = true;
                return nested2;
            }
            emptyItem = GenericItemEmptying.emptyItem(this.field_11863, this.heldItem.stack.method_7972(), false);
            this.award(AllAdvancements.DRAIN);
            class_1799 out = emptyItem.getSecond();
            if (!out.method_7960()) {
                this.heldItem.stack = out;
            } else {
                this.heldItem = null;
            }
            this.internalTank.allowInsertion();
            TransferUtil.insertFluid((Storage)this.internalTank.getPrimaryHandler(), (FluidStack)fluidFromItem);
            t.commit();
            this.internalTank.forbidInsertion();
            this.notifyUpdate();
            boolean bl = true;
            return bl;
        }
    }

    private float itemMovementPerTick() {
        return 0.125f;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    public void setHeldItem(TransportedItemStack heldItem, class_2350 insertedFrom) {
        this.heldItem = heldItem;
        this.heldItem.insertedFrom = insertedFrom;
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("ProcessingTicks", this.processingTicks);
        if (this.heldItem != null) {
            compound.method_10566("HeldItem", (class_2520)this.heldItem.serializeNBT());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.heldItem = null;
        this.processingTicks = compound.method_10550("ProcessingTicks");
        if (compound.method_10545("HeldItem")) {
            this.heldItem = TransportedItemStack.read(compound.method_10562("HeldItem"));
        }
        super.read(compound, clientPacket);
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (face != class_2350.field_11036) {
            return this.internalTank.getCapability();
        }
        return null;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        if (face != null && face.method_10166().method_10179()) {
            return (Storage)this.itemHandlers.get(face);
        }
        return null;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }
}

