/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.compat.Mods;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.ShadowRenderHelper;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import io.github.foundationgames.sandwichable.items.ItemsRegistry;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class BeltRenderer
extends SafeBlockEntityRenderer<BeltBlockEntity> {
    public BeltRenderer(class_5614.class_5615 context) {
    }

    public boolean shouldRenderOffScreen(BeltBlockEntity be) {
        return be.isController();
    }

    @Override
    protected void renderSafe(BeltBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!Backend.canUseInstancing((class_1937)be.method_10997())) {
            class_2680 blockState = be.method_11010();
            if (!AllBlocks.BELT.has(blockState)) {
                return;
            }
            BeltSlope beltSlope = (BeltSlope)((Object)blockState.method_11654(BeltBlock.SLOPE));
            BeltPart part = (BeltPart)((Object)blockState.method_11654(BeltBlock.PART));
            class_2350 facing = (class_2350)blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
            class_2350.class_2352 axisDirection = facing.method_10171();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.method_10166() == class_2350.class_2351.field_11048;
            class_4587 localTransforms = new class_4587();
            TransformStack msr = TransformStack.cast((class_4587)localTransforms);
            class_4588 vb = buffer.getBuffer(class_1921.method_23577());
            float renderTick = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateY((double)(AngleHelper.horizontalAngle(facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0)))).rotateZ(sideways ? 90.0 : 0.0)).rotateX(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0 : 0.0)).unCentre();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == class_2350.class_2352.field_11056) {
                boolean b = start;
                start = end;
                end = b;
            }
            class_1767 color = be.color.orElse(null);
            for (boolean bottom : Iterate.trueAndFalse) {
                PartialModel beltPartial = BeltRenderer.getBeltPartial(diagonal, start, end, bottom);
                SuperByteBuffer beltBuffer = CachedBufferer.partial(beltPartial, blockState).light(light);
                SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);
                float speed = be.getSpeed();
                if (speed != 0.0f || be.color.isPresent()) {
                    float time = renderTick * (float)axisDirection.method_10181();
                    if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == class_2350.class_2352.field_11060) {
                        speed = -speed;
                    }
                    float scrollMult = diagonal ? 0.375f : 0.5f;
                    float spriteSize = spriteShift.getTarget().method_4575() - spriteShift.getTarget().method_4593();
                    double scroll = (double)(speed * time) / 504.0 + (bottom ? 0.5 : 0.0);
                    scroll -= Math.floor(scroll);
                    scroll = scroll * (double)spriteSize * (double)scrollMult;
                    beltBuffer.shiftUVScrolling(spriteShift, (float)scroll);
                }
                beltBuffer.transform(localTransforms).renderInto(ms, vb);
                if (diagonal) break;
            }
            if (be.hasPulley()) {
                class_2350 dir = sideways ? class_2350.field_11036 : ((class_2350)blockState.method_11654(BeltBlock.HORIZONTAL_FACING)).method_10170();
                Supplier<class_4587> matrixStackSupplier = () -> {
                    class_4587 stack = new class_4587();
                    TransformStack stacker = TransformStack.cast((class_4587)stack);
                    stacker.centre();
                    if (dir.method_10166() == class_2350.class_2351.field_11048) {
                        stacker.rotateY(90.0);
                    }
                    if (dir.method_10166() == class_2350.class_2351.field_11052) {
                        stacker.rotateX(90.0);
                    }
                    stacker.rotateX(90.0);
                    stacker.unCentre();
                    return stack;
                };
                SuperByteBuffer superBuffer = CachedBufferer.partialDirectional(AllPartialModels.BELT_PULLEY, blockState, dir, matrixStackSupplier);
                KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light).renderInto(ms, vb);
            }
        }
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
    }

    public static SpriteShiftEntry getSpriteShiftEntry(class_1767 color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : (bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS)).get(color);
        }
        return diagonal ? AllSpriteShifts.BELT_DIAGONAL : (bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT);
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return AllPartialModels.BELT_DIAGONAL_START;
            }
            if (end) {
                return AllPartialModels.BELT_DIAGONAL_END;
            }
            return AllPartialModels.BELT_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return AllPartialModels.BELT_START_BOTTOM;
            }
            if (end) {
                return AllPartialModels.BELT_END_BOTTOM;
            }
            return AllPartialModels.BELT_MIDDLE_BOTTOM;
        }
        if (start) {
            return AllPartialModels.BELT_START;
        }
        if (end) {
            return AllPartialModels.BELT_END;
        }
        return AllPartialModels.BELT_MIDDLE;
    }

    protected void renderItems(BeltBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (be.beltLength == 0) {
            return;
        }
        ms.method_22903();
        class_2350 beltFacing = be.getBeltFacing();
        class_2382 directionVec = beltFacing.method_10163();
        class_243 beltStartOffset = class_243.method_24954((class_2382)directionVec).method_1021(-0.5).method_1031(0.5, 0.9375, 0.5);
        ms.method_22904(beltStartOffset.field_1352, beltStartOffset.field_1351, beltStartOffset.field_1350);
        BeltSlope slope = (BeltSlope)((Object)be.method_11010().method_11654(BeltBlock.SLOPE));
        int verticality = slope == BeltSlope.DOWNWARD ? -1 : (slope == BeltSlope.UPWARD ? 1 : 0);
        boolean slopeAlongX = beltFacing.method_10166() == class_2350.class_2351.field_11048;
        boolean onContraption = be.method_10997() instanceof WrappedWorld;
        for (TransportedItemStack transported : be.getInventory().getTransportedItems()) {
            boolean alongX;
            boolean tiltForward;
            float sideOffset;
            float offset;
            ms.method_22903();
            TransformStack.cast((class_4587)ms).nudge(transported.angle);
            if (be.getSpeed() == 0.0f) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            } else {
                offset = class_3532.method_16439((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
                sideOffset = class_3532.method_16439((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            }
            float verticalMovement = (double)offset < 0.5 ? 0.0f : (float)verticality * (Math.min(offset, (float)be.beltLength - 0.5f) - 0.5f);
            class_243 offsetVec = class_243.method_24954((class_2382)directionVec).method_1021((double)offset);
            if (verticalMovement != 0.0f) {
                offsetVec = offsetVec.method_1031(0.0, (double)verticalMovement, 0.0);
            }
            boolean onSlope = slope != BeltSlope.HORIZONTAL && class_3532.method_15363((float)offset, (float)0.5f, (float)((float)be.beltLength - 0.5f)) == offset;
            boolean bl = tiltForward = (slope == BeltSlope.DOWNWARD ^ beltFacing.method_10171() == class_2350.class_2352.field_11056) == (beltFacing.method_10166() == class_2350.class_2351.field_11051);
            float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
            ms.method_22904(offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350);
            boolean bl2 = alongX = beltFacing.method_10170().method_10166() == class_2350.class_2351.field_11048;
            if (!alongX) {
                sideOffset *= -1.0f;
            }
            ms.method_46416(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : sideOffset);
            int stackLight = onContraption ? light : this.getPackedLight(be, offset);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            boolean renderUpright = BeltHelper.isItemUpright(transported.stack);
            boolean blockItem = itemRenderer.method_4019(transported.stack, be.method_10997(), null, 0).method_4712();
            Boolean sandwich = Mods.SANDWICHABLE.runIfInstalled(() -> () -> transported.stack.method_31574(ItemsRegistry.SANDWICH)).orElse(Boolean.FALSE);
            if (sandwich.booleanValue()) {
                blockItem = false;
            }
            int count = class_3532.method_15351((int)transported.stack.method_7947()) / 2;
            Random r = new Random(transported.angle);
            boolean slopeShadowOnly = renderUpright && onSlope;
            float slopeOffset = 0.125f;
            if (slopeShadowOnly) {
                ms.method_22903();
            }
            if (!renderUpright || slopeShadowOnly) {
                ms.method_22907((slopeAlongX ? class_7833.field_40718 : class_7833.field_40714).rotationDegrees(slopeAngle));
            }
            if (onSlope) {
                ms.method_46416(0.0f, slopeOffset, 0.0f);
            }
            ms.method_22903();
            ms.method_46416(0.0f, -0.12f, 0.0f);
            ShadowRenderHelper.renderShadow(ms, buffer, 0.75f, 0.2f);
            ms.method_22909();
            if (slopeShadowOnly) {
                ms.method_22909();
                ms.method_46416(0.0f, slopeOffset, 0.0f);
            }
            if (renderUpright) {
                class_1297 renderViewEntity = class_310.method_1551().field_1719;
                if (renderViewEntity != null) {
                    class_243 positionVec = renderViewEntity.method_19538();
                    class_243 vectorForOffset = BeltHelper.getVectorForOffset(be, offset);
                    class_243 diff = vectorForOffset.method_1020(positionVec);
                    float yRot = (float)(class_3532.method_15349((double)diff.field_1352, (double)diff.field_1350) + Math.PI);
                    ms.method_22907(class_7833.field_40716.rotation(yRot));
                }
                ms.method_22904(0.0, 0.09375, 0.0625);
            }
            for (int i = 0; i <= count; ++i) {
                ms.method_22903();
                ms.method_22907(class_7833.field_40716.rotationDegrees((float)transported.angle));
                if (!blockItem && !renderUpright) {
                    ms.method_22904(0.0, -0.09375, 0.0);
                    ms.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                }
                if (blockItem) {
                    ms.method_46416(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
                }
                ms.method_22905(0.5f, 0.5f, 0.5f);
                itemRenderer.method_23177(null, transported.stack, class_811.field_4319, false, ms, buffer, be.method_10997(), stackLight, overlay, 0);
                ms.method_22909();
                if (!renderUpright) {
                    if (!blockItem) {
                        ms.method_22907(class_7833.field_40716.rotationDegrees(10.0f));
                    }
                    ms.method_22904(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                    continue;
                }
                ms.method_46416(0.0f, 0.0f, -0.0625f);
            }
            ms.method_22909();
        }
        ms.method_22909();
    }

    protected int getPackedLight(BeltBlockEntity controller, float beltPos) {
        int segment = (int)Math.floor(beltPos);
        if (controller.lighter == null || segment >= controller.lighter.lightSegments() || segment < 0) {
            return 0;
        }
        return controller.lighter.getPackedLight(segment);
    }
}

