/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.ContraptionHandlerClient;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainRelocationPacket;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphHelper;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class TrainRelocator {
    static WeakReference<CarriageContraptionEntity> hoveredEntity = new WeakReference<Object>(null);
    static UUID relocatingTrain;
    static class_243 relocatingOrigin;
    static int relocatingEntityId;
    static class_2338 lastHoveredPos;
    static BezierTrackPointLocation lastHoveredBezierSegment;
    static Boolean lastHoveredResult;
    static List<class_243> toVisualise;

    public static boolean isRelocating() {
        return relocatingTrain != null;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean onClicked() {
        if (relocatingTrain == null) {
            return false;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        if (player.method_7325()) {
            return false;
        }
        if (!player.method_19538().method_24802((class_2374)relocatingOrigin, 24.0) || player.method_21749()) {
            relocatingTrain = null;
            player.method_7353((class_2561)Lang.translateDirect("train.relocate.abort", new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        if (player.method_5765()) {
            return false;
        }
        if (mc.field_1687 == null) {
            return false;
        }
        Train relocating = TrainRelocator.getRelocating((class_1936)mc.field_1687);
        if (relocating != null) {
            Boolean relocate = TrainRelocator.relocateClient(relocating, false);
            if (relocate != null && relocate.booleanValue()) {
                relocatingTrain = null;
            }
            if (relocate != null) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static Boolean relocateClient(Train relocating, boolean simulate) {
        class_2680 blockState;
        class_2248 class_22482;
        TrackBlockOutline.BezierPointSelection bezierSelection;
        class_243 offset;
        class_310 mc = class_310.method_1551();
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3965)) {
            return null;
        }
        class_3965 blockhit = (class_3965)hitResult;
        class_2338 blockPos = blockhit.method_17777();
        BezierTrackPointLocation hoveredBezier = null;
        boolean upsideDown = relocating.carriages.get(0).leadingBogey().isUpsideDown();
        class_243 class_2432 = offset = upsideDown ? new class_243(0.0, -0.5, 0.0) : class_243.field_1353;
        if (simulate && toVisualise != null && lastHoveredResult != null) {
            for (int i = 0; i < toVisualise.size() - 1; ++i) {
                class_243 vec1 = toVisualise.get(i).method_1019(offset);
                class_243 vec2 = toVisualise.get(i + 1).method_1019(offset);
                CreateClient.OUTLINER.showLine(Pair.of(relocating, i), vec1.method_1031(0.0, (double)-0.925f, 0.0), vec2.method_1031(0.0, (double)-0.925f, 0.0)).colored(lastHoveredResult != false || i != toVisualise.size() - 2 ? 9817409 : 15359019).disableLineNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
            }
        }
        if ((bezierSelection = TrackBlockOutline.result) != null) {
            blockPos = bezierSelection.blockEntity().method_11016();
            hoveredBezier = bezierSelection.loc();
        }
        if (simulate) {
            if (lastHoveredPos != null && lastHoveredPos.equals((Object)blockPos) && Objects.equals(lastHoveredBezierSegment, hoveredBezier)) {
                return lastHoveredResult;
            }
            lastHoveredPos = blockPos;
            lastHoveredBezierSegment = hoveredBezier;
            toVisualise = null;
        }
        if (!((class_22482 = (blockState = mc.field_1687.method_8320(blockPos)).method_26204()) instanceof ITrackBlock)) {
            lastHoveredResult = null;
            return null;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        class_243 lookAngle = mc.field_1724.method_5720();
        boolean direction = bezierSelection != null && lookAngle.method_1026(bezierSelection.direction()) < 0.0;
        boolean result = TrainRelocator.relocate(relocating, (class_1937)mc.field_1687, blockPos, hoveredBezier, direction, lookAngle, true);
        if (!simulate && result) {
            relocating.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                e.nonDamageTicks = 10;
            }));
            AllPackets.getChannel().sendToServer((C2SPacket)new TrainRelocationPacket(relocatingTrain, blockPos, hoveredBezier, direction, lookAngle, relocatingEntityId));
        }
        lastHoveredResult = result;
        return lastHoveredResult;
    }

    public static boolean relocate(Train train, class_1937 level, class_2338 pos, BezierTrackPointLocation bezier, boolean bezierDirection, class_243 lookAngle, boolean simulate) {
        TrackGraphLocation graphLocation;
        class_2680 blockState = level.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return false;
        }
        ITrackBlock track = (ITrackBlock)class_22482;
        Pair<class_243, class_2350.class_2352> nearestTrackAxis = track.getNearestTrackAxis((class_1922)level, pos, blockState, lookAngle);
        TrackGraphLocation trackGraphLocation = bezier != null ? TrackGraphHelper.getBezierGraphLocationAt(level, pos, bezierDirection ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060, bezier) : (graphLocation = TrackGraphHelper.getGraphLocationAt(level, pos, nearestTrackAxis.getSecond(), nearestTrackAxis.getFirst()));
        if (graphLocation == null) {
            return false;
        }
        TrackGraph graph = graphLocation.graph;
        TrackNode node1 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getFirst()));
        TrackNode node2 = graph.locateNode((TrackNodeLocation)((Object)graphLocation.edge.getSecond()));
        TrackEdge edge = graph.getConnectionsFrom(node1).get(node2);
        if (edge == null) {
            return false;
        }
        TravellingPoint probe = new TravellingPoint(node1, node2, edge, graphLocation.position, false);
        TravellingPoint.IEdgePointListener ignoreSignals = probe.ignoreEdgePoints();
        TravellingPoint.ITurnListener ignoreTurns = probe.ignoreTurns();
        ArrayList recordedLocations = new ArrayList();
        ArrayList recordedVecs = new ArrayList();
        Consumer<TravellingPoint> recorder = tp -> {
            recordedLocations.add(Pair.of(Couple.create(tp.node1, tp.node2), tp.position));
            recordedVecs.add(tp.getPosition(graph));
        };
        TravellingPoint.ITrackSelector steer = probe.steer(TravellingPoint.SteerDirection.NONE, track.getUpNormal((class_1922)level, pos, blockState));
        MutableBoolean blocked = new MutableBoolean(false);
        MutableBoolean portal = new MutableBoolean(false);
        MutableInt blockingIndex = new MutableInt(0);
        train.forEachTravellingPointBackwards((tp, d) -> {
            if (blocked.booleanValue()) {
                return;
            }
            probe.travel(graph, (double)d, steer, ignoreSignals, ignoreTurns, $ -> {
                portal.setTrue();
                return true;
            });
            recorder.accept(probe);
            if (probe.blocked || portal.booleanValue()) {
                blocked.setTrue();
                return;
            }
            blockingIndex.increment();
        });
        if (level.field_9236 && simulate && !recordedVecs.isEmpty()) {
            toVisualise = new ArrayList<class_243>();
            toVisualise.add((class_243)recordedVecs.get(0));
        }
        for (int i = 0; i < recordedVecs.size() - 1; ++i) {
            boolean collided;
            class_243 vec1 = (class_243)recordedVecs.get(i);
            class_243 vec2 = (class_243)recordedVecs.get(i + 1);
            boolean blocking = i >= blockingIndex.intValue() - 1;
            boolean bl = collided = !blocked.booleanValue() && Train.findCollidingTrain(level, vec1, vec2, train, (class_5321<class_1937>)level.method_27983()) != null;
            if (level.field_9236 && simulate) {
                toVisualise.add(vec2);
            }
            if (!collided && !blocking) continue;
            return false;
        }
        if (blocked.booleanValue()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        train.leaveStation();
        train.derailed = false;
        train.navigation.waitingForSignal = null;
        train.occupiedSignalBlocks.clear();
        train.graph = graph;
        train.speed = 0.0;
        train.migratingPoints.clear();
        train.cancelStall();
        if (train.navigation.destination != null) {
            train.navigation.cancelNavigation();
        }
        train.forEachTravellingPoint(tp -> {
            Pair last = (Pair)recordedLocations.remove(recordedLocations.size() - 1);
            tp.node1 = (TrackNode)((Couple)last.getFirst()).getFirst();
            tp.node2 = (TrackNode)((Couple)last.getFirst()).getSecond();
            tp.position = (Double)last.getSecond();
            tp.edge = graph.getConnectionsFrom(tp.node1).get(tp.node2);
        });
        for (Carriage carriage : train.carriages) {
            carriage.updateContraptionAnchors();
        }
        train.status.successfulMigration();
        train.collectInitiallyOccupiedSignalBlocks();
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static void visualise(Train train, int i, class_243 v1, class_243 v2, boolean valid) {
        CreateClient.OUTLINER.showLine(Pair.of(train, i), v1.method_1031(0.0, (double)-0.825f, 0.0), v2.method_1031(0.0, (double)-0.825f, 0.0)).colored(valid ? 9817409 : 15359019).disableLineNormals().lineWidth(i % 2 == 1 ? 0.16666667f : 0.25f);
    }

    @Environment(value=EnvType.CLIENT)
    public static void clientTick() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        if (player.method_5765()) {
            return;
        }
        if (mc.field_1687 == null) {
            return;
        }
        if (relocatingTrain != null) {
            AbstractContraptionEntity ce;
            Train relocating = TrainRelocator.getRelocating((class_1936)mc.field_1687);
            if (relocating == null) {
                relocatingTrain = null;
                return;
            }
            class_1297 entity = mc.field_1687.method_8469(relocatingEntityId);
            if (entity instanceof AbstractContraptionEntity && Math.abs((ce = (AbstractContraptionEntity)entity).method_30950(0.0f).method_1020(ce.method_30950(1.0f)).method_1027()) > 9.765625E-4) {
                player.method_7353((class_2561)Lang.translateDirect("train.cannot_relocate_moving", new Object[0]).method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }
            if (!AllItems.WRENCH.isIn(player.method_6047())) {
                player.method_7353((class_2561)Lang.translateDirect("train.relocate.abort", new Object[0]).method_27692(class_124.field_1061), true);
                relocatingTrain = null;
                return;
            }
            if (!player.method_19538().method_24802((class_2374)relocatingOrigin, 24.0)) {
                player.method_7353((class_2561)Lang.translateDirect("train.relocate.too_far", new Object[0]).method_27692(class_124.field_1061), true);
                return;
            }
            Boolean success = TrainRelocator.relocateClient(relocating, true);
            if (success == null) {
                player.method_7353((class_2561)Lang.translateDirect("train.relocate", relocating.name), true);
            } else if (success.booleanValue()) {
                player.method_7353((class_2561)Lang.translateDirect("train.relocate.valid", new Object[0]).method_27692(class_124.field_1060), true);
            } else {
                player.method_7353((class_2561)Lang.translateDirect("train.relocate.invalid", new Object[0]).method_27692(class_124.field_1061), true);
            }
            return;
        }
        Couple<class_243> rayInputs = ContraptionHandlerClient.getRayInputs(player);
        class_243 origin = (class_243)rayInputs.getFirst();
        class_243 target = (class_243)rayInputs.getSecond();
        CarriageContraptionEntity currentEntity = (CarriageContraptionEntity)((Object)hoveredEntity.get());
        if (currentEntity != null) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, currentEntity) != null) {
                return;
            }
            hoveredEntity = new WeakReference<Object>(null);
        }
        class_238 aabb = new class_238(origin, target);
        List intersectingContraptions = mc.field_1687.method_18467(CarriageContraptionEntity.class, aabb);
        for (CarriageContraptionEntity contraptionEntity : intersectingContraptions) {
            if (ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity) == null) continue;
            hoveredEntity = new WeakReference<CarriageContraptionEntity>(contraptionEntity);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean carriageWrenched(class_243 vec3, CarriageContraptionEntity entity) {
        Train train = TrainRelocator.getTrainFromEntity(entity);
        if (train == null) {
            return false;
        }
        relocatingOrigin = vec3;
        relocatingTrain = train.id;
        relocatingEntityId = entity.method_5628();
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean addToTooltip(List<class_2561> tooltip, boolean shiftKeyDown) {
        Train train = TrainRelocator.getTrainFromEntity((CarriageContraptionEntity)((Object)hoveredEntity.get()));
        if (train != null && train.derailed) {
            TooltipHelper.addHint(tooltip, "hint.derailed_train", new Object[0]);
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static Train getRelocating(class_1936 level) {
        return relocatingTrain == null ? null : Create.RAILWAYS.sided((class_1936)level).trains.get(relocatingTrain);
    }

    private static Train getTrainFromEntity(CarriageContraptionEntity carriageContraptionEntity) {
        if (carriageContraptionEntity == null) {
            return null;
        }
        Carriage carriage = carriageContraptionEntity.getCarriage();
        if (carriage == null) {
            return null;
        }
        return carriage.train;
    }
}

