/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.simibubi.create.content.decoration.slidingDoor.DoorControl;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class StationEditPacket
extends BlockEntityConfigurationPacket<StationBlockEntity> {
    boolean dropSchedule;
    boolean assemblyMode;
    Boolean tryAssemble;
    DoorControl doorControl;
    String name;

    public static StationEditPacket dropSchedule(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.dropSchedule = true;
        return packet;
    }

    public static StationEditPacket tryAssemble(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = true;
        return packet;
    }

    public static StationEditPacket tryDisassemble(class_2338 pos) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.tryAssemble = false;
        return packet;
    }

    public static StationEditPacket configure(class_2338 pos, boolean assemble, String name, DoorControl doorControl) {
        StationEditPacket packet = new StationEditPacket(pos);
        packet.assemblyMode = assemble;
        packet.tryAssemble = null;
        packet.name = name;
        packet.doorControl = doorControl;
        return packet;
    }

    public StationEditPacket(class_2540 buffer) {
        super(buffer);
    }

    public StationEditPacket(class_2338 pos) {
        super(pos);
    }

    @Override
    protected void writeSettings(class_2540 buffer) {
        buffer.writeBoolean(this.dropSchedule);
        if (this.dropSchedule) {
            return;
        }
        buffer.writeBoolean(this.doorControl != null);
        if (this.doorControl != null) {
            buffer.method_10804(this.doorControl.ordinal());
        }
        buffer.writeBoolean(this.tryAssemble != null);
        if (this.tryAssemble != null) {
            buffer.writeBoolean(this.tryAssemble.booleanValue());
            return;
        }
        buffer.writeBoolean(this.assemblyMode);
        buffer.method_10814(this.name);
    }

    @Override
    protected void readSettings(class_2540 buffer) {
        if (buffer.readBoolean()) {
            this.dropSchedule = true;
            return;
        }
        if (buffer.readBoolean()) {
            this.doorControl = DoorControl.values()[class_3532.method_15340((int)buffer.method_10816(), (int)0, (int)DoorControl.values().length)];
        }
        this.name = "";
        if (buffer.readBoolean()) {
            this.tryAssemble = buffer.readBoolean();
            return;
        }
        this.assemblyMode = buffer.readBoolean();
        this.name = buffer.method_10800(256);
    }

    @Override
    protected void applySettings(class_3222 player, StationBlockEntity be) {
        class_1937 level = be.method_10997();
        class_2338 blockPos = be.method_11016();
        class_2680 blockState = level.method_8320(blockPos);
        if (this.dropSchedule) {
            be.dropSchedule(player);
            return;
        }
        if (this.doorControl != null) {
            be.doorControls.set(this.doorControl);
        }
        if (!this.name.isBlank()) {
            be.updateName(this.name);
        }
        if (!(blockState.method_26204() instanceof StationBlock)) {
            return;
        }
        Boolean isAssemblyMode = (Boolean)blockState.method_11654((class_2769)StationBlock.ASSEMBLING);
        boolean assemblyComplete = false;
        if (this.tryAssemble != null) {
            if (!isAssemblyMode.booleanValue()) {
                return;
            }
            if (this.tryAssemble.booleanValue()) {
                be.assemble(player.method_5667());
                assemblyComplete = be.getStation() != null && be.getStation().getPresentTrain() != null;
            } else if (be.tryDisassembleTrain(player) && be.tryEnterAssemblyMode()) {
                be.refreshAssemblyInfo();
            }
            if (!assemblyComplete) {
                return;
            }
        }
        if (this.assemblyMode) {
            be.enterAssemblyMode(player);
        } else {
            be.exitAssemblyMode();
        }
    }

    @Override
    protected void applySettings(StationBlockEntity be) {
    }
}

