/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.IceBreakable;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Repairable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import com.talhanation.smallships.world.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrakkarEntity
extends ContainerShip
implements Bannerable,
Sailable,
Shieldable,
Repairable,
Leashable,
Paddleable,
IceBreakable {
    public static final String ID = "drakkar";
    private static final int ORIGINAL_CONTAINER_SIZE = (Integer)SmallShipsConfig.Common.shipContainerDrakkarContainerSize.get();
    private static final List<Shieldable.ShieldPosition> SHIELD_POSITIONS = new ArrayList<Shieldable.ShieldPosition>();

    public DrakkarEntity(class_1299<? extends class_1690> entityType, class_1937 level) {
        super(entityType, level, ORIGINAL_CONTAINER_SIZE);
    }

    private DrakkarEntity(class_1937 level, double d, double e, double f) {
        this(ModEntityTypes.DRAKKAR, level);
        this.method_5814(d, e, f);
        this.field_6014 = d;
        this.field_6036 = e;
        this.field_5969 = f;
    }

    public static DrakkarEntity summon(class_1937 level, double d, double e, double f) {
        return new DrakkarEntity(level, d, e, f);
    }

    @Override
    public class_2487 createDefaultAttributes() {
        Attributes attributes = new Attributes();
        attributes.maxHealth = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxHealth.get()).floatValue();
        attributes.maxSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxSpeed.get()).floatValue();
        attributes.maxReverseSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxReverseSpeed.get()).floatValue();
        attributes.maxRotationSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxRotationSpeed.get()).floatValue();
        attributes.acceleration = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarAcceleration.get()).floatValue();
        attributes.rotationAcceleration = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarRotationAcceleration.get()).floatValue();
        class_2487 tag = new class_2487();
        attributes.addSaveData(tag);
        return tag;
    }

    @Override
    public int method_42281() {
        return 11;
    }

    @Override
    @NotNull
    public class_1792 method_7557() {
        if (!((Boolean)SmallShipsConfig.Common.shipGeneralDoItemDrop.get()).booleanValue()) {
            return class_1799.field_8037.method_7909();
        }
        return ModItems.DRAKKAR_ITEMS.get(this.method_47885());
    }

    @Override
    public Ship.BiomeModifierType getBiomeModifierType() {
        return (Ship.BiomeModifierType)((Object)SmallShipsConfig.Common.shipModifierDrakkarBiome.get());
    }

    public void method_24201(@NotNull class_1297 entity) {
        if (this.method_5626(entity)) {
            float d = this.method_42280();
            float e = 0.0f;
            float f = this.getSinglePassengerZOffset();
            float g = (float)((this.method_31481() ? (double)0.01f : this.method_5621()) + entity.method_5678());
            if (this.method_5685().size() > 1) {
                int i = this.method_5685().indexOf(entity);
                switch (i) {
                    case 0: {
                        d = -4.0f;
                        f = 0.0f;
                        break;
                    }
                    case 1: {
                        d = -2.5f;
                        f = 0.75f;
                        break;
                    }
                    case 2: {
                        d = -2.5f;
                        f = -0.75f;
                        break;
                    }
                    case 3: {
                        d = -1.5f;
                        f = -0.75f;
                        break;
                    }
                    case 4: {
                        d = -1.5f;
                        f = 0.75f;
                        break;
                    }
                    case 5: {
                        d = -0.5f;
                        f = -0.75f;
                        break;
                    }
                    case 6: {
                        d = -0.5f;
                        f = 0.75f;
                        break;
                    }
                    case 7: {
                        d = 0.5f;
                        f = -0.75f;
                        break;
                    }
                    case 8: {
                        d = 0.5f;
                        f = 0.75f;
                        break;
                    }
                    case 9: {
                        d = 1.5f;
                        f = 0.5f;
                        break;
                    }
                    case 10: {
                        d = 1.5f;
                        f = -0.5f;
                        break;
                    }
                    default: {
                        d = 2.0f;
                        e = 0.75f;
                        f = 0.0f;
                    }
                }
            }
            class_243 vec3 = new class_243((double)(d += 2.0f), (double)e, (double)f).method_1024(-this.method_36454() * ((float)Math.PI / 180) - 1.5707964f);
            entity.method_5814(this.method_23317() + vec3.field_1352, this.method_23318() + (double)g, this.method_23321() + vec3.field_1350);
            entity.method_36456(entity.method_36454() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            entity.method_5847(entity.method_5791() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            this.method_7546(entity);
            if (entity instanceof class_1429 && this.method_5685().size() == this.method_42281()) {
                int j = entity.method_5628() % 2 == 0 ? 90 : 270;
                entity.method_5636(((class_1429)entity).field_6283 + (float)j);
                entity.method_5847(entity.method_5791() + (float)j);
            }
        }
    }

    protected float method_42280() {
        return -1.7f;
    }

    protected float getSinglePassengerZOffset() {
        return 0.7f;
    }

    @Override
    public Bannerable.BannerPosition getBannerPosition() {
        return new Bannerable.BannerPosition(0.0f, 270.0f, 4.3, -0.15, 0.05);
    }

    @Override
    public void waterSplash() {
        class_243 vector3d = this.method_5828(0.0f);
        float f0 = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * 1.2f;
        float f1 = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))) * 1.2f;
        float f2 = 4.0f - this.field_5974.method_43057() * 0.7f;
        float f2_ = -2.3f - this.field_5974.method_43057() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.method_5770().method_8406((class_2394)class_2398.field_11222, this.method_23317() - vector3d.field_1352 * (double)f2 + (double)f0, this.method_23318() - vector3d.field_1351 + 0.5, this.method_23321() - vector3d.field_1350 * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11222, this.method_23317() - vector3d.field_1352 * (double)f2 - (double)f0, this.method_23318() - vector3d.field_1351 + 0.5, this.method_23321() - vector3d.field_1350 * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11222, this.method_23317() - vector3d.field_1352 * (double)f2 + (double)f0, this.method_23318() - vector3d.field_1351 + 0.5, this.method_23321() - vector3d.field_1350 * (double)f2 + (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11222, this.method_23317() - vector3d.field_1352 * (double)f2 - (double)f0, this.method_23318() - vector3d.field_1351 + 0.5, this.method_23321() - vector3d.field_1350 * (double)f2 - (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2 + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2 - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2 + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2 - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2_ + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2_ - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2_ + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11202, this.method_23317() - vector3d.field_1352 * (double)f2_ - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11247, this.method_23317() - vector3d.field_1352 * (double)f2_ + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11247, this.method_23317() - vector3d.field_1352 * (double)f2_ - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11247, this.method_23317() - vector3d.field_1352 * (double)f2_ + (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.method_5770().method_8406((class_2394)class_2398.field_11247, this.method_23317() - vector3d.field_1352 * (double)f2_ - (double)f0, this.method_23318() - vector3d.field_1351 + 0.8, this.method_23321() - vector3d.field_1350 * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Shieldable.ShieldPosition getShieldPosition(int index) {
        return SHIELD_POSITIONS.get(index);
    }

    @Override
    public byte getMaxShieldsPerSide() {
        return 5;
    }

    @Override
    @Nullable
    public class_243 applyLeashOffset() {
        return new class_243(0.0, (double)this.method_5751(), (double)(this.method_17681() * 0.1f));
    }

    static {
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(2.1, 0.8, -1.0, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(2.1, 0.8, 1.0, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(0.9, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(0.9, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-0.3, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-0.3, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-1.5, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-1.5, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-3.0, 0.8, -1.0, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-3.0, 0.8, 1.0, false));
    }
}

