/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.computercraft.peripheral.ability;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.config.IOperationAbilityConfig;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralCheck;
import site.siredvin.peripheralium.api.peripheral.IPeripheralFunction;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwner;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0002>?B!\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ#\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0019\u001a\u00020\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010\u001f\u001a\u00020\u00182\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u0015\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0019\u0010%\u001a\u00020\u00132\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016\u00a2\u0006\u0004\b%\u0010&Js\u00102\u001a\u00020\u001c\"\u0004\b\u0000\u0010'2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\u0006\u0010(\u001a\u00028\u00002\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010)2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0+2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010-2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u000200\u0018\u00010/\u00a2\u0006\u0004\b2\u00103J\u0019\u00104\u001a\u00020\u000f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0016\u00a2\u0006\u0004\b4\u00105J#\u00107\u001a\u00020\u000f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u00106\u001a\u00020\u0018H\u0004\u00a2\u0006\u0004\b7\u00108R$\u00109\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010;R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010<R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010=\u00a8\u0006@"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IOwnerAbility;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "owner", "", "reduceRate", "Lsite/siredvin/peripheralium/api/config/IOperationAbilityConfig;", "config", "<init>", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;DLsite/siredvin/peripheralium/api/config/IOperationAbilityConfig;)V", "", "", "", "data", "", "collectConfiguration", "(Ljava/util/Map;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "operation", "", "getCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)I", "name", "Ldan200/computercraft/api/lua/MethodResult;", "getCooldownLua", "(Ljava/lang/String;)Ldan200/computercraft/api/lua/MethodResult;", "getCurrentCooldown", "", "getOperationsLua", "()Ljava/util/List;", "hashCode", "()I", "isOnCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)Z", "T", "context", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralCheck;", "check", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;", "method", "Ljava/util/function/Consumer;", "successCallback", "Ljava/util/function/BiConsumer;", "Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$FailReason;", "failCallback", "performOperation", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;Ljava/lang/Object;Lsite/siredvin/peripheralium/api/peripheral/IPeripheralCheck;Lsite/siredvin/peripheralium/api/peripheral/IPeripheralFunction;Ljava/util/function/Consumer;Ljava/util/function/BiConsumer;)Ldan200/computercraft/api/lua/MethodResult;", "registerOperation", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;)V", "cooldown", "setCooldown", "(Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;I)V", "allowedOperations", "Ljava/util/Map;", "Lsite/siredvin/peripheralium/api/config/IOperationAbilityConfig;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOwner;", "D", "Companion", "FailReason", "peripheralium-fabric-1.20.1"})
public final class OperationAbility
implements IOwnerAbility,
IPeripheralPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPeripheralOwner owner;
    private final double reduceRate;
    @NotNull
    private final IOperationAbilityConfig config;
    @NotNull
    private final Map<String, IPeripheralOperation<?>> allowedOperations;
    @NotNull
    public static final String COOLDOWNS_TAG = "cooldowns";

    public OperationAbility(@NotNull IPeripheralOwner owner, double reduceRate, @NotNull IOperationAbilityConfig config) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.owner = owner;
        this.reduceRate = reduceRate;
        this.config = config;
        this.allowedOperations = new HashMap();
    }

    public /* synthetic */ OperationAbility(IPeripheralOwner iPeripheralOwner, double d, IOperationAbilityConfig iOperationAbilityConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        this(iPeripheralOwner, d, iOperationAbilityConfig);
    }

    protected final void setCooldown(@NotNull IPeripheralOperation<?> operation, int cooldown) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        if (cooldown > 0) {
            class_2487 dataStorage = this.owner.getDataStorage();
            if (!dataStorage.method_10545(COOLDOWNS_TAG)) {
                dataStorage.method_10566(COOLDOWNS_TAG, (class_2520)new class_2487());
            }
            dataStorage.method_10562(COOLDOWNS_TAG).method_10544(operation.settingsName(), Timestamp.valueOf(LocalDateTime.now().plus(cooldown, ChronoUnit.MILLIS)).getTime());
        }
    }

    protected final int getCooldown(@NotNull IPeripheralOperation<?> operation) {
        String operationName;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        class_2487 dataStorage = this.owner.getDataStorage();
        if (!dataStorage.method_10545(COOLDOWNS_TAG)) {
            return 0;
        }
        class_2487 cooldowns = dataStorage.method_10562(COOLDOWNS_TAG);
        if (!cooldowns.method_10545(operationName = operation.settingsName())) {
            return 0;
        }
        long currentTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return (int)Math.max(0L, cooldowns.method_10537(operationName) - currentTime);
    }

    public final void registerOperation(@NotNull IPeripheralOperation<?> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.allowedOperations.put(operation.settingsName(), operation);
    }

    @NotNull
    public final <T> MethodResult performOperation(@NotNull IPeripheralOperation<T> operation, T context, @Nullable IPeripheralCheck<T> check, @NotNull IPeripheralFunction<T, MethodResult> method, @Nullable Consumer<T> successCallback, @Nullable BiConsumer<MethodResult, FailReason> failCallback) throws LuaException {
        MethodResult checkResult;
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        Intrinsics.checkNotNullParameter(method, (String)"method");
        if (this.isOnCooldown(operation)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = null;
            String string = "%s is on cooldown";
            Object[] objectArray2 = new Object[]{operation.settingsName()};
            Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(format, *args)");
            MethodResult result = MethodResult.of((Object[])objectArray);
            BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
            if (biConsumer != null) {
                biConsumer.accept(result, FailReason.COOLDOWN);
            }
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return result;
        }
        if (check != null && (checkResult = check.check(context)) != null) {
            BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
            if (biConsumer != null) {
                biConsumer.accept(checkResult, FailReason.CHECK_FAILED);
            }
            return checkResult;
        }
        int cost = operation.getCost(context);
        int cooldown = (int)((double)operation.getCooldown(context) * this.reduceRate);
        FuelAbility fuelAbility = null;
        if (cost != 0) {
            fuelAbility = (FuelAbility)this.owner.getAbility(PeripheralOwnerAbility.Companion.getFUEL());
            if (fuelAbility == null) {
                Object[] objectArray = new Object[]{null, "This peripheral has no fuel at all"};
                MethodResult result = MethodResult.of((Object[])objectArray);
                BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
                if (biConsumer != null) {
                    biConsumer.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                return result;
            }
            if (!fuelAbility.consumeFuel(cost, false)) {
                Object[] objectArray = new Object[]{null, "Not enough fuel for operation"};
                MethodResult result = MethodResult.of((Object[])objectArray);
                BiConsumer<MethodResult, FailReason> biConsumer = failCallback;
                if (biConsumer != null) {
                    biConsumer.accept(result, FailReason.NOT_ENOUGH_FUEL);
                }
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
                return result;
            }
            cooldown = fuelAbility.reduceCooldownAccordingToConsumptionRate(cooldown);
        }
        MethodResult result = method.apply(context);
        Consumer<T> consumer = successCallback;
        if (consumer != null) {
            consumer.accept(context);
        }
        if (cooldown > this.config.getCooldownTresholdLevel()) {
            this.setCooldown(operation, cooldown);
        }
        return result;
    }

    public final int getCurrentCooldown(@NotNull IPeripheralOperation<?> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.getCooldown(operation);
    }

    public final boolean isOnCooldown(@NotNull IPeripheralOperation<?> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return this.getCurrentCooldown(operation) > 0;
    }

    @Override
    public void collectConfiguration(@NotNull Map<String, Object> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        for (IPeripheralOperation<?> operation : this.allowedOperations.values()) {
            data.put(operation.settingsName(), operation.computerDescription());
        }
    }

    @LuaFunction(value={"getCooldown"}, mainThread=true)
    @NotNull
    public final MethodResult getCooldownLua(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IPeripheralOperation<?> iPeripheralOperation = this.allowedOperations.get(name);
        if (iPeripheralOperation == null) {
            Object[] objectArray = new Object[]{null, "Cannot find this operation"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find this operation\")");
            return methodResult;
        }
        IPeripheralOperation<?> op = iPeripheralOperation;
        MethodResult methodResult = MethodResult.of((Object)this.getCurrentCooldown(op));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getCurrentCooldown(op))");
        return methodResult;
    }

    @LuaFunction(value={"getOperations"})
    @NotNull
    public final List<String> getOperationsLua() {
        return CollectionsKt.toList((Iterable)this.allowedOperations.keySet());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OperationAbility)) {
            return false;
        }
        if (!(this.reduceRate == ((OperationAbility)other).reduceRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.config, (Object)((OperationAbility)other).config)) {
            return false;
        }
        return Intrinsics.areEqual(this.allowedOperations, ((OperationAbility)other).allowedOperations);
    }

    public int hashCode() {
        int result = Double.hashCode(this.reduceRate);
        result = 31 * result + this.config.hashCode();
        result = 31 * result + ((Object)this.allowedOperations).hashCode();
        return result;
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    @Override
    @Nullable
    public String getAdditionalType() {
        return IPeripheralPlugin.DefaultImpls.getAdditionalType(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$Companion;", "", "<init>", "()V", "", "COOLDOWNS_TAG", "Ljava/lang/String;", "peripheralium-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lsite/siredvin/peripheralium/computercraft/peripheral/ability/OperationAbility$FailReason;", "", "<init>", "(Ljava/lang/String;I)V", "COOLDOWN", "NOT_ENOUGH_FUEL", "CHECK_FAILED", "peripheralium-fabric-1.20.1"})
    public static final class FailReason
    extends Enum<FailReason> {
        public static final /* enum */ FailReason COOLDOWN = new FailReason();
        public static final /* enum */ FailReason NOT_ENOUGH_FUEL = new FailReason();
        public static final /* enum */ FailReason CHECK_FAILED = new FailReason();
        private static final /* synthetic */ FailReason[] $VALUES;

        public static FailReason[] values() {
            return (FailReason[])$VALUES.clone();
        }

        public static FailReason valueOf(String value) {
            return Enum.valueOf(FailReason.class, value);
        }

        static {
            $VALUES = failReasonArray = new FailReason[]{FailReason.COOLDOWN, FailReason.NOT_ENOUGH_FUEL, FailReason.CHECK_FAILED};
        }
    }
}

