/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.storages.fluid.FluidStorageExtractor;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ;\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J;\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001f\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b\u0012\u0002\b\u00030\u001c0\u001bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010\u0003\u001a\u00020\u00028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020(8$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006,"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "Lnet/minecraft/class_1937;", "level", "", "fluidStorageTransferLimit", "<init>", "(Lnet/minecraft/class_1937;I)V", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "fluid", "", "", "", "fluidInformation", "(Lsite/siredvin/peripheralium/storages/fluid/FluidStack;)Ljava/util/Map;", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "Ljava/util/Optional;", "", "limit", "fluidName", "", "pullFluid", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/util/Optional;Ljava/util/Optional;)D", "toName", "pushFluid", "", "", "tanks", "()Ljava/util/List;", "getAdditionalType", "()Ljava/lang/String;", "additionalType", "I", "getFluidStorageTransferLimit", "()I", "Lnet/minecraft/class_1937;", "getLevel", "()Lnet/minecraft/class_1937;", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "storage", "peripheralium-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAbstractFluidStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,80:1\n32#2,2:81\n*S KotlinDebug\n*F\n+ 1 AbstractFluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin\n*L\n32#1:81,2\n*E\n"})
public abstract class AbstractFluidStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    private final class_1937 level;
    private final int fluidStorageTransferLimit;

    public AbstractFluidStoragePlugin(@NotNull class_1937 level, int fluidStorageTransferLimit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.level = level;
        this.fluidStorageTransferLimit = fluidStorageTransferLimit;
    }

    @NotNull
    protected final class_1937 getLevel() {
        return this.level;
    }

    protected final int getFluidStorageTransferLimit() {
        return this.fluidStorageTransferLimit;
    }

    @Override
    @NotNull
    public String getAdditionalType() {
        return "fluid_storage";
    }

    @NotNull
    protected Map<String, Object> fluidInformation(@NotNull FluidStack fluid) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return LuaRepresentation.INSTANCE.forFluidStack(fluid);
    }

    @NotNull
    protected abstract FluidStorage getStorage();

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> tanks() {
        List data = new ArrayList();
        Iterator<FluidStack> $this$forEach$iv = this.getStorage().getFluids();
        boolean $i$f$forEach = false;
        Iterator<FluidStack> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            FluidStack element$iv;
            FluidStack it = element$iv = iterator.next();
            boolean bl = false;
            data.add(this.fluidInformation(it));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    public final double pushFluid(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidSink fluidSink = FluidStorageExtractor.INSTANCE.extractFluidSinkFromUnknown(this.level, location.getTarget());
        if (fluidSink == null) {
            throw new LuaException("Target '" + toName + "' is not an fluid inventory");
        }
        FluidSink toStorage = fluidSink;
        if (fluidName.isEmpty()) {
            predicate = AbstractFluidStoragePlugin::pushFluid$lambda$1;
        } else {
            class_3611 fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new class_2960(fluidName.get()));
            if (fluid.method_15780(class_3612.field_15906)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> AbstractFluidStoragePlugin.pushFluid$lambda$2(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.getStorage().moveTo(toStorage, realLimit, predicate2);
    }

    @LuaFunction(mainThread=true)
    public final double pullFluid(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidStorage fluidStorage = FluidStorageExtractor.INSTANCE.extractFluidStorageFromUnknown(this.level, location.getTarget());
        if (fluidStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        FluidStorage fromStorage = fluidStorage;
        if (fluidName.isEmpty()) {
            predicate = AbstractFluidStoragePlugin::pullFluid$lambda$3;
        } else {
            class_3611 fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new class_2960(fluidName.get()));
            if (fluid.method_15780(class_3612.field_15906)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> AbstractFluidStoragePlugin.pullFluid$lambda$4(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.getStorage().moveFrom(fromStorage, realLimit, predicate2);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    private static final boolean pushFluid$lambda$1(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushFluid$lambda$2(class_3611 $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().method_15780($fluid);
    }

    private static final boolean pullFluid$lambda$3(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullFluid$lambda$4(class_3611 $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().method_15780($fluid);
    }
}

