/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.storages.item.SlottedItemSink;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.util.representation.RepresentationMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\fJ%\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\u00060\u0006H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u0010\u001a\u0018\u0012\u0004\u0012\u00020\u0004\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u00030\u00060\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000fJC\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019JC\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u000f\u0010\u001c\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001dR\u0014\u0010!\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010%\u001a\u00020\"8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010)\u001a\u00020&8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractInventoryPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "<init>", "()V", "", "slot", "", "", "getItemDetail", "(I)Ljava/util/Map;", "getItemDetailImpl", "getItemLimit", "(I)I", "getItemLimitImpl", "list", "()Ljava/util/Map;", "listImpl", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "fromSlot", "Ljava/util/Optional;", "limit", "toSlot", "pullItems", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;ILjava/util/Optional;Ljava/util/Optional;)I", "toName", "pushItems", "size", "()I", "sizeImpl", "getAdditionalType", "()Ljava/lang/String;", "additionalType", "Lnet/minecraft/class_1937;", "getLevel", "()Lnet/minecraft/class_1937;", "level", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "storage", "peripheralium-fabric-1.20.1"})
public abstract class AbstractInventoryPlugin
implements IPeripheralPlugin {
    @NotNull
    public abstract SlottedItemStorage getStorage();

    @NotNull
    public abstract class_1937 getLevel();

    @Override
    @NotNull
    public String getAdditionalType() {
        return "inventory";
    }

    public int sizeImpl() {
        return this.getStorage().getSize();
    }

    @NotNull
    public Map<Integer, Map<String, ?>> listImpl() {
        Map result = new HashMap();
        int size = this.getStorage().getSize();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = this.getStorage().getItem(i);
            if (stack.method_7960()) continue;
            result.put(i + 1, LuaRepresentation.INSTANCE.forItemStack(stack, RepresentationMode.BASE));
        }
        return result;
    }

    @Nullable
    public Map<String, ?> getItemDetailImpl(int slot) {
        class_1799 stack = this.getStorage().getItem(slot);
        return stack.method_7960() ? null : LuaRepresentation.forItemStack$default(LuaRepresentation.INSTANCE, stack, null, 2, null);
    }

    public int getItemLimitImpl(int slot) {
        return this.getStorage().getItem(slot).method_7914();
    }

    @LuaFunction(mainThread=true)
    public final int size() {
        return this.sizeImpl();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<Integer, Map<String, ?>> list() {
        return this.listImpl();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getItemDetail(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getStorage().getSize(), "slot");
        return this.getItemDetailImpl(slot - 1);
    }

    @LuaFunction(mainThread=true)
    public final int getItemLimit(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getStorage().getSize(), "slot");
        return this.getItemLimitImpl(slot - 1);
    }

    @LuaFunction(mainThread=true)
    public final int pushItems(@NotNull IComputerAccess computer, @NotNull String toName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        ItemSink toStorage = itemSink;
        Integer n = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"limit.orElse(Int.MAX_VALUE)");
        int actualLimit = ((Number)n).intValue();
        ValidationHelpersKt.assertBetween(fromSlot, 1, this.getStorage().getSize(), "fromtSlot");
        if (toSlot.isPresent()) {
            if (!(toStorage instanceof SlottedItemSink)) {
                throw new LuaException("Target '" + toName + "' is not slotted storage, so you can't provide slot");
            }
            Integer n2 = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n2).intValue(), 1, ((SlottedItemSink)toStorage).getSize(), "toSlot");
        }
        return actualLimit <= 0 ? 0 : this.getStorage().moveTo(toStorage, actualLimit, fromSlot - 1, ((Number)toSlot.orElse(0)).intValue() - 1, ItemStorageUtils.INSTANCE.getALWAYS());
    }

    @LuaFunction(mainThread=true)
    public final int pullItems(@NotNull IComputerAccess computer, @NotNull String fromName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        ItemSink fromStorage = itemSink;
        if (!(fromStorage instanceof SlottedItemStorage)) {
            throw new LuaException("Source '" + fromName + "' is not slotted storage");
        }
        Integer actualLimit = limit.orElse(Integer.MAX_VALUE);
        ValidationHelpersKt.assertBetween(fromSlot, 1, ((SlottedItemStorage)fromStorage).getSize(), "fromSlot");
        if (toSlot.isPresent()) {
            Integer n = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n).intValue(), 1, this.getStorage().getSize(), "toSlot");
        }
        Intrinsics.checkNotNullExpressionValue((Object)actualLimit, (String)"actualLimit");
        return actualLimit <= 0 ? 0 : this.getStorage().moveFrom((ItemStorage)fromStorage, actualLimit, ((Number)toSlot.orElse(0)).intValue() - 1, fromSlot - 1, ItemStorageUtils.INSTANCE.getALWAYS());
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }
}

