/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.extra.plugins.PeripheralPluginUtils;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\t0\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\bJ7\u0010\u0013\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J7\u0010\u0016\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00118&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010$\u001a\u00020!8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "<init>", "()V", "", "", "", "items", "()Ljava/util/List;", "", "itemsImpl", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "computer", "fromName", "", "itemQuery", "Ljava/util/Optional;", "", "limit", "pullItem", "(Ldan200/computercraft/api/peripheral/IComputerAccess;Ljava/lang/String;Ljava/lang/Object;Ljava/util/Optional;)I", "toName", "pushItem", "getAdditionalType", "()Ljava/lang/String;", "additionalType", "getItemStorageTransferLimit", "()I", "itemStorageTransferLimit", "Lnet/minecraft/class_1937;", "getLevel", "()Lnet/minecraft/class_1937;", "level", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "storage", "peripheralium-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAbstractItemStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,66:1\n32#2,2:67\n*S KotlinDebug\n*F\n+ 1 AbstractItemStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractItemStoragePlugin\n*L\n27#1:67,2\n*E\n"})
public abstract class AbstractItemStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    public abstract ItemStorage getStorage();

    @NotNull
    public abstract class_1937 getLevel();

    public abstract int getItemStorageTransferLimit();

    @Override
    @NotNull
    public String getAdditionalType() {
        return "item_storage";
    }

    @NotNull
    public List<Map<String, ?>> itemsImpl() {
        List result = new ArrayList();
        Iterator<class_1799> $this$forEach$iv = this.getStorage().getItems();
        boolean $i$f$forEach = false;
        Iterator<class_1799> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            class_1799 element$iv;
            class_1799 it = element$iv = iterator.next();
            boolean bl = false;
            if (it.method_7960()) continue;
            result.add(LuaRepresentation.forItemStack$default(LuaRepresentation.INSTANCE, it, null, 2, null));
        }
        return result;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> items() {
        return this.itemsImpl();
    }

    @LuaFunction(mainThread=true)
    public final int pushItem(@NotNull IComputerAccess computer, @NotNull String toName, @Nullable Object itemQuery, @NotNull Optional<Integer> limit) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an targetable storage");
        }
        ItemSink toStorage = itemSink;
        Predicate<class_1799> predicate = PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery);
        int n = this.getItemStorageTransferLimit();
        Integer n2 = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"limit.orElse(Int.MAX_VALUE)");
        int n3 = ((Number)n2).intValue();
        int realLimit = Math.min(n, n3);
        return ItemStorage.DefaultImpls.moveTo$default(this.getStorage(), toStorage, realLimit, 0, predicate, 4, null);
    }

    @LuaFunction(mainThread=true)
    public final int pullItem(@NotNull IComputerAccess computer, @NotNull String fromName, @Nullable Object itemQuery, @NotNull Optional<Integer> limit) {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorageFromUnknown(this.getLevel(), location.getTarget());
        if (itemStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an storage");
        }
        ItemStorage fromStorage = itemStorage;
        Predicate<class_1799> predicate = PeripheralPluginUtils.INSTANCE.itemQueryToPredicate(itemQuery);
        int n = this.getItemStorageTransferLimit();
        Integer n2 = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"limit.orElse(Int.MAX_VALUE)");
        int n3 = ((Number)n2).intValue();
        int realLimit = Math.min(n, n3);
        return ItemSink.DefaultImpls.moveFrom$default(this.getStorage(), fromStorage, realLimit, 0, predicate, 4, null);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }
}

