/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.loader;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ%\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u00048\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lsite/siredvin/peripheralium/loader/BaseIntegrationLoader;", "", "", "corePackage", "Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "(Ljava/lang/String;Lorg/apache/logging/log4j/Logger;)V", "modID", "", "isModPresent", "(Ljava/lang/String;)Z", "path", "Ljava/util/Optional;", "maybeLoadIntegration", "(Ljava/lang/String;)Ljava/util/Optional;", "(Ljava/lang/String;Ljava/lang/String;)Ljava/util/Optional;", "Ljava/lang/String;", "getCorePackage", "()Ljava/lang/String;", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "peripheralium-fabric-1.20.1"})
public abstract class BaseIntegrationLoader {
    @NotNull
    private final String corePackage;
    @NotNull
    private final Logger logger;

    public BaseIntegrationLoader(@NotNull String corePackage, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)corePackage, (String)"corePackage");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.corePackage = corePackage;
        this.logger = logger;
    }

    @NotNull
    protected final String getCorePackage() {
        return this.corePackage;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    public abstract boolean isModPresent(@NotNull String var1);

    @NotNull
    public final Optional<Object> maybeLoadIntegration(@NotNull String modID, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)modID, (String)"modID");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean modPresent = this.isModPresent(modID);
        if (modPresent) {
            this.logger.info("Loading integration for " + modID);
            return this.maybeLoadIntegration(modID + "." + path);
        }
        this.logger.info("Mod " + modID + " is not present, skip loading integration");
        Optional<Object> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
        return optional;
    }

    public static /* synthetic */ Optional maybeLoadIntegration$default(BaseIntegrationLoader baseIntegrationLoader, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maybeLoadIntegration");
        }
        if ((n & 2) != 0) {
            string2 = "Integration";
        }
        return baseIntegrationLoader.maybeLoadIntegration(string, string2);
    }

    private final Optional<Object> maybeLoadIntegration(String path) {
        Optional<Object> optional;
        try {
            Class<?> clazz = Class.forName(this.corePackage + ".integrations." + path);
            Optional<?> optional2 = Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n            val clazz \u2026.newInstance())\n        }");
            optional = optional2;
        }
        catch (InstantiationException ignored) {
            this.logger.info("Exception when loading integration " + ignored);
            Optional optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, (String)"{\n            logger.inf\u2026ptional.empty()\n        }");
            optional = optional3;
        }
        catch (IllegalAccessException ignored) {
            this.logger.info("Exception when loading integration " + ignored);
            Optional optional4 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional4, (String)"{\n            logger.inf\u2026ptional.empty()\n        }");
            optional = optional4;
        }
        catch (ClassNotFoundException ignored) {
            this.logger.info("Exception when loading integration " + ignored);
            Optional optional5 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional5, (String)"{\n            logger.inf\u2026ptional.empty()\n        }");
            optional = optional5;
        }
        catch (Exception e) {
            e.printStackTrace();
            Optional<Object> optional6 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional6, (String)"{\n            e.printSta\u2026ptional.empty()\n        }");
            optional = optional6;
        }
        return optional;
    }
}

