/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ-\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\u000fJ1\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J?\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J5\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lsite/siredvin/peripheralium/storages/ContainerUtils;", "", "<init>", "()V", "Lnet/minecraft/class_1263;", "container", "", "slot", "limit", "Ljava/util/function/Predicate;", "Lnet/minecraft/class_1799;", "predicate", "extract", "(Lnet/minecraft/class_1263;IILjava/util/function/Predicate;)Lnet/minecraft/class_1799;", "previousStack", "(Lnet/minecraft/class_1263;IILnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "stack", "startSlot", "endSlot", "storeItem", "(Lnet/minecraft/class_1263;Lnet/minecraft/class_1799;II)Lnet/minecraft/class_1799;", "takeItems", "(Lnet/minecraft/class_1263;IIILjava/util/function/Predicate;)Lnet/minecraft/class_1799;", "output", "Lnet/minecraft/class_2338;", "outputPos", "Lnet/minecraft/class_1937;", "level", "", "toInventoryOrToWorld", "(Lnet/minecraft/class_1799;Lnet/minecraft/class_1263;ILnet/minecraft/class_2338;Lnet/minecraft/class_1937;)V", "peripheralium-fabric-1.20.1"})
public final class ContainerUtils {
    @NotNull
    public static final ContainerUtils INSTANCE = new ContainerUtils();

    private ContainerUtils() {
    }

    @NotNull
    public final class_1799 extract(@NotNull class_1263 container, int slot, int limit, @NotNull class_1799 previousStack) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)previousStack, (String)"previousStack");
        return this.extract(container, slot, limit, arg_0 -> ContainerUtils.extract$lambda$0(previousStack, arg_0));
    }

    @NotNull
    public final class_1799 extract(@NotNull class_1263 container, int slot, int limit, @NotNull Predicate<class_1799> predicate) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        class_1799 existingStack = container.method_5438(slot);
        if (existingStack.method_7960() || !predicate.test(existingStack)) {
            class_1799 class_17992 = class_1799.field_8037;
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
            return class_17992;
        }
        class_1799 class_17993 = container.method_5434(slot, limit);
        Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"container.removeItem(slot, limit)");
        return class_17993;
    }

    @NotNull
    public final class_1799 takeItems(@NotNull class_1263 container, int limit, int startSlot, int endSlot, @NotNull Predicate<class_1799> predicate) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Predicate<Object> slidingPredicate = predicate;
        int realEndSlot = endSlot == -1 ? container.method_5439() - 1 : endSlot;
        int slidingLimit = limit;
        Ref.ObjectRef stack = new Ref.ObjectRef();
        stack.element = class_1799.field_8037;
        int currentSlot = startSlot;
        if (currentSlot <= realEndSlot) {
            while (true) {
                if (limit <= 0) {
                    Object object = stack.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
                    return (class_1799)object;
                }
                class_1799 extractedStack = this.extract(container, currentSlot, slidingLimit, predicate);
                if (!extractedStack.method_7960()) {
                    slidingLimit -= extractedStack.method_7947();
                    if (((class_1799)stack.element).method_7960()) {
                        stack.element = extractedStack;
                        slidingLimit = Math.min(slidingLimit, ((class_1799)stack.element).method_7914());
                        Intrinsics.checkNotNullExpressionValue(slidingPredicate.and(arg_0 -> ContainerUtils.takeItems$lambda$1((Function1)new Function1<class_1799, Boolean>((Ref.ObjectRef<class_1799>)stack){
                            final /* synthetic */ Ref.ObjectRef<class_1799> $stack;
                            {
                                this.$stack = $stack;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(class_1799 it) {
                                Object object = this.$stack.element;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
                                class_1799 class_17992 = (class_1799)object;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                return ItemStorageUtils.INSTANCE.canStack(class_17992, it);
                            }
                        }, arg_0)), (String)"stack = ItemStack.EMPTY\n\u2026ck, it)\n                }");
                    } else {
                        ((class_1799)stack.element).method_7933(extractedStack.method_7947());
                    }
                }
                if (currentSlot == realEndSlot) break;
                ++currentSlot;
            }
        }
        container.method_5431();
        Object object = stack.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
        return (class_1799)object;
    }

    public static /* synthetic */ class_1799 takeItems$default(ContainerUtils containerUtils, class_1263 class_12632, int n, int n2, int n3, Predicate predicate, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return containerUtils.takeItems(class_12632, n, n2, n3, predicate);
    }

    @NotNull
    public final class_1799 storeItem(@NotNull class_1263 container, @NotNull class_1799 stack, int startSlot, int endSlot) {
        int realEndSlot;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int maxStackSize = Math.min(stack.method_7914(), container.method_5444());
        int n = realEndSlot = endSlot == -1 ? container.method_5439() - 1 : endSlot;
        if (maxStackSize <= 0) {
            return stack;
        }
        class_1799 slidingStack = stack;
        int currentSlot = startSlot;
        if (currentSlot <= realEndSlot) {
            while (true) {
                class_1799 slotStack;
                if ((slotStack = container.method_5438(currentSlot)).method_7960()) {
                    if (container.method_5437(currentSlot, slidingStack)) {
                        if (slidingStack.method_7947() <= maxStackSize) {
                            container.method_5447(currentSlot, slidingStack);
                            class_1799 class_17992 = class_1799.field_8037;
                            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
                            return class_17992;
                        }
                        container.method_5447(currentSlot, slidingStack.method_7971(maxStackSize));
                    }
                } else {
                    int slotMaxStackSize = Math.min(slotStack.method_7914(), maxStackSize);
                    if (slotStack.method_7947() < slotMaxStackSize) {
                        Intrinsics.checkNotNullExpressionValue((Object)slotStack, (String)"slotStack");
                        if (ItemStorageUtils.INSTANCE.canMerge(slotStack, slidingStack, slotMaxStackSize) && (slidingStack = ItemStorageUtils.inplaceMerge$default(ItemStorageUtils.INSTANCE, slotStack, slidingStack, 0, 4, null)).method_7960()) {
                            container.method_5431();
                            class_1799 class_17993 = class_1799.field_8037;
                            Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"EMPTY");
                            return class_17993;
                        }
                    }
                }
                if (currentSlot == realEndSlot) break;
                ++currentSlot;
            }
        }
        container.method_5431();
        return slidingStack;
    }

    public static /* synthetic */ class_1799 storeItem$default(ContainerUtils containerUtils, class_1263 class_12632, class_1799 class_17992, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        return containerUtils.storeItem(class_12632, class_17992, n, n2);
    }

    public final void toInventoryOrToWorld(@NotNull class_1799 output, @NotNull class_1263 container, int startSlot, @NotNull class_2338 outputPos, @NotNull class_1937 level) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)outputPos, (String)"outputPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        class_1799 rest = this.storeItem(container, output, startSlot, container.method_5439() - 1);
        if (!rest.method_7960() && startSlot > 0) {
            rest = this.storeItem(container, output, 0, startSlot - 1);
        }
        if (!rest.method_7960()) {
            class_1264.method_5449((class_1937)level, (double)outputPos.method_10263(), (double)outputPos.method_10264(), (double)outputPos.method_10260(), (class_1799)rest);
        }
    }

    private static final boolean extract$lambda$0(class_1799 $previousStack, class_1799 it) {
        Intrinsics.checkNotNullParameter((Object)$previousStack, (String)"$previousStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $previousStack.method_7960() || ItemStorageUtils.INSTANCE.canStack($previousStack, it);
    }

    private static final boolean takeItems$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

