/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages;

import dan200.computercraft.api.lua.LuaException;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.fluid.ExtensionsKt;
import site.siredvin.peripheralium.storages.fluid.FabricFluidStorage;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.storages.item.FabricSlottedStorageWrapper;
import site.siredvin.peripheralium.storages.item.FabricStorageWrapper;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.SlottedItemSink;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J9\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJA\u0010\u001d\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0004\b\u001d\u0010\"J9\u0010%\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0004\b%\u0010&JA\u0010%\u001a\u00020 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00152\u0006\u0010\u0017\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010(\u001a\u00020 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0004\b%\u0010)J!\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\u0004\b+\u0010,J!\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u00a2\u0006\u0004\b-\u0010,R\u0014\u0010/\u001a\u00020.8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Lsite/siredvin/peripheralium/storages/FabricStorageUtils;", "", "<init>", "()V", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_2586;", "blockEntity", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "extractFluidStorage", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2586;)Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "Lnet/minecraft/class_1799;", "stack", "extractFluidStorageFromItem", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1799;)Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "extractStorage", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_2586;)Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "from", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "to", "", "limit", "Ljava/util/function/Predicate;", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "takePredicate", "moveFromTargetable", "(Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;JLjava/util/function/Predicate;)J", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "", "fromSlot", "(Lsite/siredvin/peripheralium/storages/item/ItemStorage;Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;IILjava/util/function/Predicate;)I", "storage", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "moveToTargetable", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;Lsite/siredvin/peripheralium/storages/fluid/FluidSink;JLjava/util/function/Predicate;)J", "Lsite/siredvin/peripheralium/storages/item/ItemSink;", "toSlot", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;Lsite/siredvin/peripheralium/storages/item/ItemSink;IILjava/util/function/Predicate;)I", "predicate", "wrapFluid", "(Ljava/util/function/Predicate;)Ljava/util/function/Predicate;", "wrapItem", "", "MOVABLE_TYPE", "Ljava/lang/String;", "PredicateWrapper", "peripheralium-fabric-1.20.1"})
public final class FabricStorageUtils {
    @NotNull
    public static final FabricStorageUtils INSTANCE = new FabricStorageUtils();
    @NotNull
    public static final String MOVABLE_TYPE = "fabricTransaction";

    private FabricStorageUtils() {
    }

    @NotNull
    public final Predicate<ItemVariant> wrapItem(@NotNull Predicate<class_1799> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return new PredicateWrapper(predicate);
    }

    @NotNull
    public final Predicate<FluidVariant> wrapFluid(@NotNull Predicate<FluidStack> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return arg_0 -> FabricStorageUtils.wrapFluid$lambda$0(predicate, arg_0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int moveToTargetable(@NotNull Storage<ItemVariant> storage2, @NotNull ItemSink to, int limit, int toSlot, @NotNull Predicate<class_1799> takePredicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter(storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)to.getMovableType(), (Object)MOVABLE_TYPE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Transaction transaction = Transaction.openOuter();
        AutoCloseable autoCloseable = (AutoCloseable)transaction;
        Throwable throwable = null;
        try {
            class_1799 class_17992;
            Transaction it = (Transaction)autoCloseable;
            boolean bl3 = false;
            ItemVariant itemVariant = (ItemVariant)StorageUtil.findExtractableResource(storage2, INSTANCE.wrapItem(takePredicate), (TransactionContext)((TransactionContext)it));
            if (itemVariant == null) {
                int n = 0;
                return n;
            }
            Intrinsics.checkNotNullExpressionValue((Object)itemVariant, (String)"StorageUtil.findExtracta\u2026              ?: return 0");
            ItemVariant resource = itemVariant;
            int extractedAmount = (int)storage2.extract((Object)resource, (long)limit, (TransactionContext)it);
            if (extractedAmount == 0) {
                int n = 0;
                return n;
            }
            class_1799 insertionStack = resource.toStack(extractedAmount);
            if (toSlot < 0) {
                Intrinsics.checkNotNullExpressionValue((Object)insertionStack, (String)"insertionStack");
                class_17992 = to.storeItem(insertionStack);
            } else {
                SlottedItemSink slottedItemSink = (SlottedItemSink)to;
                Intrinsics.checkNotNullExpressionValue((Object)insertionStack, (String)"insertionStack");
                class_17992 = slottedItemSink.storeItem(insertionStack, toSlot, toSlot);
            }
            class_1799 remainder = class_17992;
            int insertedCount = extractedAmount - remainder.method_7947();
            if (!remainder.method_7960()) {
                storage2.insert((Object)resource, (long)remainder.method_7947(), (TransactionContext)it);
            }
            it.commit();
            int n = insertedCount;
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int moveFromTargetable(@NotNull ItemStorage from, @NotNull Storage<ItemVariant> to, int limit, int fromSlot, @NotNull Predicate<class_1799> takePredicate) {
        class_1799 insertionStack;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)from.getMovableType(), (Object)MOVABLE_TYPE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (fromSlot < 0) {
            v1 = from.takeItems(takePredicate, limit);
        } else {
            if (!(from instanceof SlottedItemStorage)) {
                throw new LuaException("From doesn't support slotting");
            }
            v1 = insertionStack = ((SlottedItemStorage)from).takeItems(limit, fromSlot, fromSlot, takePredicate);
        }
        if (insertionStack.method_7960()) {
            return 0;
        }
        Transaction transaction = Transaction.openOuter();
        AutoCloseable autoCloseable = (AutoCloseable)transaction;
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl3 = false;
            long insertedAmount = to.insert((Object)ItemVariant.of((class_1799)insertionStack), (long)insertionStack.method_7947(), (TransactionContext)it);
            long remainCount = (long)insertionStack.method_7947() - insertedAmount;
            if (remainCount > 0L) {
                if (fromSlot > -1) {
                    SlottedItemStorage slottedItemStorage = (SlottedItemStorage)from;
                    class_1799 class_17992 = insertionStack.method_46651((int)remainCount);
                    Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"insertionStack.copyWithCount(remainCount.toInt())");
                    slottedItemStorage.storeItem(class_17992, fromSlot, fromSlot);
                } else {
                    class_1799 class_17993 = insertionStack.method_46651((int)remainCount);
                    Intrinsics.checkNotNullExpressionValue((Object)class_17993, (String)"insertionStack.copyWithCount(remainCount.toInt())");
                    from.storeItem(class_17993);
                }
            }
            it.commit();
            int n = (int)insertedAmount;
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long moveToTargetable(@NotNull Storage<FluidVariant> storage2, @NotNull FluidSink to, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter(storage2, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)to.getMovableType(), (Object)MOVABLE_TYPE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        long platformLimit = limit * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
        Transaction transaction = Transaction.openOuter();
        AutoCloseable autoCloseable = (AutoCloseable)transaction;
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl3 = false;
            FluidVariant fluidVariant = (FluidVariant)StorageUtil.findExtractableResource(storage2, INSTANCE.wrapFluid(takePredicate), (TransactionContext)((TransactionContext)it));
            if (fluidVariant == null) {
                long l = 0L;
                return l;
            }
            Intrinsics.checkNotNullExpressionValue((Object)fluidVariant, (String)"StorageUtil.findExtracta\u2026              ?: return 0");
            FluidVariant resource = fluidVariant;
            long extractedAmount = storage2.extract((Object)resource, platformLimit, (TransactionContext)it);
            if (extractedAmount == 0L) {
                long l = 0L;
                return l;
            }
            FluidStack insertionStack = ExtensionsKt.toVanilla(resource, extractedAmount);
            FluidStack remainder = to.storeFluid(insertionStack);
            long insertedCount = extractedAmount - remainder.getPlatformAmount();
            if (!remainder.isEmpty()) {
                storage2.insert((Object)resource, remainder.getPlatformAmount(), (TransactionContext)it);
            }
            it.commit();
            long l = insertedCount / (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long moveFromTargetable(@NotNull FluidStorage from, @NotNull Storage<FluidVariant> to, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)from.getMovableType(), (Object)MOVABLE_TYPE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        long platformLimit = limit * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
        FluidStack insertionStack = from.takeFluid(takePredicate, platformLimit);
        if (insertionStack.isEmpty()) {
            return 0L;
        }
        Transaction transaction = Transaction.openOuter();
        AutoCloseable autoCloseable = (AutoCloseable)transaction;
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl3 = false;
            long insertedAmount = to.insert((Object)ExtensionsKt.toVariant(insertionStack), insertionStack.getPlatformAmount(), (TransactionContext)it);
            long remainCount = insertionStack.getPlatformAmount() - insertedAmount;
            if (remainCount > 0L) {
                from.storeFluid(insertionStack.copyWithCount(remainCount / (long)PeripheraliumPlatform.Companion.getFluidCompactDivider()));
            }
            it.commit();
            long l = insertedAmount / (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Nullable
    public final ItemStorage extractStorage(@NotNull class_1937 level, @NotNull class_2338 pos, @Nullable class_2586 blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Storage storage2 = (Storage)net.fabricmc.fabric.api.transfer.v1.item.ItemStorage.SIDED.find(level, pos, null);
        if (storage2 == null) {
            return null;
        }
        Storage itemStorage = storage2;
        return itemStorage instanceof SlottedStorage ? (ItemStorage)new FabricSlottedStorageWrapper((SlottedStorage<ItemVariant>)((SlottedStorage)itemStorage)) : (ItemStorage)new FabricStorageWrapper((Storage<ItemVariant>)itemStorage);
    }

    @Nullable
    public final FluidStorage extractFluidStorage(@NotNull class_1937 level, @NotNull class_2338 pos, @Nullable class_2586 blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Storage storage2 = (Storage)net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage.SIDED.find(level, pos, null);
        if (storage2 == null) {
            return null;
        }
        Storage fluidStorage = storage2;
        return new FabricFluidStorage((Storage<FluidVariant>)fluidStorage);
    }

    @Nullable
    public final FluidStorage extractFluidStorageFromItem(@NotNull class_1937 level, @NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Storage storage2 = (Storage)net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack));
        if (storage2 == null) {
            return null;
        }
        Storage fluidStorage = storage2;
        return new FabricFluidStorage((Storage<FluidVariant>)fluidStorage);
    }

    private static final boolean wrapFluid$lambda$0(Predicate $predicate, FluidVariant it) {
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return $predicate.test(ExtensionsKt.toVanilla$default(it, 0L, 1, null));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000b\u00a8\u0006\f"}, d2={"Lsite/siredvin/peripheralium/storages/FabricStorageUtils$PredicateWrapper;", "Ljava/util/function/Predicate;", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "Lnet/minecraft/class_1799;", "predicate", "<init>", "(Ljava/util/function/Predicate;)V", "p0", "", "test", "(Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;)Z", "Ljava/util/function/Predicate;", "peripheralium-fabric-1.20.1"})
    private static final class PredicateWrapper
    implements Predicate<ItemVariant> {
        @NotNull
        private final Predicate<class_1799> predicate;

        public PredicateWrapper(@NotNull Predicate<class_1799> predicate) {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            this.predicate = predicate;
        }

        @Override
        public boolean test(@NotNull ItemVariant p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.predicate.test(p0.toStack());
        }
    }
}

