/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.fluid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.FabricStorageUtils;
import site.siredvin.peripheralium.storages.fluid.ExtensionsKt;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J-\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001d\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010#\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FabricFluidStorage;", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/fluid/FluidVariant;", "storage", "<init>", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;)V", "", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "getFluids", "()Ljava/util/Iterator;", "from", "", "limit", "Ljava/util/function/Predicate;", "takePredicate", "moveFrom", "(Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;JLjava/util/function/Predicate;)J", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "to", "moveTo", "(Lsite/siredvin/peripheralium/storages/fluid/FluidSink;JLjava/util/function/Predicate;)J", "", "setChanged", "()V", "stack", "storeFluid", "(Lsite/siredvin/peripheralium/storages/fluid/FluidStack;)Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "predicate", "takeFluid", "(Ljava/util/function/Predicate;J)Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "", "getMovableType", "()Ljava/lang/String;", "movableType", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "peripheralium-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nFabricFluidStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FabricFluidStorage.kt\nsite/siredvin/peripheralium/storages/fluid/FabricFluidStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1549#2:81\n1620#2,3:82\n*S KotlinDebug\n*F\n+ 1 FabricFluidStorage.kt\nsite/siredvin/peripheralium/storages/fluid/FabricFluidStorage\n*L\n17#1:81\n17#1:82,3\n*E\n"})
public class FabricFluidStorage
implements FluidStorage {
    @NotNull
    private final Storage<FluidVariant> storage;

    public FabricFluidStorage(@NotNull Storage<FluidVariant> storage2) {
        Intrinsics.checkNotNullParameter(storage2, (String)"storage");
        this.storage = storage2;
    }

    @Override
    @NotNull
    public String getMovableType() {
        return "fabricTransaction";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<FluidStack> getFluids() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.storage;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageView storageView = (StorageView)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(ExtensionsKt.toVanilla((StorageView<FluidVariant>)it));
        }
        return ((List)destination$iv$iv).iterator();
    }

    @Override
    public long moveTo(@NotNull FluidSink to, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        if (Intrinsics.areEqual((Object)to.getMovableType(), (Object)"fabricTransaction")) {
            return to.moveFrom(this, limit, takePredicate);
        }
        if (to.getMovableType() == null) {
            return FabricStorageUtils.INSTANCE.moveToTargetable(this.storage, to, limit, takePredicate);
        }
        throw new IllegalStateException("Cannot mix movable type, this should be impossible here");
    }

    @Override
    public long moveFrom(@NotNull FluidStorage from, long limit, @NotNull Predicate<FluidStack> takePredicate) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        if (Intrinsics.areEqual((Object)from.getMovableType(), (Object)"fabricTransaction")) {
            if (!(from instanceof FabricFluidStorage)) {
                throw new IllegalStateException("For fabricTransfer please use FabricFluidStorage");
            }
            return StorageUtil.move(((FabricFluidStorage)from).storage, this.storage, arg_0 -> FabricFluidStorage.moveFrom$lambda$1(takePredicate, arg_0), (long)(limit * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider()), null) / (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
        }
        if (from.getMovableType() == null) {
            return FabricStorageUtils.INSTANCE.moveFromTargetable(from, this.storage, limit, takePredicate);
        }
        throw new IllegalStateException("Cannot mix movable type, this should be impossible here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FluidStack takeFluid(@NotNull Predicate<FluidStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        long platformLimit = limit * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
        if (!this.storage.supportsExtraction()) {
            return FluidStack.Companion.getEMPTY();
        }
        ResourceAmount extractableTarget = StorageUtil.findExtractableContent(this.storage, arg_0 -> FabricFluidStorage.takeFluid$lambda$2(predicate, arg_0), null);
        if (extractableTarget == null || extractableTarget.amount() == 0L) {
            return FluidStack.Companion.getEMPTY();
        }
        long realLimit = Math.min(extractableTarget.amount(), platformLimit);
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long extracted = this.storage.extract(extractableTarget.resource(), realLimit, (TransactionContext)it);
            it.commit();
            Object object = extractableTarget.resource();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extractableTarget.resource");
            FluidStack fluidStack = ExtensionsKt.toVanilla((FluidVariant)object, extracted);
            return fluidStack;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FluidStack storeFluid(@NotNull FluidStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!this.storage.supportsInsertion()) {
            return stack;
        }
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            long inserted = this.storage.insert((Object)ExtensionsKt.toVariant(stack), stack.getPlatformAmount(), (TransactionContext)it);
            if (inserted == 0L) {
                it.abort();
                FluidStack fluidStack = stack;
                return fluidStack;
            }
            it.commit();
            FluidStack fluidStack = stack.copyWithCount((stack.getPlatformAmount() - inserted) / (long)PeripheraliumPlatform.Companion.getFluidCompactDivider());
            return fluidStack;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setChanged() {
    }

    private static final boolean moveFrom$lambda$1(Predicate $takePredicate, FluidVariant it) {
        Intrinsics.checkNotNullParameter((Object)$takePredicate, (String)"$takePredicate");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return $takePredicate.test(ExtensionsKt.toVanilla(it, 1L));
    }

    private static final boolean takeFluid$lambda$2(Predicate $predicate, FluidVariant it) {
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return $predicate.test(ExtensionsKt.toVanilla$default(it, 0L, 1, null));
    }
}

