/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.item;

import dan200.computercraft.api.lua.LuaException;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.FabricStorageUtils;
import site.siredvin.peripheralium.storages.item.FabricSlottedStorageWrapper;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.SlidingIterator;
import site.siredvin.peripheralium.storages.item.SlottedItemSink;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J5\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ%\u0010\u001f\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010$\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lsite/siredvin/peripheralium/storages/item/FabricStorageWrapper;", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "Lnet/fabricmc/fabric/api/transfer/v1/item/ItemVariant;", "storage", "<init>", "(Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;)V", "", "Lnet/minecraft/class_1799;", "getItems", "()Ljava/util/Iterator;", "from", "", "limit", "fromSlot", "Ljava/util/function/Predicate;", "takePredicate", "moveFrom", "(Lsite/siredvin/peripheralium/storages/item/ItemStorage;IILjava/util/function/Predicate;)I", "Lsite/siredvin/peripheralium/storages/item/ItemSink;", "to", "toSlot", "moveTo", "(Lsite/siredvin/peripheralium/storages/item/ItemSink;IILjava/util/function/Predicate;)I", "", "setChanged", "()V", "stack", "storeItem", "(Lnet/minecraft/class_1799;)Lnet/minecraft/class_1799;", "predicate", "takeItems", "(Ljava/util/function/Predicate;I)Lnet/minecraft/class_1799;", "", "getMovableType", "()Ljava/lang/String;", "movableType", "Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "getStorage$peripheralium_fabric_1_20_1", "()Lnet/fabricmc/fabric/api/transfer/v1/storage/Storage;", "peripheralium-fabric-1.20.1"})
public class FabricStorageWrapper
implements ItemStorage {
    @NotNull
    private final Storage<ItemVariant> storage;

    public FabricStorageWrapper(@NotNull Storage<ItemVariant> storage2) {
        Intrinsics.checkNotNullParameter(storage2, (String)"storage");
        this.storage = storage2;
    }

    @NotNull
    public final Storage<ItemVariant> getStorage$peripheralium_fabric_1_20_1() {
        return this.storage;
    }

    @Override
    public int moveTo(@NotNull ItemSink to, int limit, int toSlot, @NotNull Predicate<class_1799> takePredicate) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        if (to instanceof FabricSlottedStorageWrapper) {
            return ((FabricSlottedStorageWrapper)to).moveFrom(this, limit, toSlot, -1, takePredicate);
        }
        if (to instanceof FabricStorageWrapper) {
            if (toSlot > -1) {
                throw new LuaException("To slot doesn't support slotting");
            }
            return to.moveFrom(this, limit, -1, takePredicate);
        }
        if (toSlot < -1 && !(to instanceof SlottedItemSink)) {
            throw new LuaException("To slot doesn't support slotting");
        }
        return FabricStorageUtils.INSTANCE.moveToTargetable(this.storage, to, limit, toSlot, takePredicate);
    }

    @Override
    public int moveFrom(@NotNull ItemStorage from, int limit, int fromSlot, @NotNull Predicate<class_1799> takePredicate) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        if (from instanceof FabricSlottedStorageWrapper) {
            if (fromSlot > 0) {
                SingleSlotStorage<ItemVariant> slotStorage = ((FabricSlottedStorageWrapper)from).getSingleSlot(fromSlot);
                return (int)StorageUtil.move((Storage)((Storage)slotStorage), this.storage, FabricStorageUtils.INSTANCE.wrapItem(takePredicate), (long)limit, null);
            }
            return (int)StorageUtil.move((Storage)((Storage)((FabricSlottedStorageWrapper)from).getStorage$peripheralium_fabric_1_20_1()), this.storage, FabricStorageUtils.INSTANCE.wrapItem(takePredicate), (long)limit, null);
        }
        if (from instanceof FabricStorageWrapper) {
            if (fromSlot > -1) {
                throw new LuaException("From storage doesn't support slotting");
            }
            return (int)StorageUtil.move(((FabricStorageWrapper)from).storage, this.storage, FabricStorageUtils.INSTANCE.wrapItem(takePredicate), (long)limit, null);
        }
        return FabricStorageUtils.INSTANCE.moveFromTargetable(from, this.storage, limit, fromSlot, takePredicate);
    }

    @Override
    @NotNull
    public String getMovableType() {
        return "fabricTransaction";
    }

    @Override
    @NotNull
    public Iterator<class_1799> getItems() {
        Iterator iterator = this.storage.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"storage.iterator()");
        return new SlidingIterator(iterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public class_1799 takeItems(@NotNull Predicate<class_1799> predicate, int limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            ResourceAmount resourceAmount;
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            if (StorageUtil.findExtractableContent(this.storage, FabricStorageUtils.INSTANCE.wrapItem(predicate), (TransactionContext)((TransactionContext)it)) == null) {
                class_1799 class_17992 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
                class_1799 class_17993 = class_17992;
                return class_17993;
            }
            ResourceAmount resourceAmount2 = resourceAmount;
            Intrinsics.checkNotNullExpressionValue((Object)resourceAmount2, (String)"StorageUtil.findExtracta\u2026?: return ItemStack.EMPTY");
            ResourceAmount extractionTarget = resourceAmount2;
            if (extractionTarget.amount() == 0L) {
                class_1799 class_17994 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17994, (String)"EMPTY");
                class_1799 class_17995 = class_17994;
                return class_17995;
            }
            long amount = this.storage.extract(extractionTarget.resource(), (long)limit, (TransactionContext)it);
            if (amount < 1L) {
                it.abort();
                class_1799 class_17996 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17996, (String)"EMPTY");
                class_1799 class_17997 = class_17996;
                return class_17997;
            }
            it.commit();
            class_1799 class_17998 = ((ItemVariant)extractionTarget.resource()).toStack((int)amount);
            Intrinsics.checkNotNullExpressionValue((Object)class_17998, (String)"extractionTarget.resource.toStack(amount.toInt())");
            class_1799 class_17999 = class_17998;
            return class_17999;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public class_1799 storeItem(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        AutoCloseable autoCloseable = (AutoCloseable)Transaction.openOuter();
        Throwable throwable = null;
        try {
            Transaction it = (Transaction)autoCloseable;
            boolean bl = false;
            int amount = (int)this.storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)it);
            stack.method_7934(amount);
            it.commit();
            if (stack.method_7960()) {
                class_1799 class_17992 = class_1799.field_8037;
                Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"EMPTY");
                class_1799 class_17993 = class_17992;
                return class_17993;
            }
            class_1799 class_17994 = stack;
            return class_17994;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void setChanged() {
    }
}

