/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.world;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J)\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015JE\u0010\u0019\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u00172\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0019\u0010\u001aR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lsite/siredvin/peripheralium/util/world/FakePlayerProviderTurtle;", "", "<init>", "()V", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "turtle", "Lcom/mojang/authlib/GameProfile;", "profile", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "getPlayer", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Lcom/mojang/authlib/GameProfile;)Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_2350;", "overwrittenDirection", "", "skipInventory", "", "load", "(Lnet/minecraft/class_3222;Ldan200/computercraft/api/turtle/ITurtleAccess;Lnet/minecraft/class_2350;Z)V", "unload", "(Lnet/minecraft/class_3222;Ldan200/computercraft/api/turtle/ITurtleAccess;Z)V", "T", "Ljava/util/function/Function;", "function", "withPlayer", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ljava/util/function/Function;Lnet/minecraft/class_2350;Z)Ljava/lang/Object;", "Ljava/util/WeakHashMap;", "registeredPlayers", "Ljava/util/WeakHashMap;", "peripheralium-fabric-1.20.1"})
public final class FakePlayerProviderTurtle {
    @NotNull
    public static final FakePlayerProviderTurtle INSTANCE = new FakePlayerProviderTurtle();
    @NotNull
    private static final WeakHashMap<ITurtleAccess, FakePlayerProxy> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    private final FakePlayerProxy getPlayer(ITurtleAccess turtle, GameProfile profile) {
        FakePlayerProxy fake = registeredPlayers.get(turtle);
        if (fake == null) {
            class_1937 class_19372 = turtle.getLevel();
            Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            fake = new FakePlayerProxy(PeripheraliumPlatform.Companion.createFakePlayer((class_3218)class_19372, profile), 0, 2, null);
            ((Map)registeredPlayers).put(turtle, fake);
        }
        return fake;
    }

    private final void load(class_3222 player, ITurtleAccess turtle, class_2350 overwrittenDirection, boolean skipInventory) {
        float pitch;
        class_2350 class_23502 = overwrittenDirection;
        if (class_23502 == null) {
            class_23502 = turtle.getDirection();
        }
        class_2350 direction = class_23502;
        class_1937 class_19372 = turtle.getLevel();
        Intrinsics.checkNotNull((Object)class_19372, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        player.method_51468((class_3218)class_19372);
        class_2338 position = turtle.getPosition();
        float f = direction == class_2350.field_11036 ? -90.0f : (pitch = direction == class_2350.field_11033 ? 90.0f : 0.0f);
        float yaw = direction == class_2350.field_11035 ? 0.0f : (direction == class_2350.field_11039 ? 90.0f : (direction == class_2350.field_11043 ? 180.0f : -90.0f));
        class_2382 sideVec = direction.method_10163();
        class_2350.class_2351 a = direction.method_10166();
        class_2350.class_2352 ad = direction.method_10171();
        double x = a == class_2350.class_2351.field_11048 && ad == class_2350.class_2352.field_11060 ? -0.5 : 0.5 + (double)sideVec.method_10263() / 1.9;
        double y = 0.5 + (double)sideVec.method_10264() / 1.9;
        double z = a == class_2350.class_2351.field_11051 && ad == class_2350.class_2352.field_11060 ? -0.5 : 0.5 + (double)sideVec.method_10260() / 1.9;
        player.method_5808((double)position.method_10263() + x, (double)position.method_10264() + y, (double)position.method_10260() + z, yaw, pitch);
        if (!skipInventory) {
            int i;
            class_1661 class_16612 = player.method_31548();
            Intrinsics.checkNotNullExpressionValue((Object)class_16612, (String)"player.inventory");
            class_1661 playerInventory = class_16612;
            playerInventory.field_7545 = 0;
            class_1263 turtleInventory = turtle.getInventory();
            int size = turtleInventory.method_5439();
            int largerSize = playerInventory.method_5439();
            playerInventory.field_7545 = turtle.getSelectedSlot();
            for (i = 0; i < size; ++i) {
                playerInventory.method_5447(i, turtleInventory.method_5438(i));
            }
            for (i = size; i < largerSize; ++i) {
                playerInventory.method_5447(i, class_1799.field_8037);
            }
            class_1799 class_17992 = player.method_5998(class_1268.field_5808);
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
            class_1799 activeStack = class_17992;
            if (!activeStack.method_7960()) {
                player.method_6127().method_26854(activeStack.method_7926(class_1304.field_6173));
            }
        }
    }

    static /* synthetic */ void load$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, class_3222 class_32222, ITurtleAccess iTurtleAccess, class_2350 class_23502, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            class_23502 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        fakePlayerProviderTurtle.load(class_32222, iTurtleAccess, class_23502, bl);
    }

    private final void unload(class_3222 player, ITurtleAccess turtle, boolean skipInventory) {
        class_1661 class_16612 = player.method_31548();
        Intrinsics.checkNotNullExpressionValue((Object)class_16612, (String)"player.inventory");
        class_1661 playerInventory = class_16612;
        playerInventory.field_7545 = 0;
        class_1799 class_17992 = player.method_5998(class_1268.field_5808);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
        class_1799 activeStack = class_17992;
        if (!activeStack.method_7960()) {
            player.method_6127().method_26847(activeStack.method_7926(class_1304.field_6173));
        }
        if (!skipInventory) {
            int i;
            class_1263 turtleInventory = turtle.getInventory();
            int size = turtleInventory.method_5439();
            int largerSize = playerInventory.method_5439();
            playerInventory.field_7545 = turtle.getSelectedSlot();
            for (i = 0; i < size; ++i) {
                turtleInventory.method_5447(i, playerInventory.method_5438(i));
                playerInventory.method_5447(i, class_1799.field_8037);
            }
            for (i = size; i < largerSize; ++i) {
                class_1799 remaining = playerInventory.method_5438(i);
                if (!remaining.method_7960()) {
                    Intrinsics.checkNotNullExpressionValue((Object)remaining, (String)"remaining");
                    Intrinsics.checkNotNullExpressionValue((Object)turtleInventory, (String)"turtleInventory");
                    class_2338 class_23382 = turtle.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"turtle.position");
                    class_1937 class_19372 = turtle.getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"turtle.level");
                    ContainerUtils.INSTANCE.toInventoryOrToWorld(remaining, turtleInventory, 0, class_23382, class_19372);
                }
                playerInventory.method_5447(i, class_1799.field_8037);
            }
        }
    }

    static /* synthetic */ void unload$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, class_3222 class_32222, ITurtleAccess iTurtleAccess, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fakePlayerProviderTurtle.unload(class_32222, iTurtleAccess, bl);
    }

    public final <T> T withPlayer(@NotNull ITurtleAccess turtle, @NotNull Function<FakePlayerProxy, T> function, @Nullable class_2350 overwrittenDirection, boolean skipInventory) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        GameProfile gameProfile = turtle.getOwningPlayer();
        if (gameProfile == null) {
            gameProfile = FakePlayerProxy.Companion.getDUMMY_PROFILE();
        }
        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"turtle.owningPlayer ?: F\u2026PlayerProxy.DUMMY_PROFILE");
        FakePlayerProxy player = this.getPlayer(turtle, gameProfile);
        this.load(player.getFakePlayer(), turtle, overwrittenDirection, skipInventory);
        T result = function.apply(player);
        this.unload(player.getFakePlayer(), turtle, skipInventory);
        return result;
    }

    public static /* synthetic */ Object withPlayer$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, ITurtleAccess iTurtleAccess, Function function, class_2350 class_23502, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            class_23502 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return fakePlayerProviderTurtle.withPlayer(iTurtleAccess, function, class_23502, bl);
    }
}

