/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math;

import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec4d;
import dev.felnull.otyacraftengine.include.dev.felnull.fnjl.math.FNVec4f;
import java.util.Objects;

public class FNVec4i {
    private int x;
    private int y;
    private int z;
    private int w;

    public FNVec4i() {
    }

    public FNVec4i(int x, int y, int z, int w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public FNVec4i copy() {
        return new FNVec4i(this.x, this.y, this.z, this.w);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getW() {
        return this.w;
    }

    public double distance(FNVec4i vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0) + Math.pow(this.w - vec.getW(), 2.0));
    }

    public FNVec4i add(FNVec4i vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        this.w += vec.getW();
        return this;
    }

    public FNVec4i sub(FNVec4i vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        this.w -= vec.getW();
        return this;
    }

    public String toString() {
        return "FNVec4i{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec4i fnVec4i = (FNVec4i)o;
        return this.x == fnVec4i.x && this.y == fnVec4i.y && this.z == fnVec4i.z && this.w == fnVec4i.w;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public FNVec4f convertFloat() {
        return new FNVec4f(this.x, this.y, this.z, this.w);
    }

    public FNVec4d convertDouble() {
        return new FNVec4d(this.x, this.y, this.z, this.w);
    }
}

