/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.chest;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestBlock;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestContainer;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventoriesData;
import me.duquee.createutilities.blocks.voidtypes.chest.VoidChestInventory;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5712;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidChestTileEntity
extends SmartBlockEntity
implements class_3908,
SidedStorageBlockEntity {
    VoidLinkBehaviour link;
    VoidChestInventory inventory;
    private int openCount;
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);

    public VoidChestTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void createLink() {
        Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots = VoidLinkSlot.makeSlots(index -> new VoidLinkSlot((int)index, state -> (class_2350)state.method_11654((class_2769)VoidChestBlock.field_11177), VecHelper.voxelSpace((double)5.5, (double)7.5, (double)0.999f)));
        this.link = new VoidLinkBehaviour(this, slots);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    private boolean hasPersistentData() {
        return this.field_11863 != null && !this.field_11863.field_9236;
    }

    private static VoidChestInventoriesData getPersistentData() {
        return CreateUtilities.VOID_CHEST_INVENTORIES_DATA;
    }

    public VoidChestInventory getItemStorage(class_2350 side) {
        return this.hasPersistentData() ? VoidChestTileEntity.getPersistentData().computeStorageIfAbsent(this.link.getNetworkKey()) : this.inventory;
    }

    public VoidChestInventory getItemStorage() {
        return this.getItemStorage(null);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        if (clientPacket) {
            this.inventory = new VoidChestInventory();
            this.inventory.deserializeNBT(tag.method_10562("Inventory"));
            this.openCount = tag.method_10550("OpenCount");
        }
        super.read(tag, clientPacket);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        if (this.hasPersistentData()) {
            tag.method_10566("Inventory", (class_2520)this.getItemStorage().serializeNBT());
        } else {
            tag.method_10566("Inventory", (class_2520)this.inventory.serializeNBT());
        }
        if (clientPacket) {
            tag.method_10569("OpenCount", this.openCount);
        }
        super.write(tag, clientPacket);
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.createutilities.void_chest");
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        return VoidChestContainer.create(id, inventory, this);
    }

    public void tick() {
        this.lid.chase(this.openCount > 0 ? 1.0 : 0.0, (double)0.1f, LerpedFloat.Chaser.LINEAR);
        this.lid.tickChaser();
    }

    public boolean isClosed() {
        return this.lid.settled() && this.lid.getChaseTarget() == 0.0f;
    }

    public void startOpen(class_1657 player) {
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        this.sendData();
        if (this.openCount == 1) {
            this.field_11863.method_33596((class_1297)player, class_5712.field_28176, this.field_11867);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14982, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
        }
    }

    public void stopOpen(class_1657 player) {
        --this.openCount;
        this.sendData();
        if (this.openCount <= 0) {
            this.field_11863.method_33596((class_1297)player, class_5712.field_28177, this.field_11867);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_14823, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
        }
    }
}

