/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.element;

import fuzs.betteranimationscollection.client.element.ModelElement;
import fuzs.betteranimationscollection.client.element.SoundDetectionElement;
import fuzs.betteranimationscollection.client.model.BuckaChickenModel;
import fuzs.puzzleslib.api.config.v3.ValueCallback;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1428;
import net.minecraft.class_3417;
import net.minecraft.class_558;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraftforge.common.ForgeConfigSpec;

public class BuckaChickenElement
extends SoundDetectionElement {
    public static boolean slimBill;
    public static boolean moveHead;
    public static boolean moveWattles;
    public static boolean moveWings;
    public static int headAnimationSpeed;
    public static int wattlesAnimationSpeed;
    public static int wingAnimationSpeed;
    private final class_5601 animatedChicken;

    public BuckaChickenElement(BiFunction<String, String, class_5601> factory) {
        super(class_1428.class, class_3417.field_14871);
        this.animatedChicken = factory.apply("animated_chicken", "main");
    }

    @Override
    public String[] modelDescription() {
        return new String[]{"This one makes chicken beaks open and close when they cluck.", "When they strut their heads move back and forth, the red thing under their beak swings around and their wings flap a little. Just like the real deal!"};
    }

    @Override
    void onRegisterAnimatedModels(ModelElement.AnimatedModelsContext context, ModelElement.EntityModelBakery bakery) {
        context.registerAnimatedModel(class_558.class, () -> new BuckaChickenModel(bakery.bakeLayer(this.animatedChicken)));
    }

    @Override
    public void onRegisterLayerDefinitions(BiConsumer<class_5601, Supplier<class_5607>> context) {
        context.accept(this.animatedChicken, BuckaChickenModel::createAnimatedBodyLayer);
    }

    @Override
    public void setupModelConfig(ForgeConfigSpec.Builder builder, ValueCallback callback) {
        super.setupModelConfig(builder, callback);
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Make bill a lot slimmer so chickens look less like ducks.").define("slim_bill", true), v -> {
            slimBill = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Move head back and forth when chicken is walking.").define("move_head", true), v -> {
            moveHead = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Wiggle chin when chicken is walking.").define("wiggle_wattles", true), v -> {
            moveWattles = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Flap wings when chicken is walking.").define("flap_wings", true), v -> {
            moveWings = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Move head back and forth when chicken is walking.").defineInRange("head_animation_speed", 4, 1, 20), v -> {
            headAnimationSpeed = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Animation swing speed for wattles movement.").defineInRange("wattles_animation_speed", 5, 1, 20), v -> {
            wattlesAnimationSpeed = v;
        });
        callback.accept((ForgeConfigSpec.ConfigValue)builder.comment("Animation swing speed of wing flapping.").defineInRange("wing_animation_speed", 3, 1, 20), v -> {
            wingAnimationSpeed = v;
        });
    }
}

