/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLParser;
import site.siredvin.peripheralium.extra.dsl.rml1.RMLParsingException;
import site.siredvin.peripheralium.extra.dsl.rml1.RenderInstruction;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\tJ\u001d\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tRl\u0010\u000e\u001aZ\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \r*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006 \r*,\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00040\u0004\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \r*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u0006\u0018\u00010\f0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lsite/siredvin/turtlematic/client/RenderUtil;", "", "<init>", "()V", "", "string", "", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RenderInstruction;", "parseRML", "(Ljava/lang/String;)Ljava/util/List;", "parseRMLRaw", "parseRMLRawProtected", "Lcom/google/common/cache/LoadingCache;", "kotlin.jvm.PlatformType", "cache", "Lcom/google/common/cache/LoadingCache;", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser;", "parser", "Lsite/siredvin/peripheralium/extra/dsl/rml1/RMLParser;", "turtlematic-fabric-1.20.1"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    @NotNull
    private static final RMLParser parser = new RMLParser();
    private static final LoadingCache<String, List<RenderInstruction>> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).maximumSize(3000L).build(CacheLoader.from(INSTANCE::parseRMLRawProtected));

    private RenderUtil() {
    }

    @NotNull
    public final List<RenderInstruction> parseRMLRaw(@NotNull String string) throws RMLParsingException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return parser.parse(string);
    }

    private final List<RenderInstruction> parseRMLRawProtected(String string) {
        List<RenderInstruction> list;
        try {
            list = this.parseRMLRaw(string);
        }
        catch (RMLParsingException ignored) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<RenderInstruction> parseRML(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Object object = cache.get((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cache.get(string)");
        return (List)object;
    }

    static {
        parser.injectDefault();
    }
}

