/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.computercraft.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IOwnerAbility;
import site.siredvin.peripheralium.api.peripheral.IPeripheralCheck;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.FuelAbility;
import site.siredvin.peripheralium.computercraft.peripheral.ability.PeripheralOwnerAbility;
import site.siredvin.peripheralium.computercraft.peripheral.owner.TurtlePeripheralOwner;
import site.siredvin.peripheralium.util.NBTUtil;
import site.siredvin.turtlematic.common.configuration.TurtlematicConfig;
import site.siredvin.turtlematic.computercraft.operations.SingleOperation;
import site.siredvin.turtlematic.computercraft.operations.SingleOperationContext;
import site.siredvin.turtlematic.computercraft.peripheral.automatas.BaseAutomataCorePeripheral;
import site.siredvin.turtlematic.computercraft.plugins.AutomataCorePlugin;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\nJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0017\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\nR\u001e\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001e\u001a\u00020\u001b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006 "}, d2={"Lsite/siredvin/turtlematic/computercraft/plugins/AutomataWarpingPlugin;", "Lsite/siredvin/turtlematic/computercraft/plugins/AutomataCorePlugin;", "Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/BaseAutomataCorePeripheral;", "automataCore", "<init>", "(Lsite/siredvin/turtlematic/computercraft/peripheral/automatas/BaseAutomataCorePeripheral;)V", "", "name", "Ldan200/computercraft/api/lua/MethodResult;", "deletePoint", "(Ljava/lang/String;)Ldan200/computercraft/api/lua/MethodResult;", "distanceToPoint", "estimateWarpCost", "Lsite/siredvin/turtlematic/computercraft/operations/SingleOperationContext;", "context", "", "getWarpCost", "(Lsite/siredvin/turtlematic/computercraft/operations/SingleOperationContext;)I", "points", "()Ldan200/computercraft/api/lua/MethodResult;", "savePoint", "warpToPoint", "", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralOperation;", "getOperations", "()Ljava/util/List;", "operations", "Lnet/minecraft/class_2487;", "getPointData", "()Lnet/minecraft/class_2487;", "pointData", "Companion", "turtlematic-fabric-1.20.1"})
public final class AutomataWarpingPlugin
extends AutomataCorePlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String POINT_DATA_MARK = "warp_points";
    @NotNull
    private static final String WORLD_DATA_MARK = "warp_world";

    public AutomataWarpingPlugin(@NotNull BaseAutomataCorePeripheral automataCore) {
        Intrinsics.checkNotNullParameter((Object)((Object)automataCore), (String)"automataCore");
        super(automataCore);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return CollectionsKt.listOf((Object)((Object)SingleOperation.WARP));
    }

    @NotNull
    protected final class_2487 getPointData() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner();
        class_2487 settings = owner.getDataStorage();
        if (!settings.method_10545(WORLD_DATA_MARK)) {
            class_1937 class_19372 = owner.getLevel();
            Intrinsics.checkNotNull((Object)class_19372);
            settings.method_10582(WORLD_DATA_MARK, class_19372.method_27983().method_29177().toString());
        } else {
            String string = settings.method_10558(WORLD_DATA_MARK);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settings.getString(WORLD_DATA_MARK)");
            String worldName = string;
            class_1937 class_19373 = owner.getLevel();
            Intrinsics.checkNotNull((Object)class_19373);
            if (!Intrinsics.areEqual((Object)class_19373.method_27983().method_29177().toString(), (Object)worldName)) {
                throw new LuaException("Incorrect world for this upgrade");
            }
        }
        if (!settings.method_10545(POINT_DATA_MARK)) {
            settings.method_10566(POINT_DATA_MARK, (class_2520)new class_2487());
        }
        class_2487 class_24872 = settings.method_10562(POINT_DATA_MARK);
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"settings.getCompound(POINT_DATA_MARK)");
        return class_24872;
    }

    private final int getWarpCost(SingleOperationContext context) {
        IOwnerAbility iOwnerAbility = ((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getAbility((IPeripheralOwnerAbility)PeripheralOwnerAbility.Companion.getFUEL());
        Intrinsics.checkNotNull((Object)iOwnerAbility);
        FuelAbility fuelAbility = (FuelAbility)iOwnerAbility;
        return SingleOperation.WARP.getCost(context) * fuelAbility.getFuelConsumptionMultiply();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult savePoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BaseAutomataCorePeripheral.addRotationCycle$default(this.getAutomataCore(), 0, 1, null);
        class_2487 data = this.getPointData();
        if (data.method_10541().size() >= TurtlematicConfig.INSTANCE.getEndAutomataCoreWarpPointLimit()) {
            Object[] objectArray = new Object[]{null, "Cannot add new point, limit reached"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(\n                null\u2026t reached\",\n            )");
            return methodResult;
        }
        data.method_10566(name, (class_2520)NBTUtil.INSTANCE.toNBT(((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getPos()));
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult deletePoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BaseAutomataCorePeripheral.addRotationCycle$default(this.getAutomataCore(), 0, 1, null);
        class_2487 data = this.getPointData();
        if (!data.method_10545(name)) {
            Object[] objectArray = new Object[]{null, "Cannot find point to delete"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find point to delete\")");
            return methodResult;
        }
        data.method_10551(name);
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult points() {
        class_2487 data = this.getPointData();
        MethodResult methodResult = MethodResult.of((Object)data.method_10541());
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(data.allKeys)");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult warpToPoint(@NotNull String name) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner();
        class_1937 class_19372 = owner.getLevel();
        Intrinsics.checkNotNull((Object)class_19372);
        class_1937 level = class_19372;
        class_2487 data = this.getPointData();
        if (!data.method_10545(name)) {
            Object[] objectArray = new Object[]{null, "Cannot find point to warp to"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot find point to warp to\")");
            return methodResult;
        }
        class_2487 class_24872 = data.method_10562(name);
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"data.getCompound(name)");
        class_2338 newPosition = NBTUtil.INSTANCE.blockPosFromNBT(class_24872);
        return this.getAutomataCore().withOperation(SingleOperation.WARP, this.getAutomataCore().toDistance(newPosition), arg_0 -> AutomataWarpingPlugin.warpToPoint$lambda$0(owner, level, newPosition, arg_0), (IPeripheralCheck)new IPeripheralCheck(owner, level, newPosition){
            final /* synthetic */ TurtlePeripheralOwner $owner;
            final /* synthetic */ class_1937 $level;
            final /* synthetic */ class_2338 $newPosition;
            {
                this.$owner = $owner;
                this.$level = $level;
                this.$newPosition = $newPosition;
            }

            @Nullable
            public final MethodResult check(@NotNull SingleOperationContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!this.$owner.isMovementPossible(this.$level, this.$newPosition)) {
                    Object[] objectArray = new Object[]{null, "Move forbidden"};
                    return MethodResult.of((Object[])objectArray);
                }
                return null;
            }

            @Nullable
            public IPeripheralCheck<T> checkAlso(@NotNull IPeripheralCheck<T> check) {
                return IPeripheralCheck.DefaultImpls.checkAlso((IPeripheralCheck)this, check);
            }
        });
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult estimateWarpCost(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        class_2487 data = this.getPointData();
        class_2487 class_24872 = data.method_10562(name);
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"data.getCompound(name)");
        class_2338 newPosition = NBTUtil.INSTANCE.blockPosFromNBT(class_24872);
        MethodResult methodResult = MethodResult.of((Object)this.getWarpCost(this.getAutomataCore().toDistance(newPosition)));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(getWarpCost(automataC\u2026toDistance(newPosition)))");
        return methodResult;
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final MethodResult distanceToPoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        class_2487 data = this.getPointData();
        class_2487 class_24872 = data.method_10562(name);
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"data.getCompound(name)");
        class_2338 newPosition = NBTUtil.INSTANCE.blockPosFromNBT(class_24872);
        MethodResult methodResult = MethodResult.of((Object)newPosition.method_19455((class_2382)((TurtlePeripheralOwner)this.getAutomataCore().getPeripheralOwner()).getPos()));
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(newPosition.distManha\u2026ore.peripheralOwner.pos))");
        return methodResult;
    }

    private static final MethodResult warpToPoint$lambda$0(TurtlePeripheralOwner $owner, class_1937 $level, class_2338 $newPosition, SingleOperationContext it) {
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$newPosition, (String)"$newPosition");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean result2 = $owner.move($level, $newPosition);
        if (!result2) {
            Object[] objectArray = new Object[]{null, "Cannot teleport to location"};
            MethodResult methodResult = MethodResult.of((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(null, \"Cannot teleport to location\")");
            return methodResult;
        }
        MethodResult methodResult = MethodResult.of((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)methodResult, (String)"of(true)");
        return methodResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lsite/siredvin/turtlematic/computercraft/plugins/AutomataWarpingPlugin$Companion;", "", "<init>", "()V", "", "POINT_DATA_MARK", "Ljava/lang/String;", "WORLD_DATA_MARK", "turtlematic-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

