/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import site.siredvin.peripheralium.api.turtle.TurtleUpgradeHolder;
import site.siredvin.peripheralium.util.Pair;
import site.siredvin.turtlematic.api.AutomataCoreTraits;
import site.siredvin.turtlematic.client.RenderTrickOpcode;
import site.siredvin.turtlematic.client.TurtleRenderTrick;
import site.siredvin.turtlematic.client.TurtleRenderTrickRegistry;
import site.siredvin.turtlematic.common.items.base.BaseAutomataCore;

public class MixinToolkit {
    @Nullable
    public static Pair<TurtleRenderTrick, class_2487> searchRenderTrickWithData(@Nonnull ITurtleUpgrade upgrade, @Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
        TurtleRenderTrick coreTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick(upgrade);
        if (coreTrick != null) {
            return Pair.Companion.of((Object)coreTrick, (Object)access.getUpgradeNBTData(side));
        }
        if (upgrade instanceof TurtleUpgradeHolder) {
            TurtleUpgradeHolder upgradeHolder = (TurtleUpgradeHolder)upgrade;
            for (UpgradeData internalUpgrade : upgradeHolder.getInternalUpgrades(access, side)) {
                TurtleRenderTrick internalTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick((ITurtleUpgrade)internalUpgrade.upgrade());
                if (internalTrick == null) continue;
                return Pair.Companion.of((Object)internalTrick, (Object)internalUpgrade.data());
            }
        }
        return null;
    }

    public static void render(@Nonnull TurtleBlockEntity turtle, float partialTicks, @Nonnull class_4587 transform, @Nonnull class_4597 buffers, int lightmapCoord, int overlayLight, CallbackInfo info) {
        Pair<TurtleRenderTrick, class_2487> rightRenderTrick;
        RenderTrickOpcode opcode;
        Pair<TurtleRenderTrick, class_2487> leftRenderTrick;
        ITurtleUpgrade leftUpgrade = turtle.getUpgrade(TurtleSide.LEFT);
        ITurtleUpgrade rightUpgrade = turtle.getUpgrade(TurtleSide.RIGHT);
        ITurtleAccess access = turtle.getAccess();
        boolean cancelTurtleRender = false;
        if (leftUpgrade != null && (leftRenderTrick = MixinToolkit.searchRenderTrickWithData(leftUpgrade, access, TurtleSide.LEFT)) != null && (opcode = ((TurtleRenderTrick)leftRenderTrick.getLeft()).render(turtle, access, TurtleSide.LEFT, (class_2487)leftRenderTrick.getRight(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (rightUpgrade != null && (rightRenderTrick = MixinToolkit.searchRenderTrickWithData(rightUpgrade, access, TurtleSide.RIGHT)) != null && (opcode = ((TurtleRenderTrick)rightRenderTrick.getLeft()).render(turtle, access, TurtleSide.RIGHT, (class_2487)rightRenderTrick.getRight(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (cancelTurtleRender) {
            info.cancel();
        }
    }

    public static void isFuelNeeded(Map<TurtleSide, ITurtleUpgrade> upgrades, CallbackInfoReturnable<Boolean> cir) {
        boolean isFuelConsumptionDisabled;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (isFuelConsumptionDisabled = upgrades.values().stream().anyMatch(it -> {
            class_1792 item = it.getCraftingItem().method_7909();
            if (item instanceof BaseAutomataCore) {
                BaseAutomataCore core = (BaseAutomataCore)item;
                return core.getCoreTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getFUEL_CONSUMPTION_DISABLED());
            }
            return false;
        }))) {
            cir.setReturnValue((Object)false);
        }
    }
}

