/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity;

import immersive_aircraft.Main;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBCube;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BBModelRenderer {
    public static void renderModel(BBModel model, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time) {
        model.root.forEach(object -> BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time));
    }

    private static void renderObject(BBModel model, BBObject object, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time) {
        BBAnimation animation;
        matrixStack.method_22903();
        matrixStack.method_46416(object.origin.x(), object.origin.y(), object.origin.z());
        if (!model.animations.isEmpty() && (animation = model.animations.get(0)).hasAnimator(object.uuid)) {
            Vector3f position = animation.sample(object.uuid, BBAnimator.Channel.POSITION, time);
            position.mul(0.0625f);
            matrixStack.method_46416(position.x(), position.y(), position.z());
            Vector3f rotation = animation.sample(object.uuid, BBAnimator.Channel.ROTATION, time);
            rotation.mul(0.017453294f);
            matrixStack.method_22907(Utils.fromXYZ(rotation.x(), rotation.y(), rotation.z()));
            Vector3f scale = animation.sample(object.uuid, BBAnimator.Channel.SCALE, time);
            matrixStack.method_22905(scale.x(), scale.y(), scale.z());
        }
        matrixStack.method_22907(Utils.fromXYZ(object.rotation.x(), object.rotation.y(), object.rotation.z()));
        matrixStack.method_46416(-object.origin.x(), -object.origin.y(), -object.origin.z());
        if (object instanceof BBCube) {
            BBCube cube = (BBCube)object;
            BBModelRenderer.renderCube(cube, matrixStack, vertexConsumerProvider, light);
        } else if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            bone.children.forEach(child -> BBModelRenderer.renderObject(model, child, matrixStack, vertexConsumerProvider, light, time));
        }
        matrixStack.method_22909();
    }

    private static void renderCube(BBCube cube, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_4587.class_4665 last = matrixStack.method_23760();
        Matrix4f positionMatrix = last.method_23761();
        Matrix3f normalMatrix = last.method_23762();
        for (BBFace face : cube.faces) {
            class_2960 id = Main.locate("textures/" + face.texture.name);
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)id));
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                vertexConsumer.method_22918(positionMatrix, v.x, v.y, v.z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(v.u, v.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.nx, v.ny, v.nz).method_1344();
            }
        }
    }
}

