/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.resources.ObjectLoader;
import immersive_aircraft.resources.obj.Face;
import immersive_aircraft.resources.obj.FaceVertex;
import immersive_aircraft.resources.obj.Mesh;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public interface MeshRenderer {
    public static Mesh getFaces(class_2960 id, String object) {
        return ObjectLoader.objects.get(id).get(object);
    }

    public static void renderObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light) {
        MeshRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f positionMatrix = entry.method_23761();
        Matrix3f normalMatrix = entry.method_23762();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                vertexConsumer.method_22918(positionMatrix, v.v.x, v.v.y, v.v.z).method_22915(r, g, b, a).method_22913(v.t.u, v.t.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
            }
        }
    }

    public static void renderSailObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light, double time, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f positionMatrix = entry.method_23761();
        Matrix3f normalMatrix = entry.method_23762();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                double angle = (double)(v.v.x + v.v.z) + (double)v.v.y * 0.25 + time * 0.25;
                double scale = 0.05;
                float x = (float)((double)v.v.x + (Math.cos(angle) + Math.cos(angle * 1.7)) * scale * (double)v.c.r);
                float z = (float)((double)v.v.z + (Math.sin(angle) + Math.sin(angle * 1.7)) * scale * (double)v.c.r);
                vertexConsumer.method_22918(positionMatrix, x, v.v.y, z).method_22915(r, g, b, a).method_22913(v.t.u, v.t.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
            }
        }
    }

    public static void renderBanner(class_4587 matrixStack, class_4597 vertexConsumers, int light, Mesh mesh, boolean isBanner, List<Pair<class_6880<class_2582>, class_1767>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<class_6880<class_2582>, class_1767> pair = patterns.get(i);
            float[] fs = ((class_1767)pair.getSecond()).method_7787();
            class_6880 bannerPattern = (class_6880)pair.getFirst();
            bannerPattern.method_40230().ifPresent(key -> {
                class_4730 spriteIdentifier = isBanner ? class_4722.method_33081((class_5321)key) : class_4722.method_33083((class_5321)key);
                class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, class_1921::method_23588);
                class_1058 sprite = spriteIdentifier.method_24148();
                class_4587.class_4665 entry = matrixStack.method_23760();
                Matrix4f positionMatrix = entry.method_23761();
                Matrix3f normalMatrix = entry.method_23762();
                for (Face face : mesh.faces) {
                    if (face.vertices.size() != 4) continue;
                    for (FaceVertex v : face.vertices) {
                        vertexConsumer.method_22918(positionMatrix, v.v.x, v.v.y, v.v.z).method_22915(fs[0], fs[1], fs[2], 1.0f).method_22913(v.t.u * (sprite.method_4577() - sprite.method_4594()) + sprite.method_4594(), v.t.v * (sprite.method_4575() - sprite.method_4593()) + sprite.method_4593()).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
                    }
                }
            });
        }
    }
}

