/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import immersive_aircraft.Main;
import immersive_aircraft.WeaponRendererRegistry;
import immersive_aircraft.client.render.entity.MeshRenderer;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.client.render.entity.weaponRenderer.WeaponRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.resources.obj.Mesh;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Vector3f;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends class_897<T> {
    public AircraftEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    protected abstract Model getModel(AircraftEntity var1);

    protected abstract Vector3f getPivot(AircraftEntity var1);

    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_4587.class_4665 peek = matrixStack.method_23760();
        matrixStack.method_22903();
        float h = (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.method_24828() ? new Vector3f(0.0f, 0.0f, 0.0f) : ((AircraftEntity)((java.lang.Object)entity)).getWindEffect();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_5695(tickDelta) + effect.z));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(((VehicleEntity)((java.lang.Object)entity)).getRoll(tickDelta) + effect.x));
        Vector3f pivot = this.getPivot((AircraftEntity)((java.lang.Object)entity));
        matrixStack.method_46416(pivot.x, pivot.y, pivot.z);
        Model model = this.getModel((AircraftEntity)((java.lang.Object)entity));
        for (Object object : model.getObjects()) {
            if (object.getAnimationConsumer() != null) {
                matrixStack.method_22903();
                object.getAnimationConsumer().run(entity, yaw, tickDelta, matrixStack);
            }
            object.getRenderConsumer().run(vertexConsumerProvider, entity, matrixStack, light, tickDelta);
            if (object.getAnimationConsumer() == null) continue;
            matrixStack.method_22909();
        }
        class_746 player = class_310.method_1551().field_1724;
        for (List<Weapon> weapons : ((InventoryVehicleEntity)((java.lang.Object)entity)).getWeapons().values()) {
            for (Weapon weapon : weapons) {
                WeaponRenderer<Weapon> renderer;
                if (weapon.getMount().blocking() && Main.firstPersonGetter.isFirstPerson() && player != null && entity.method_5626((class_1297)player) || (renderer = WeaponRendererRegistry.get(weapon)) == null) continue;
                renderer.render(entity, weapon, matrixStack, vertexConsumerProvider, light, tickDelta);
            }
        }
        ((AircraftEntity)((java.lang.Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public boolean shouldRender(T entity, class_4604 frustum, double x, double y, double z) {
        if (!entity.method_5727(x, y, z)) {
            return false;
        }
        class_238 box = entity.method_5830().method_1014(2.5);
        return frustum.method_23093(box);
    }

    protected class Model {
        private final List<Object> objects = new LinkedList<Object>();

        public Model add(Object o) {
            this.objects.add(o);
            return this;
        }

        public List<Object> getObjects() {
            return this.objects;
        }
    }

    protected class Object {
        private final class_2960 id;
        private final String object;
        private AnimationConsumer<T> animationConsumer = null;
        private RenderConsumer<T> renderConsumer = (vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
            class_2960 identifier = AircraftEntityRenderer.this.method_3931((class_1297)entity);
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)identifier));
            float health = entity.getHealth() * 0.5f + 0.5f;
            MeshRenderer.renderObject(this.getMesh(), matrixStack, vertexConsumer, light, health, health, health, 1.0f);
        };

        public Object(class_2960 id, String object) {
            this.id = id;
            this.object = object;
        }

        public Mesh getMesh() {
            Mesh mesh = MeshRenderer.getFaces(this.id, this.object);
            if (mesh == null) {
                throw new RuntimeException(String.format("Mesh %s in %s does not exist!", this.id, this.object));
            }
            return mesh;
        }

        public class_2960 getId() {
            return this.id;
        }

        public AnimationConsumer<T> getAnimationConsumer() {
            return this.animationConsumer;
        }

        public Object setAnimationConsumer(AnimationConsumer<T> animationConsumer) {
            this.animationConsumer = animationConsumer;
            return this;
        }

        public RenderConsumer<T> getRenderConsumer() {
            return this.renderConsumer;
        }

        public Object setRenderConsumer(RenderConsumer<T> renderConsumer) {
            this.renderConsumer = renderConsumer;
            return this;
        }

        public static interface AnimationConsumer<T> {
            public void run(T var1, float var2, float var3, class_4587 var4);
        }

        public static interface RenderConsumer<T> {
            public void run(class_4597 var1, T var2, class_4587 var3, int var4, float var5);
        }
    }
}

