/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.MeshRenderer;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.client.render.entity.renderer.AirshipEntityRenderer;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.resources.obj.Mesh;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class CargoAirshipEntityRenderer<T extends AirshipEntity>
extends AirshipEntityRenderer<T> {
    private static final class_2960 id = Main.locate("objects/cargo_airship.obj");
    private final class_2960 texture = Main.locate("textures/entity/cargo_airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "storage")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<class_1799> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (class_1799 slot : slots) {
            if (slot.method_7960() || !(slot.method_7909() instanceof class_1746)) continue;
            List<Pair<class_6880<class_2582>, class_1767>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = MeshRenderer.getFaces(id, "banner_" + i++);
            MeshRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_1767 color;
        class_2960 identifier = this.getTextureLocation(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        class_1799 stack = entity.getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        class_1792 patt3266$temp = stack.method_7909();
        if (patt3266$temp instanceof class_1769) {
            class_1769 item = (class_1769)patt3266$temp;
            color = item.method_7802();
        } else {
            color = class_1767.field_7952;
        }
        float r = color.method_7787()[0];
        float g = color.method_7787()[1];
        float b = color.method_7787()[2];
        if (entity.isWithinParticleRange() && Config.getInstance().enableAnimatedSails) {
            Mesh mesh = MeshRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.method_37908().method_8510() % 24000L) + tickDelta;
            MeshRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, r, g, b, 1.0f);
        } else {
            Mesh mesh = MeshRenderer.getFaces(id, "sails");
            MeshRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, r, g, b, 1.0f);
        }
    })).add(new AircraftEntityRenderer.Object(id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(0.0, -0.125, 0.78125);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(-entity.pressingInterpolatedX.getSmooth(tickDelta) * 20.0f));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
        matrixStack.method_22904(0.0, 0.125, -0.90625);
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_46416(0.0f, 0.1875f, 0.0f);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.method_46416(0.0f, -0.1875f, 0.0f);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTextureLocation(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = MeshRenderer.getFaces(id, "propeller");
        MeshRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(id, "small_propeller_right").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(-1.15625, 2.34375, 0.0);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.method_22904(1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTextureLocation(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = MeshRenderer.getFaces(id, "small_propeller_right");
        MeshRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    })).add(new AircraftEntityRenderer.Object(id, "small_propeller_left").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.method_22904(1.15625, 2.34375, 0.0);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)((double)entity.engineRotation.getSmooth(tickDelta) * 170.0)));
        matrixStack.method_22904(-1.15625, -2.34375, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        class_2960 identifier = this.getTextureLocation(entity);
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)identifier));
        Mesh mesh = MeshRenderer.getFaces(id, "small_propeller_left");
        MeshRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public CargoAirshipEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
    }

    @Override
    public class_2960 getTextureLocation(@NotNull T aircraft) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.2f, 0.0f);
    }
}

