/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.network.s2c.FireResponse;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class BulletWeapon
extends Weapon {
    private class_1799 ammoStack;
    private int ammo;

    public BulletWeapon(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    protected float getBarrelLength() {
        return 1.0f;
    }

    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected int getBulletCount() {
        return 1;
    }

    protected abstract class_1297 getBullet(class_1297 var1, Vector4f var2, Vector3f var3);

    @Override
    public void fire(Vector3f direction) {
        Vector4f position = this.getBarrelOffset();
        VehicleEntity entity = this.getEntity();
        position.mul((Matrix4fc)this.getMount().transform());
        position.mul((Matrix4fc)entity.getVehicleTransform());
        class_243 speed = entity.getSpeedVector();
        float barrelLength = this.getBarrelLength();
        position.add(direction.x() * barrelLength, direction.y() * barrelLength, direction.z() * barrelLength, 0.0f);
        for (int i = 0; i < this.getBulletCount(); ++i) {
            class_1297 bullet = this.getBullet(entity, position, direction);
            bullet.method_18799(bullet.method_18798().method_1019(speed));
            entity.method_37908().method_8649(bullet);
        }
        direction.mul(0.25f);
        direction.add((float)speed.field_1352, (float)speed.field_1351, (float)speed.field_1350);
        FireResponse fireMessage = new FireResponse(position, direction);
        for (class_3222 player : ((class_3218)entity.method_37908()).method_18456()) {
            NetworkHandler.sendToPlayer(fireMessage, player);
        }
    }

    protected boolean spentAmmo(Map<String, Integer> ammunition, int amount) {
        VehicleEntity vehicleEntity;
        if (this.ammo < amount && (vehicleEntity = this.getEntity()) instanceof InventoryVehicleEntity) {
            InventoryVehicleEntity vehicle = (InventoryVehicleEntity)vehicleEntity;
            for (int i = 0; i < vehicle.getInventory().method_5439(); ++i) {
                class_1799 stack = vehicle.getInventory().method_5438(i);
                String key = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
                if (!ammunition.containsKey(key)) continue;
                this.ammo += ammunition.get(key).intValue();
                this.ammoStack = stack.method_7972();
                stack.method_7934(1);
                if (this.ammo >= amount) break;
            }
        }
        if (this.ammo <= 0) {
            vehicleEntity = this.getEntity().method_5642();
            if (vehicleEntity instanceof class_1657) {
                class_1657 player = (class_1657)vehicleEntity;
                player.method_7353((class_2561)class_2561.method_43471((String)"immersive_aircraft.out_of_ammo"), true);
            }
            return false;
        }
        this.ammo -= amount;
        return true;
    }

    public class_1799 getAmmoStack() {
        return this.ammoStack;
    }

    public int getAmmo() {
        return this.ammo;
    }
}

