/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import immersive_aircraft.Entities;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.bullet.BulletEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.BulletWeapon;
import immersive_aircraft.entity.weapons.RotationalManager;
import immersive_aircraft.network.c2s.FireMessage;
import immersive_aircraft.util.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RotaryCannon
extends BulletWeapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);

    public RotaryCannon(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 1.125f, 0.0f, 1.0f);
    }

    public float getVelocity() {
        return 6.0f;
    }

    public float getInaccuracy() {
        return 0.0f;
    }

    @Override
    protected class_1297 getBullet(class_1297 shooter, Vector4f position, Vector3f direction) {
        BulletEntity bullet = (BulletEntity)Entities.BULLET.get().method_5883(shooter.method_37908());
        assert (bullet != null);
        bullet.method_5814(position.x(), position.y(), position.z());
        bullet.method_7432(shooter);
        bullet.method_7485(direction.x(), direction.y(), direction.z(), this.getVelocity(), this.getInaccuracy());
        return bullet;
    }

    @Override
    public void tick() {
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().gunpowderAmmunition, 10)) {
            super.fire(direction);
        }
    }

    private Vector3f getDirection() {
        return this.rotationalManager.screenToGlobal(this.getEntity());
    }

    public Quaternionf getHeadTransform(float tickDelta) {
        Quaternionf quaternion = Utils.fromXYZ(0.0f, 0.0f, (float)((double)(-this.getEntity().getRoll(tickDelta)) / 180.0 * Math.PI));
        quaternion.mul((Quaternionfc)Utils.fromXYZ(0.0f, -this.rotationalManager.getYaw(tickDelta), 0.0f));
        quaternion.mul((Quaternionfc)Utils.fromXYZ(this.rotationalManager.getPitch(tickDelta), 0.0f, 0.0f));
        quaternion.mul((Quaternionfc)Utils.fromXYZ(0.0f, 0.0f, this.rotationalManager.getRoll(tickDelta)));
        return quaternion;
    }

    @Override
    public void clientFire(int index) {
        float old = this.rotationalManager.roll;
        this.rotationalManager.roll += 0.25f;
        if (Math.floor(old) != Math.floor(this.rotationalManager.roll)) {
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }
}

