/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapons;

import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.RotationalManager;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.util.Utils;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Telescope
extends Weapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);
    int lastFireTick = 0;

    public Telescope(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    public void tick() {
        class_1309 pilot;
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
        --this.lastFireTick;
        if (this.lastFireTick == 0 && (pilot = this.getEntity().method_5642()) != null) {
            pilot.method_5783(class_3417.field_26973, 1.0f, 1.0f);
        }
    }

    @Override
    public void fire(Vector3f direction) {
    }

    public Quaternionf getHeadTransform(float tickDelta) {
        Quaternionf quaternion = Utils.fromXYZ(0.0f, 0.0f, (float)((double)(-this.getEntity().getRoll(tickDelta)) / 180.0 * Math.PI));
        quaternion.mul((Quaternionfc)Utils.fromXYZ(0.0f, -this.rotationalManager.getYaw(tickDelta), 0.0f));
        quaternion.mul((Quaternionfc)Utils.fromXYZ(this.rotationalManager.getPitch(tickDelta), 0.0f, 0.0f));
        return quaternion;
    }

    @Override
    public void clientFire(int index) {
        class_1309 pilot = this.getEntity().method_5642();
        assert (pilot != null);
        if (this.lastFireTick <= 0) {
            pilot.method_5783(class_3417.field_26972, 1.0f, 1.0f);
        }
        this.lastFireTick = 2;
    }

    public Boolean isScoping() {
        return this.lastFireTick > 0;
    }
}

