/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.resources.bbmodel.BBTexture;
import immersive_aircraft.util.Utils;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BBCube
extends BBObject {
    private static final String[] SIDES = new String[]{"north", "east", "south", "west", "up", "down"};
    private static final Vector3f[] NORMALS = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};
    private static final int[][] VERTEX_ORDER = new int[][]{{1, 4, 6, 3}, {0, 1, 3, 2}, {5, 0, 2, 7}, {4, 5, 7, 6}, {4, 1, 0, 5}, {7, 2, 3, 6}};
    public final Vector3f from;
    public final Vector3f to;
    public final int inflate;
    public final BBFace[] faces;

    public BBCube(JsonObject element, BBModel model) {
        super(element);
        int i;
        this.from = Utils.parseVector(element, "from");
        this.to = Utils.parseVector(element, "to");
        this.inflate = Utils.getIntElement(element, "inflate");
        this.faces = new BBFace[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            BBFace.BBVertex[] vertices = new BBFace.BBVertex[4];
            for (int j = 0; j < 4; ++j) {
                vertices[j] = new BBFace.BBVertex();
            }
            this.faces[i2] = new BBFace(vertices);
        }
        Vector3f[] positions = this.getPositions();
        for (i = 0; i < 6; ++i) {
            int[] order = VERTEX_ORDER[i];
            for (int j = 0; j < 4; ++j) {
                this.faces[i].vertices[j].x = positions[order[3 - j]].x();
                this.faces[i].vertices[j].y = positions[order[3 - j]].y();
                this.faces[i].vertices[j].z = positions[order[3 - j]].z();
            }
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.faces[i].vertices[j].nx = NORMALS[i].x();
                this.faces[i].vertices[j].ny = NORMALS[i].y();
                this.faces[i].vertices[j].nz = NORMALS[i].z();
            }
        }
        double[] u = new double[24];
        double[] v = new double[24];
        for (int i3 = 0; i3 < 6; ++i3) {
            BBTexture texture;
            JsonObject faceObject = element.getAsJsonObject("faces").getAsJsonObject(SIDES[i3]);
            int id = Utils.getIntElement(element, "texture");
            this.faces[i3].texture = texture = model.textures.get(id);
            float[] uv = new float[4];
            Iterator uvArray = faceObject.getAsJsonArray("uv").iterator();
            for (int j = 0; j < 4; ++j) {
                uv[j] = ((JsonElement)uvArray.next()).getAsFloat();
            }
            for (int rot = Utils.getIntElement(faceObject, "rotation"); rot > 0; rot -= 90) {
                this.roll(u, i3 * 4);
                this.roll(v, i3 * 4);
            }
            this.faces[i3].vertices[0].u = uv[0] / (float)texture.uvWidth;
            this.faces[i3].vertices[0].v = uv[3] / (float)texture.uvHeight;
            this.faces[i3].vertices[1].u = uv[2] / (float)texture.uvWidth;
            this.faces[i3].vertices[1].v = uv[3] / (float)texture.uvHeight;
            this.faces[i3].vertices[2].u = uv[2] / (float)texture.uvWidth;
            this.faces[i3].vertices[2].v = uv[1] / (float)texture.uvHeight;
            this.faces[i3].vertices[3].u = uv[0] / (float)texture.uvWidth;
            this.faces[i3].vertices[3].v = uv[1] / (float)texture.uvHeight;
        }
    }

    @NotNull
    private Vector3f[] getPositions() {
        Vector3f adjustedFrom = this.from;
        Vector3f adjustedTo = this.to;
        Vector3f inflate = new Vector3f((float)this.inflate, (float)this.inflate, (float)this.inflate);
        adjustedFrom.sub((Vector3fc)inflate);
        adjustedTo.sub((Vector3fc)inflate);
        adjustedFrom.mul(0.0625f);
        adjustedTo.mul(0.0625f);
        return new Vector3f[]{new Vector3f(adjustedTo.x(), adjustedTo.y(), adjustedTo.z()), new Vector3f(adjustedTo.x(), adjustedTo.y(), adjustedFrom.z()), new Vector3f(adjustedTo.x(), adjustedFrom.y(), adjustedTo.z()), new Vector3f(adjustedTo.x(), adjustedFrom.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedTo.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedTo.y(), adjustedTo.z()), new Vector3f(adjustedFrom.x(), adjustedFrom.y(), adjustedFrom.z()), new Vector3f(adjustedFrom.x(), adjustedFrom.y(), adjustedTo.z())};
    }

    private void roll(double[] u, int i) {
        double lastU = u[i * 4 + 3];
        for (int j = 3; j > 0; --j) {
            u[i * 4 + j] = u[i * 4 + j - 1];
        }
        u[i * 4] = lastU;
    }
}

