/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonObject;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBCube;
import immersive_aircraft.resources.bbmodel.BBMeta;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.resources.bbmodel.BBTexture;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class BBModel {
    public final BBMeta meta;
    public final List<BBTexture> textures = new LinkedList<BBTexture>();
    public final LinkedList<BBObject> root;
    public final HashMap<String, BBObject> objects;
    public final List<BBAnimation> animations = new LinkedList<BBAnimation>();

    public BBModel(JsonObject model) {
        this.meta = new BBMeta(model.get("meta"));
        this.root = new LinkedList();
        this.objects = new HashMap();
        model.get("textures").getAsJsonArray().forEach(element -> {
            BBTexture texture = new BBTexture(element.getAsJsonObject());
            this.textures.add(texture);
        });
        model.get("elements").getAsJsonArray().forEach(element -> {
            String type = element.getAsJsonObject().get("type").getAsString();
            if (type.equals("cube")) {
                BBCube object = new BBCube(element.getAsJsonObject(), this);
                this.objects.put(object.uuid, object);
            }
        });
        model.get("outliner").getAsJsonArray().forEach(element -> {
            if (element.isJsonPrimitive()) {
                this.root.add(this.objects.get(element.getAsString()));
            } else {
                BBBone bone = new BBBone(element.getAsJsonObject(), this);
                this.root.add(bone);
                this.objects.put(bone.uuid, bone);
            }
        });
        if (model.has("animations")) {
            model.get("animations").getAsJsonArray().forEach(element -> {
                BBAnimation animation = new BBAnimation(element.getAsJsonObject());
                this.animations.add(animation);
            });
        }
    }
}

