/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.utils;

import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import external.net.lenni0451.reflect.stream.RStream;
import external.net.lenni0451.reflect.stream.field.FieldStream;
import external.net.lenni0451.reflect.stream.field.FieldWrapper;
import external.net.lenni0451.reflect.stream.method.MethodStream;
import external.net.lenni0451.reflect.stream.method.MethodWrapper;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringUtils {
    public static final String UNKNOWN_BASE64_ID = "data:image/unknown;base64";
    public static final char COLOR_CHAR = '\u00a7';
    public static final String TOO_LARGE = "<...>";
    public static final String TAB_SPACE = "    ";
    public static final Predicate<String> NULL_OR_EMPTY = StringUtils::isNullOrEmpty;
    public static final Pattern NEW_LINE_PATTERN = Pattern.compile("(\\r\\n|\\r|\\n|\\\\n)");
    public static final Pattern STRIP_ALL_FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static final Pattern STRIP_FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[K-O]");
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final Pattern BASE64_PATTERN = Pattern.compile("data:(?<type>.+?);base64,(?<data>.+)");
    private static final Pattern TRIMMED_UUID_PATTERN = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})");
    private static final Pattern FULL_UUID_PATTERN = Pattern.compile("(\\w{8})-(\\w{4})-(\\w{4})-(\\w{4})-(\\w{12})");
    private static final Pattern BRACKET_PATTERN = Pattern.compile("\\([^0-9]*\\d+[^0-9]*\\)");
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(.*?)\\s(.*?)");
    private static final Pattern ALPHANUMERIC_PATTERN = Pattern.compile(".*[a-zA-Z0-9].*");

    public static Color getColorFrom(int red, int green, int blue, int alpha) {
        return new Color(red, green, blue, alpha);
    }

    public static Color getColorFrom(int red, int green, int blue) {
        return StringUtils.getColorFrom(red, green, blue, 255);
    }

    public static Color getColorFrom(int data) {
        return StringUtils.getColorFrom(data >> 16 & 0xFF, data >> 8 & 0xFF, data & 0xFF, data >> 24 & 0xFF);
    }

    public static Color getColorFrom(String hexColor) {
        Pair<Boolean, Matcher> matchData = StringUtils.isValidColor(hexColor);
        if (!matchData.getFirst().booleanValue()) {
            return Color.white;
        }
        Matcher m = matchData.getSecond();
        String s = m.group(1);
        if (s == null) {
            s = m.group(2);
        }
        if (s == null) {
            throw new IllegalStateException();
        }
        long l = Long.parseLong(s, 16);
        int a = m.group(1) != null ? (int)(l >> 24 & 0xFFL) : 255;
        int r = (int)(l >> 16 & 0xFFL);
        int g = (int)(l >> 8 & 0xFFL);
        int b = (int)(l & 0xFFL);
        return StringUtils.getColorFrom(r, g, b, a);
    }

    public static Pair<Color, Color> findColor(String startColorCode, String endColorCode) {
        Color startColorObj = null;
        Color endColorObj = null;
        int startColor = 0xFFFFFF;
        int endColor = 0xFFFFFF;
        if (!StringUtils.isNullOrEmpty(startColorCode)) {
            if (StringUtils.isValidColor(startColorCode).getFirst().booleanValue()) {
                startColorObj = StringUtils.getColorFrom(startColorCode);
                endColorObj = !StringUtils.isNullOrEmpty(endColorCode) && StringUtils.isValidColor(endColorCode).getFirst() != false ? StringUtils.getColorFrom(endColorCode) : startColorObj;
            } else {
                Pair<Boolean, Integer> startColorData = StringUtils.getValidInteger(startColorCode);
                Pair<Boolean, Integer> endColorData = StringUtils.getValidInteger(endColorCode);
                if (startColorData.getFirst().booleanValue() || endColorData.getFirst().booleanValue()) {
                    startColor = startColorData.getFirst() != false ? startColorData.getSecond() : endColor;
                    int n = endColor = endColorData.getFirst() != false ? endColorData.getSecond() : startColor;
                }
            }
        }
        if (startColorObj == null) {
            startColorObj = StringUtils.getColorFrom(startColor);
        }
        if (endColorObj == null) {
            endColorObj = StringUtils.getColorFrom(endColor);
        }
        return new Pair<Color, Color>(startColorObj, endColorObj);
    }

    public static Color offsetColor(Color color, float factor) {
        return new Color(Math.max((int)((float)color.getRed() * factor), 0), Math.max((int)((float)color.getGreen() * factor), 0), Math.max((int)((float)color.getBlue() * factor), 0), color.getAlpha());
    }

    public static Pair<Color, Color> findColor(Object startColorObj, Object endColorObj) {
        Color startColor = null;
        Color endColor = null;
        Object object = endColorObj = endColorObj == null ? startColorObj : endColorObj;
        if (startColorObj instanceof String) {
            Pair<Color, Color> colorData = StringUtils.findColor((String)startColorObj, endColorObj instanceof String ? (String)endColorObj : null);
            startColor = colorData.getFirst();
            endColor = colorData.getSecond();
        } else if (startColorObj instanceof Color) {
            startColor = (Color)startColorObj;
            endColor = endColorObj instanceof Color ? (Color)endColorObj : startColor;
        }
        return new Pair<Color, Object>(startColor, endColor);
    }

    public static Color findColor(Object startColorObj) {
        return StringUtils.findColor(startColorObj, null).getFirst();
    }

    public static Pair<Boolean, Matcher> isValidColor(String entry) {
        Matcher m = Pattern.compile("^(?:0x([\\dA-Fa-f]{1,8})|#?([\\dA-Fa-f]{6}))$").matcher(entry);
        return new Pair<Boolean, Matcher>(m.find(), m);
    }

    public static byte[] getBytes(String original, String encoding) {
        try {
            if (!StringUtils.isNullOrEmpty(encoding)) {
                return original.getBytes(encoding);
            }
            return StringUtils.getBytes(original, DEFAULT_CHARSET.name());
        }
        catch (Exception ex) {
            return StringUtils.getBytes(original, DEFAULT_CHARSET.name());
        }
    }

    public static byte[] getBytes(String original) {
        return StringUtils.getBytes(original, null);
    }

    public static String getStackTrace(Throwable ex) {
        if (ex == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public static String convertString(String original, String encoding, boolean decode) {
        try {
            if (decode) {
                return new String(StringUtils.getBytes(original), encoding);
            }
            byte[] bytes = StringUtils.getBytes(original, encoding);
            return new String(bytes, 0, bytes.length, DEFAULT_CHARSET);
        }
        catch (Exception ex) {
            return original;
        }
    }

    public static Object[] getDynamicArray(Object original) {
        if (!(original instanceof Object[])) {
            try {
                int len = Array.getLength(original);
                Object[] objects = new Object[len];
                for (int i = 0; i < len; ++i) {
                    objects[i] = Array.get(original, i);
                }
                return objects;
            }
            catch (Throwable ex) {
                return null;
            }
        }
        return (Object[])original;
    }

    public static String getOrDefault(String primary, String secondary, Predicate<String> condition) {
        return condition.test(primary) ? primary : secondary;
    }

    public static String getOrDefault(String primary, String secondary) {
        return StringUtils.getOrDefault(primary, secondary, NULL_OR_EMPTY.negate());
    }

    public static String getOrDefault(String primary) {
        return StringUtils.getOrDefault(primary, "");
    }

    public static <T> void revlist(List<T> list) {
        if (list == null || list.size() <= 1) {
            return;
        }
        T value = list.remove(0);
        StringUtils.revlist(list);
        list.add(value);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, Object original, int flags) {
        return original != null ? StringUtils.getMatches(regexValue, original.toString(), flags) : new Pair<String, List<String>>("", StringUtils.newArrayList());
    }

    public static Pair<String, List<String>> getMatches(String regexValue, Object original) {
        return StringUtils.getMatches(regexValue, original, 0);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, String original, int flags) {
        List matches = StringUtils.newArrayList();
        if (!StringUtils.isNullOrEmpty(original)) {
            Pattern pattern = Pattern.compile(regexValue, flags);
            Matcher m = pattern.matcher(original);
            while (m.find()) {
                matches.add(m.group());
            }
        }
        return new Pair<String, List<String>>(original, matches);
    }

    public static Pair<String, List<String>> getMatches(String regexValue, String original) {
        return StringUtils.getMatches(regexValue, original, 0);
    }

    public static String removeMatches(Pair<String, List<String>> matchData, List<Pair<String, String>> parsedMatchData, int maxMatches) {
        String finalString = "";
        if (matchData != null) {
            finalString = matchData.getFirst();
            List<String> matchList = matchData.getSecond();
            if (!matchList.isEmpty()) {
                int foundMatches = 0;
                for (String match : matchList) {
                    boolean isValidScan = foundMatches >= maxMatches;
                    boolean alreadyRemoved = false;
                    if (parsedMatchData != null && !parsedMatchData.isEmpty()) {
                        for (Pair<String, String> parsedArgument : parsedMatchData) {
                            if (!parsedArgument.getFirst().equalsIgnoreCase(match) || !StringUtils.isNullOrEmpty(parsedArgument.getSecond())) continue;
                            finalString = finalString.replaceFirst(match, "");
                            alreadyRemoved = true;
                            break;
                        }
                    }
                    if (alreadyRemoved) continue;
                    if (isValidScan) {
                        finalString = finalString.replaceFirst(match, "");
                    }
                    ++foundMatches;
                }
            }
        }
        return finalString;
    }

    public static String replace(String source, String targetToReplace, String replaceWith, boolean matchCase, boolean matchWholeWord, boolean useRegex) {
        if (!StringUtils.isNullOrEmpty(source)) {
            Object patternString = useRegex ? targetToReplace : (matchWholeWord ? "(?i)\\b" + Pattern.quote(targetToReplace) + "\\b" : Pattern.quote(targetToReplace));
            int flags = 16;
            if (!matchCase) {
                flags |= 0x42;
            }
            return Pattern.compile((String)patternString, flags).matcher(source).replaceAll(Matcher.quoteReplacement(replaceWith));
        }
        return "";
    }

    @SafeVarargs
    public static String sequentialReplace(String source, boolean matchCase, boolean matchWholeWord, boolean useRegex, Map<String, String> ... replaceArgs) {
        if (!StringUtils.isNullOrEmpty(source)) {
            String finalResult = source;
            for (Map<String, String> replaceData : replaceArgs) {
                if (replaceData.isEmpty()) continue;
                for (Map.Entry<String, String> replacementData : replaceData.entrySet()) {
                    finalResult = StringUtils.replace(finalResult, replacementData.getKey(), replacementData.getValue(), matchCase, matchWholeWord, useRegex);
                }
            }
            return finalResult;
        }
        return "";
    }

    public static String minifyString(String source, int length) {
        if (!StringUtils.isNullOrEmpty(source)) {
            return length >= 0 ? source.substring(0, length) : source;
        }
        return "";
    }

    public static boolean isNullOrEmpty(String entry, boolean allowWhitespace) {
        if (entry != null) {
            entry = allowWhitespace ? entry : entry.trim();
        }
        return entry == null || entry.isEmpty() || entry.equalsIgnoreCase("null");
    }

    public static boolean isNullOrEmpty(String entry) {
        return StringUtils.isNullOrEmpty(entry, false);
    }

    public static boolean isValidBoolean(Object entry) {
        return entry != null && StringUtils.isValidBoolean(entry.toString());
    }

    public static boolean isValidBoolean(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (entry.equalsIgnoreCase("true") || entry.equalsIgnoreCase("false"));
    }

    public static boolean isValidColorCode(String entry) {
        return !StringUtils.isNullOrEmpty(entry) && (StringUtils.isValidColor(entry).getFirst() != false || StringUtils.getValidInteger(entry).getFirst() != false);
    }

    public static Pair<Boolean, Integer> getValidInteger(Object entry) {
        return entry != null ? StringUtils.getValidInteger(entry.toString()) : new Pair<Boolean, Integer>(false, 0);
    }

    public static Pair<Boolean, Integer> getValidInteger(String entry) {
        Pair<Boolean, Integer> finalSet = new Pair<Boolean, Integer>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Integer.parseInt(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static Pair<Boolean, Long> getValidLong(Object entry) {
        return entry != null ? StringUtils.getValidLong(entry.toString()) : new Pair<Boolean, Long>(false, 0L);
    }

    public static Pair<Boolean, Long> getValidLong(String entry) {
        Pair<Boolean, Long> finalSet = new Pair<Boolean, Long>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Long.parseLong(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static Pair<Boolean, Boolean> getValidBoolean(Object entry) {
        return entry != null ? StringUtils.getValidBoolean(entry.toString()) : new Pair<Boolean, Boolean>(false, false);
    }

    public static Pair<Boolean, Boolean> getValidBoolean(String entry) {
        Pair<Boolean, Boolean> finalSet = new Pair<Boolean, Boolean>();
        if (!StringUtils.isNullOrEmpty(entry)) {
            try {
                finalSet.setSecond(Boolean.parseBoolean(entry));
                finalSet.setFirst(true);
            }
            catch (Exception ex) {
                finalSet.setFirst(false);
            }
        } else {
            finalSet.setFirst(false);
        }
        return finalSet;
    }

    public static String formatAddress(String input, boolean returnPort) {
        if (!StringUtils.isNullOrEmpty(input)) {
            String[] formatted = input.split(":", 2);
            return !returnPort ? (StringUtils.elementExists(formatted, 0) ? formatted[0].trim() : "127.0.0.1") : (StringUtils.elementExists(formatted, 1) ? formatted[1].trim() : "25565");
        }
        return !returnPort ? "127.0.0.1" : "25565";
    }

    public static boolean containsWhitespace(String original) {
        return StringUtils.isNullOrEmpty(original) || WHITESPACE_PATTERN.matcher(original).find();
    }

    public static boolean containsAlphaNumeric(String original) {
        return !StringUtils.isNullOrEmpty(original) && ALPHANUMERIC_PATTERN.matcher(original).find();
    }

    public static String formatToCamel(String original) {
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String[] words = original.split("[\\W_]+");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            Object word = words[i];
            word = i == 0 ? (((String)word).isEmpty() ? word : ((String)word).toLowerCase()) : (((String)word).isEmpty() ? word : Character.toUpperCase(((String)word).charAt(0)) + ((String)word).substring(1).toLowerCase());
            builder.append((String)word);
        }
        return builder.toString();
    }

    public static String formatAsIcon(String original, String whitespaceIndex) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey)) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", whitespaceIndex);
        }
        formattedKey = formattedKey.replaceAll("[^a-zA-Z0-9_-]", "_");
        return formattedKey.toLowerCase().trim();
    }

    public static String formatAsIcon(String original) {
        return StringUtils.formatAsIcon(original, "");
    }

    public static Tuple<Boolean, String, String> isBase64(String original) {
        String formattedKey = original;
        String imageIdentifier = "";
        Tuple<Boolean, String, String> finalData = new Tuple<Boolean, String, String>(false, imageIdentifier, formattedKey);
        if (!StringUtils.isNullOrEmpty(formattedKey)) {
            if (formattedKey.contains(",")) {
                String[] splitData = formattedKey.split(",", 2);
                imageIdentifier = splitData[0];
                formattedKey = splitData[1];
            }
            finalData.setFirst(BASE64_PATTERN.matcher(imageIdentifier + "," + formattedKey).find());
            finalData.setSecond(imageIdentifier);
            finalData.setThird(formattedKey);
        }
        return finalData;
    }

    public static boolean isValidUuid(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.contains("-") ? FULL_UUID_PATTERN : TRIMMED_UUID_PATTERN).matcher(input).find();
    }

    public static String getFromUuid(String input, boolean trimmed) {
        if (!StringUtils.isValidUuid(input)) {
            return input;
        }
        if (trimmed) {
            return input.replace("-", "");
        }
        Pattern pattern = input.contains("-") ? FULL_UUID_PATTERN : TRIMMED_UUID_PATTERN;
        return pattern.matcher(input).find() ? pattern.matcher(input).replaceFirst("$1-$2-$3-$4-$5") : input;
    }

    public static String getFromUuid(String input) {
        return StringUtils.getFromUuid(input, false);
    }

    public static String getFromUuid(UUID input) {
        return StringUtils.getFromUuid(input.toString());
    }

    public static UUID getAsUuid(String input) {
        return UUID.fromString(StringUtils.getFromUuid(input, false));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, List<T> newList) {
        for (T entry : newList) {
            if (original.contains(entry)) continue;
            original.add(entry);
        }
        return original;
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, List<T> newList) {
        newList = newList.stream().filter(filter).collect(Collectors.toList());
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Set<T> newList) {
        return StringUtils.addEntriesNotPresent(original, StringUtils.newArrayList(newList));
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, Predicate<? super T> filter, Set<T> newList) {
        newList = newList.stream().filter(filter).collect(Collectors.toSet());
        return StringUtils.addEntriesNotPresent(original, newList);
    }

    public static <T> List<T> addEntriesNotPresent(List<T> original, T[] newList) {
        return StringUtils.addEntriesNotPresent(original, Arrays.asList(newList));
    }

    public static String formatWord(String original) {
        return StringUtils.formatWord(original, false);
    }

    public static String formatWord(String original, boolean avoid) {
        return StringUtils.formatWord(original, avoid, false);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement) {
        return StringUtils.formatWord(original, avoid, skipSymbolReplacement, -1);
    }

    public static String formatWord(String original, boolean avoid, boolean skipSymbolReplacement, int caseCheckTimes) {
        String formattedKey = original;
        if (StringUtils.isNullOrEmpty(formattedKey) || avoid) {
            return formattedKey;
        }
        if (StringUtils.containsWhitespace(formattedKey)) {
            formattedKey = formattedKey.replaceAll("\\s+", " ");
        }
        if (!skipSymbolReplacement) {
            if (formattedKey.contains("_")) {
                formattedKey = formattedKey.replaceAll("_", " ");
            }
            if (formattedKey.contains("-")) {
                formattedKey = formattedKey.replaceAll("-", " ");
            }
            if (BRACKET_PATTERN.matcher(formattedKey).find()) {
                formattedKey = BRACKET_PATTERN.matcher(formattedKey).replaceAll("");
            }
            if (STRIP_ALL_FORMATTING_PATTERN.matcher(formattedKey).find()) {
                formattedKey = STRIP_ALL_FORMATTING_PATTERN.matcher(formattedKey).replaceAll("");
            }
        }
        return StringUtils.removeRepeatWords(StringUtils.capitalizeWord(formattedKey, caseCheckTimes)).trim();
    }

    public static String removeRepeatWords(String original) {
        String[] wordList;
        if (StringUtils.isNullOrEmpty(original)) {
            return original;
        }
        String lastWord = "";
        StringBuilder finalString = new StringBuilder();
        for (String word : wordList = original.split(" ")) {
            if (!StringUtils.isNullOrEmpty(lastWord) && word.equalsIgnoreCase(lastWord)) continue;
            finalString.append(word).append(" ");
            lastWord = word;
        }
        return finalString.toString().trim();
    }

    public static String formatIdentifier(String originalId, boolean formatToId) {
        return StringUtils.formatIdentifier(originalId, formatToId, false);
    }

    public static String formatIdentifier(String originalId, boolean formatToId, boolean avoid) {
        StringBuilder formattedKey = new StringBuilder(originalId);
        if (StringUtils.isNullOrEmpty(formattedKey.toString())) {
            return formattedKey.toString();
        }
        if (formattedKey.toString().equals("WorldProvider")) {
            formattedKey = new StringBuilder("overworld");
        } else if (formattedKey.toString().contains("WorldProvider")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("WorldProvider", ""));
        }
        if (formattedKey.toString().contains("BiomeGen")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("BiomeGen", ""));
        }
        if (formattedKey.toString().contains("MobSpawner")) {
            formattedKey = new StringBuilder(formattedKey.toString().replace("MobSpawner", ""));
        }
        if (StringUtils.containsWhitespace(formattedKey.toString())) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("\\s+", " "));
        }
        if (formattedKey.toString().contains(":")) {
            formattedKey = new StringBuilder(formattedKey.toString().split(":", 2)[1]);
        }
        if (formattedKey.toString().contains("{") || formattedKey.toString().contains("}")) {
            formattedKey = new StringBuilder(formattedKey.toString().replaceAll("[{}]", ""));
        }
        if (formattedKey.toString().equalsIgnoreCase("surface")) {
            formattedKey = new StringBuilder("overworld");
        } else if (formattedKey.toString().equalsIgnoreCase("hell") || formattedKey.toString().equalsIgnoreCase("nether")) {
            formattedKey = new StringBuilder("the_nether");
        } else if (formattedKey.toString().equalsIgnoreCase("end") || formattedKey.toString().equalsIgnoreCase("sky")) {
            formattedKey = new StringBuilder("the_end");
        }
        if (formatToId) {
            return StringUtils.formatAsIcon(formattedKey.toString(), "_");
        }
        return StringUtils.formatWord(formattedKey.toString(), avoid);
    }

    public static boolean isFormatColor(char colorChar) {
        return colorChar >= '0' && colorChar <= '9' || colorChar >= 'a' && colorChar <= 'f' || colorChar >= 'A' && colorChar <= 'F';
    }

    public static boolean isFormatSpecial(char formatChar) {
        return formatChar >= 'k' && formatChar <= 'o' || formatChar >= 'K' && formatChar <= 'O' || formatChar == 'r' || formatChar == 'R';
    }

    public static String getFormatFromString(String text) {
        int stringLength = text.length();
        StringBuilder s = new StringBuilder();
        int index = -1;
        while ((index = text.indexOf(167, index + 1)) != -1) {
            if (index >= stringLength - 1) continue;
            char currentCharacter = text.charAt(index + 1);
            if (StringUtils.isFormatColor(currentCharacter)) {
                s = new StringBuilder("\u00a7" + currentCharacter);
                continue;
            }
            if (!StringUtils.isFormatSpecial(currentCharacter)) continue;
            s.append('\u00a7').append(currentCharacter);
        }
        return s.toString();
    }

    public static String capitalizeWord(String str, int timesToCheck) {
        StringBuilder s = new StringBuilder();
        int charIndex = 32;
        int timesLeft = timesToCheck;
        for (int index = 0; index < str.length(); ++index) {
            if (charIndex == 32 && str.charAt(index) != ' ' && (timesLeft > 0 || timesLeft == -1)) {
                s.append(Character.toUpperCase(str.charAt(index)));
                if (timesLeft > 0) {
                    --timesLeft;
                }
            } else {
                s.append(str.charAt(index));
            }
            charIndex = str.charAt(index);
        }
        return s.toString().trim();
    }

    public static String capitalizeWord(String str) {
        return StringUtils.capitalizeWord(str, -1);
    }

    public static List<String> splitTextByNewLine(String original, boolean allowWhitespace) {
        if (!StringUtils.isNullOrEmpty(original, allowWhitespace)) {
            return StringUtils.newArrayList(NEW_LINE_PATTERN.split(original));
        }
        return StringUtils.newArrayList();
    }

    public static List<String> splitTextByNewLine(String original) {
        return StringUtils.splitTextByNewLine(original, false);
    }

    public static String join(String separator, List<String> input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.size(); ++i) {
            sb.append(input.get(i));
            if (i >= input.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static <T> boolean elementExists(T[] data, int index) {
        return StringUtils.elementExists(Arrays.asList(data), index);
    }

    public static <T> boolean elementExists(List<T> data, int index) {
        boolean result;
        try {
            result = data.size() >= index && data.get(index) != null;
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public static <T> T[] addToArray(T[] array, T element) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        T[] result = Arrays.copyOf(array, array.length + 1);
        result[array.length] = element;
        return result;
    }

    @SafeVarargs
    public static <T> List<T> newArrayList(T ... elements) {
        return new ArrayList<T>(Arrays.asList(elements));
    }

    public static <T> List<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> List<T> newArrayList(Iterator<T> iterator) {
        ArrayList<T> list = new ArrayList<T>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <T> List<T> newArrayList(Iterable<T> iterable) {
        return StringUtils.newArrayList(iterable.iterator());
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K extends Comparable<? super K>, V> TreeMap<K, V> newTreeMap(Map<? extends K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    public static FieldStream getFields(Class<?> classToAccess) {
        return RStream.of(classToAccess).fields();
    }

    public static MethodStream getMethods(Class<?> classToAccess) {
        return RStream.of(classToAccess).methods();
    }

    public static String getFieldList(Class<?> classToAccess) {
        StringBuilder sb = new StringBuilder();
        if (classToAccess != null) {
            sb.append(classToAccess).append(": [\n");
            StringUtils.getFields(classToAccess).forEach(e -> sb.append(TAB_SPACE).append(e.type()).append(" ").append(e.name()).append("\n"));
            sb.append("]");
        }
        return sb.toString();
    }

    public static String getMethodList(Class<?> classToAccess) {
        StringBuilder sb = new StringBuilder();
        if (classToAccess != null) {
            sb.append(classToAccess).append(": [\n");
            StringUtils.getMethods(classToAccess).forEach(e -> sb.append(TAB_SPACE).append(e.returnType()).append(" ").append(e.name()).append("(").append(Arrays.stream(e.parameterTypes()).map(Class::toString).collect(Collectors.joining(", "))).append(")\n"));
            sb.append("]");
        }
        return sb.toString();
    }

    public static Optional<FieldWrapper> getValidField(Class<?> classToAccess, String ... fieldNames) {
        if (classToAccess == null || fieldNames == null || fieldNames.length == 0) {
            return Optional.empty();
        }
        return StringUtils.getFields(classToAccess).filter(fieldNames).jstream().findFirst();
    }

    public static Optional<MethodWrapper> getValidMethod(Class<?> classToAccess, Class<?>[] parameterTypes, String ... methodNames) {
        if (classToAccess == null || methodNames == null || methodNames.length == 0) {
            return Optional.empty();
        }
        return StringUtils.getMethods(classToAccess).filter(methodNames).filter(parameterTypes).jstream().findFirst();
    }

    public static Object getField(Class<?> classToAccess, Object instance, String ... fieldNames) {
        return StringUtils.getValidField(classToAccess, fieldNames).map(f -> f.get(instance)).orElse(null);
    }

    public static void updateField(Class<?> classToAccess, Object instance, Object value, String ... fieldNames) {
        StringUtils.getValidField(classToAccess, fieldNames).ifPresent(fieldWrapper -> fieldWrapper.set(instance, value));
    }

    public static Object executeMethod(Class<?> classToAccess, Object instance, Class<?>[] parameterTypes, Object[] parameters, String ... methodNames) {
        return StringUtils.getValidMethod(classToAccess, parameterTypes, methodNames).map(methodWrapper -> methodWrapper.invokeInstance(instance, parameters)).orElse(null);
    }

    public static String stripColors(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_COLOR_PATTERN.matcher(input).replaceAll("");
    }

    public static String stripFormatting(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_FORMATTING_PATTERN.matcher(input).replaceAll("");
    }

    public static String stripAllFormatting(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : STRIP_ALL_FORMATTING_PATTERN.matcher(input).replaceAll("");
    }

    public static String normalizeLines(String input) {
        return StringUtils.isNullOrEmpty(input) ? input : NEW_LINE_PATTERN.matcher(input).replaceAll("\n");
    }

    public static String normalize(String input) {
        return StringUtils.stripAllFormatting(StringUtils.normalizeLines(input));
    }
}

