/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.config.category;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Module;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorSection;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import java.io.Serializable;

public class Accessibility
extends Module
implements Serializable {
    private static final long serialVersionUID = -6804925684173174749L;
    private static final Accessibility DEFAULT = new Accessibility();
    public ColorData tooltipBackground = new ColorData(new ColorSection(16, 0, 16, 240));
    public ColorData tooltipBorder = new ColorData(new ColorSection(80, 0, 255, 80), new ColorSection(40, 0, 127, 80));
    public ColorData guiBackground = new ColorData(new ColorSection(64, 64, 64, 255), RenderUtils.DEFAULT_GUI_BACKGROUND);
    public ColorData worldGuiBackground = new ColorData(new ColorSection(16, 16, 16, 192), new ColorSection(16, 16, 16, 208));
    public String languageId = Constants.TRANSLATOR.getDefaultLanguage();
    public boolean stripTranslationColors = false;
    public boolean stripTranslationFormatting = ModUtils.IS_TEXT_FORMATTING_BLOCKED;
    public boolean stripExtraGuiElements = false;
    public boolean renderTooltips = true;
    public int configKeyCode = ModUtils.MCProtocolID > 340 ? 96 : 41;

    public Accessibility(Accessibility other) {
        this.transferFrom(other);
    }

    public Accessibility() {
    }

    @Override
    public Accessibility getDefaults() {
        return new Accessibility(DEFAULT);
    }

    @Override
    public Accessibility copy() {
        return new Accessibility(this);
    }

    @Override
    public void transferFrom(Module target) {
        if (target instanceof Accessibility && !this.equals(target)) {
            Accessibility data = (Accessibility)target;
            this.tooltipBackground = new ColorData(data.tooltipBackground);
            this.tooltipBorder = new ColorData(data.tooltipBorder);
            this.guiBackground = new ColorData(data.guiBackground);
            this.worldGuiBackground = new ColorData(data.worldGuiBackground);
            this.languageId = data.languageId;
            this.stripTranslationColors = data.stripTranslationColors;
            this.stripTranslationFormatting = data.stripTranslationFormatting;
            this.stripExtraGuiElements = data.stripExtraGuiElements;
            this.renderTooltips = data.renderTooltips;
            this.configKeyCode = data.configKeyCode;
        }
    }

    @Override
    public Object getProperty(String name) {
        return StringUtils.getField(Accessibility.class, this, name);
    }

    @Override
    public void setProperty(String name, Object value) {
        StringUtils.updateField(Accessibility.class, this, value, name);
    }
}

