/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.impl;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TimeUtils;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.class_1011;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageFrame {
    private final int delay;
    private final BufferedImage image;
    private final class_1011 nativeImage;
    private final String disposal;
    private final int width;
    private final int height;
    private long renderTime = 0L;

    public ImageFrame(BufferedImage image, int delay, String disposal, int width, int height) {
        this.image = ImageFrame.deepCopy(image);
        this.nativeImage = null;
        this.delay = delay;
        this.disposal = disposal;
        this.width = width;
        this.height = height;
    }

    public ImageFrame(BufferedImage image) {
        this(image, -1, null, -1, -1);
    }

    public ImageFrame(class_1011 image, int delay, String disposal, int width, int height) {
        this.image = null;
        this.nativeImage = image;
        this.delay = delay;
        this.disposal = disposal;
        this.width = width;
        this.height = height;
    }

    public ImageFrame(class_1011 image) {
        this(image, -1, null, -1, -1);
    }

    public ImageFrame(BufferedImage image, class_1011 nativeImage, int delay, String disposal, int width, int height) {
        this.image = ImageFrame.deepCopy(image);
        this.nativeImage = nativeImage;
        this.delay = delay;
        this.disposal = disposal;
        this.width = width;
        this.height = height;
    }

    public ImageFrame(BufferedImage image, class_1011 nativeImage) {
        this(image, nativeImage, -1, null, -1, -1);
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(bi.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null).getSubimage(0, 0, bi.getWidth(), bi.getHeight());
    }

    public static boolean isExternalImage(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.toLowerCase().startsWith("http") || StringUtils.isBase64(input).getFirst() != false || input.toLowerCase().startsWith("file://"));
    }

    public static byte[] decodeBase64(String input, String encoding, boolean useDecodingMethod, boolean repeatCycle) {
        try {
            return Base64.getDecoder().decode(useDecodingMethod ? URLDecoder.decode(input, encoding) : input);
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
            if (!repeatCycle) {
                return ImageFrame.decodeBase64(input, encoding, !useDecodingMethod, true);
            }
            return null;
        }
    }

    public static ImageFrame[] readGif(InputStream stream) throws IOException {
        ArrayList<ImageFrame> frames = new ArrayList<ImageFrame>(2);
        ImageReader reader = ImageIO.getImageReadersByFormatName("gif").next();
        reader.setInput(ImageIO.createImageInputStream(stream));
        int lastX = 0;
        int lastY = 0;
        int width = -1;
        int height = -1;
        IIOMetadata metadata = reader.getStreamMetadata();
        Color backgroundColor = null;
        if (metadata != null) {
            IIOMetadataNode colorTable;
            IIOMetadataNode screenDescriptor;
            IIOMetadataNode globalRoot = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
            NodeList globalColorTable = globalRoot.getElementsByTagName("GlobalColorTable");
            NodeList globalScreeDescriptor = globalRoot.getElementsByTagName("LogicalScreenDescriptor");
            if (globalScreeDescriptor.getLength() > 0 && (screenDescriptor = (IIOMetadataNode)globalScreeDescriptor.item(0)) != null) {
                width = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenWidth"));
                height = Integer.parseInt(screenDescriptor.getAttribute("logicalScreenHeight"));
            }
            if (globalColorTable.getLength() > 0 && (colorTable = (IIOMetadataNode)globalColorTable.item(0)) != null) {
                String backgroundIndex = colorTable.getAttribute("backgroundColorIndex");
                for (IIOMetadataNode colorEntry = (IIOMetadataNode)colorTable.getFirstChild(); colorEntry != null; colorEntry = (IIOMetadataNode)colorEntry.getNextSibling()) {
                    if (!colorEntry.getAttribute("index").equals(backgroundIndex)) continue;
                    int red = Integer.parseInt(colorEntry.getAttribute("red"));
                    int green = Integer.parseInt(colorEntry.getAttribute("green"));
                    int blue = Integer.parseInt(colorEntry.getAttribute("blue"));
                    backgroundColor = StringUtils.getColorFrom(red, green, blue);
                    break;
                }
            }
        }
        BufferedImage master = null;
        boolean hasBackground = false;
        int frameIndex = 0;
        while (true) {
            BufferedImage image;
            try {
                image = reader.read(frameIndex);
            }
            catch (IndexOutOfBoundsException io) {
                break;
            }
            if (width == -1 || height == -1) {
                width = image.getWidth();
                height = image.getHeight();
            }
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(frameIndex).getAsTree("javax_imageio_gif_image_1.0");
            IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
            NodeList children = root.getChildNodes();
            int delay = Integer.parseInt(gce.getAttribute("delayTime"));
            String disposal = gce.getAttribute("disposalMethod");
            if (master == null) {
                master = new BufferedImage(width, height, 2);
                master.createGraphics().setColor(backgroundColor);
                master.createGraphics().fillRect(0, 0, master.getWidth(), master.getHeight());
                hasBackground = image.getWidth() == width && image.getHeight() == height;
                master.createGraphics().drawImage((Image)image, 0, 0, null);
            } else {
                int x = 0;
                int y = 0;
                for (int nodeIndex = 0; nodeIndex < children.getLength(); ++nodeIndex) {
                    Node nodeItem = children.item(nodeIndex);
                    if (!nodeItem.getNodeName().equals("ImageDescriptor")) continue;
                    NamedNodeMap map = nodeItem.getAttributes();
                    x = Integer.parseInt(map.getNamedItem("imageLeftPosition").getNodeValue());
                    y = Integer.parseInt(map.getNamedItem("imageTopPosition").getNodeValue());
                }
                if (disposal.equals("restoreToPrevious")) {
                    BufferedImage from = null;
                    for (int i = frameIndex - 1; i >= 0; --i) {
                        if (((ImageFrame)frames.get(i)).getDisposal().equals("restoreToPrevious") && frameIndex != 0) continue;
                        from = ((ImageFrame)frames.get(i)).getImage();
                        break;
                    }
                    if (from != null) {
                        master = ImageFrame.deepCopy(from);
                    }
                } else if (disposal.equals("restoreToBackgroundColor") && backgroundColor != null && (!hasBackground || frameIndex > 1)) {
                    master.createGraphics().fillRect(lastX, lastY, ((ImageFrame)frames.get(frameIndex - 1)).getWidth(), ((ImageFrame)frames.get(frameIndex - 1)).getHeight());
                }
                master.createGraphics().drawImage((Image)image, x, y, null);
                lastX = x;
                lastY = y;
            }
            BufferedImage copy = ImageFrame.deepCopy(master);
            class_1011 imgNew = ImageFrame.convertToNative(copy, true);
            frames.add(new ImageFrame(copy, imgNew, delay, disposal, image.getWidth(), image.getHeight()));
            master.flush();
            ++frameIndex;
        }
        reader.dispose();
        return frames.toArray(new ImageFrame[0]);
    }

    public static class_1011 convertToNative(BufferedImage img, boolean useStb) {
        class_1011 newImage = new class_1011(img.getWidth(), img.getHeight(), useStb);
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgb = img.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                rgb = (alpha & 0xFF) << 24 | (blue & 0xFF) << 16 | (green & 0xFF) << 8 | red & 0xFF;
                newImage.method_4305(x, y, rgb);
            }
        }
        return newImage;
    }

    public BufferedImage getImage() {
        return ImageFrame.deepCopy(this.image);
    }

    public class_1011 getNativeImage() {
        return this.nativeImage;
    }

    public int getDelay() {
        return this.delay;
    }

    public String getDisposal() {
        return this.disposal;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getRenderTime() {
        return this.renderTime;
    }

    public void setRenderTime(long renderTime) {
        this.renderTime = renderTime;
    }

    public boolean shouldRenderNext() {
        return TimeUtils.toEpoch() - this.getRenderTime() > (long)this.getDelay() * 10L;
    }
}

